/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer.sync.node;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfNode;
import kd.bos.nocode.ext.metadata.wf.info.CalcSettingItem;
import kd.bos.nocode.ext.metadata.wf.info.SettingItem;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeCalculate;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.AssignmentInfo;
import kd.bos.nocode.ext.wf.control.events.WfDesignerMetaSyncEvent;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.WfUtils;
import kd.bos.nocode.wf.designer.helper.AssignmentHelper;
import kd.bos.nocode.wf.designer.helper.WfDesignerCtx;
import kd.bos.nocode.wf.designer.sync.node.AbstractWfModelSyncWithMacro;
import kd.bos.workflow.api.model.MacroItem;
import kd.bos.workflow.api.model.NodeMacro;

public class WfModelCalculateSync
extends AbstractWfModelSyncWithMacro<NoCodeWfNodeCalculate> {
    public static final String ERROR = "error";

    public WfModelCalculateSync(WfDesignerCtx ctx, WfDesignerMetaSyncEvent syncArgs, NoCodeWfMetaData ncMetaData, NoCodeWfMetaData oldNcMetaData) {
        super(ctx, syncArgs, ncMetaData, oldNcMetaData);
    }

    @Override
    protected void genVars(NoCodeWfNodeCalculate node, JSONArray fieldVars) {
        super.genVars(node, fieldVars);
        NodeMacro macro = this.getMacroByNode((NoCodeWfNode)node);
        if (macro != null) {
            for (MacroItem item : macro.getItems()) {
                String newValue;
                String formId;
                if (this.isEmptyMacroItem(item)) continue;
                Map option = node.getOutParams().stream().filter(p -> p.getNumber().equalsIgnoreCase(item.getNumber())).map(p -> p.getOption()).findFirst().orElseGet(HashMap::new);
                String dataTypeCaption = NcEntityTypeUtil.getDataTypeCaption((String)item.getDataType(), (Map)option);
                String value = String.format("${proc.%s.%s}", macro.getNumber(), item.getNumber());
                if (NcEntityTypeUtil.isMultiRefBill((String)item.getDataType(), (Map)option)) {
                    formId = (String)option.get("billEntityId");
                    newValue = WfUtils.appendId((String)value);
                    this.expendChildrenToMultiRefBill(option, formId, newValue, true);
                } else if (NcEntityTypeUtil.isRefBill((String)item.getDataType())) {
                    formId = (String)option.get("billEntityId");
                    newValue = WfUtils.appendId((String)value);
                    this.expendChildrenToSimpleRefBill(option, formId, newValue, false);
                }
                this.addVar(NcEntityTypeUtil.getDataTitle((String)dataTypeCaption, (String)item.getName()), String.format("${proc.%s.%s}", macro.getNumber(), item.getNumber()), item.getDataType(), option, fieldVars, node);
            }
        }
    }

    @Override
    protected void genErrors(NoCodeWfNodeCalculate node, JSONArray errors) {
        List setting;
        if (StringUtils.isBlank((CharSequence)node.getName())) {
            WfModelCalculateSync.addRequiredErr("name", ResManager.loadKDString((String)"\u540d\u79f0", (String)"WfModelCalculateSync_0", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errors);
        }
        if ((setting = node.getSetting()) == null || setting.isEmpty()) {
            WfModelCalculateSync.addRequiredErr("setting", ResManager.loadKDString((String)"\u8fd0\u7b97\u8bbe\u7f6e", (String)"WfModelCalculateSync_1", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errors);
        } else {
            this.genError2Settings(setting, errors, node);
        }
    }

    @Override
    protected <S extends SettingItem> void checkSettingsRepeat(List<S> settings, JSONObject msg) {
        super.checkSettingsRepeat(settings, msg);
        Set repeatSet = settings.stream().filter(s -> StringUtils.isNotBlank((CharSequence)s.getAssignment()) && !"$assignment".equalsIgnoreCase(s.getAssignment())).collect(Collectors.groupingBy(s -> s.getAssignment(), Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (repeatSet.size() > 0) {
            List repeatSettings = settings.stream().filter(s -> repeatSet.contains(s.getAssignment())).collect(Collectors.toList());
            for (SettingItem s2 : repeatSettings) {
                JSONArray errs = new JSONArray();
                this.addErr(ERROR, ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u8d4b\u503c\u5bf9\u8c61", (String)"WfModelCalculateSync_2", (String)"bos-nocode-formplugin", (Object[])new Object[0]), "assignment", errs);
                msg.put(s2.getCalcId(), (Object)errs);
            }
        }
    }

    @Override
    protected <S extends SettingItem> void genError2Setting(S setting, JSONArray errs, NoCodeWfNodeCalculate node) {
        super.genError2Setting(setting, errs, node);
        CalcSettingItem calcSettingItem = (CalcSettingItem)setting;
        if (!calcSettingItem.isUpdateModel() && StringUtils.isBlank((CharSequence)calcSettingItem.getCustomVarName())) {
            WfModelCalculateSync.addRequiredErr("customVarName", ResManager.loadKDString((String)"\u5bf9\u8c61\u540d\u79f0", (String)"WfModelCalculateSync_3", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errs);
        }
    }

    @Override
    protected <S extends SettingItem> AssignmentInfo getAssignmentFieldInfo(S setting, NoCodeWfNodeCalculate node) {
        return AssignmentHelper.getAssignmentFieldInfoByCalc((CalcSettingItem)setting, this.ncMetaData);
    }

    @Override
    protected <S extends SettingItem> boolean genExpressionErrors(S setting, JSONArray errors, NoCodeWfNodeCalculate node) {
        boolean r = super.genExpressionErrors(setting, errors, node);
        if (r) {
            return true;
        }
        if (!((CalcSettingItem)setting).isUpdateModel() && WfConsts.CustomVarTypeEnum.getByCode((String)((CalcSettingItem)setting).getCustomVarType()) == WfConsts.CustomVarTypeEnum.NUMBER && !this.isNeedCheckExpression(setting, node)) {
            String expression = setting.getExpression();
            try {
                BigDecimal convertValue = (BigDecimal)ObjectConverter.convert((Object)expression, BigDecimal.class);
                if (convertValue != null && convertValue.scale() > 2) {
                    this.addErr(ERROR, ResManager.loadKDString((String)"\u53ea\u652f\u6301\u4e24\u4f4d\u5c0f\u6570", (String)"WfModelCalculateSync_4", (String)"bos-nocode-formplugin", (Object[])new Object[0]), "expression", errors);
                    return false;
                }
            }
            catch (NumberFormatException ne) {
                this.addErr(ERROR, ResManager.loadKDString((String)"\u65e0\u6548\u6570\u5b57", (String)"WfModelCalculateSync_5", (String)"bos-nocode-formplugin", (Object[])new Object[0]), "expression", errors);
                return false;
            }
        }
        return false;
    }
}

