/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer.sync.node;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfNode;
import kd.bos.nocode.ext.metadata.wf.info.CustomJsonRow;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeCustomJson;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.OutParam;
import kd.bos.nocode.ext.wf.control.events.WfDesignerMetaSyncEvent;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.wf.designer.helper.VariableHelper;
import kd.bos.nocode.wf.designer.helper.WfDesignerCtx;
import kd.bos.nocode.wf.designer.sync.node.AbstractWfModelSyncWithMacro;
import kd.bos.workflow.api.model.MacroItem;
import kd.bos.workflow.api.model.NodeMacro;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class WfModelCustomJsonSync
extends AbstractWfModelSyncWithMacro<NoCodeWfNodeCustomJson> {
    public WfModelCustomJsonSync(WfDesignerCtx ctx, WfDesignerMetaSyncEvent syncArgs, NoCodeWfMetaData ncMetaData, NoCodeWfMetaData oldNcMetaData) {
        super(ctx, syncArgs, ncMetaData, oldNcMetaData);
    }

    @Override
    protected void genErrors(NoCodeWfNodeCustomJson node, JSONArray errors) {
        if (StringUtils.isBlank((CharSequence)node.getName())) {
            WfModelCustomJsonSync.addRequiredErr("name", ResManager.loadKDString((String)"\u540d\u79f0", (String)"WfModelCustomJsonSync_0", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errors);
        }
        this.addSourceDataErr(node.getCustomJsonRowList(), errors, node);
    }

    private void addSourceDataErr(List<CustomJsonRow> customJsonRowList, JSONArray errors, NoCodeWfNodeCustomJson node) {
        JSONObject msg = new JSONObject();
        this.genSourceDataErrorList(customJsonRowList, node, msg);
        if (MapUtils.isEmpty((Map)msg)) {
            return;
        }
        JSONObject sourceDataError = new JSONObject();
        sourceDataError.put("type", (Object)"error");
        sourceDataError.put("msg", (Object)msg);
        sourceDataError.put("prop", (Object)"sourceData");
        errors.add((Object)sourceDataError);
    }

    private void genSourceDataErrorList(List<CustomJsonRow> customJsonRowList, NoCodeWfNodeCustomJson node, JSONObject msg) {
        for (CustomJsonRow customJsonRow : customJsonRowList) {
            JSONArray errs = new JSONArray();
            this.genSourceDataErrorSingle(customJsonRow, errs, node);
            if (CollectionUtils.isNotEmpty((Collection)errs)) {
                msg.put(customJsonRow.getId(), (Object)errs);
            }
            if (!CollectionUtils.isNotEmpty((Collection)customJsonRow.getChildren())) continue;
            this.genSourceDataErrorList(customJsonRow.getChildren(), node, msg);
        }
    }

    private void genSourceDataErrorSingle(CustomJsonRow customJsonRow, JSONArray errs, NoCodeWfNodeCustomJson node) {
        String valueType = customJsonRow.getValue().getType();
        if (CustomJsonRow.ValueTypeEnum.var.toString().equals(valueType) || CustomJsonRow.ValueTypeEnum.expression.toString().equals(valueType)) {
            String value = customJsonRow.getValue().getValue();
            Matcher mField = WfConsts.varPattern.matcher(value);
            while (mField.find()) {
                String varStr = mField.group();
                JSONObject variable = VariableHelper.findVariable(node.getId(), varStr, this.ctx.getVariables(), this.ncMetaData, this.ctx);
                if (variable != null && !variable.isEmpty()) continue;
                JSONObject err = new JSONObject();
                err.put("type", (Object)"error");
                err.put("msg", (Object)ResManager.loadKDString((String)"\u5b57\u6bb5\u5f15\u7528\u5931\u6548", (String)"WfModelCustomJsonSync_1", (String)"bos-nocode-formplugin", (Object[])new Object[0]));
                err.put("prop", (Object)"value");
                errs.add((Object)err);
            }
        }
    }

    @Override
    protected void genVars(NoCodeWfNodeCustomJson node, JSONArray fieldVars) {
        super.genVars(node, fieldVars);
        NodeMacro macro = this.getMacroByNode((NoCodeWfNode)node);
        if (Objects.isNull(macro)) {
            return;
        }
        List items = macro.getItems();
        for (MacroItem item : items) {
            if (this.isEmptyMacroItem(item)) continue;
            Map option = node.getOutParams().stream().filter(p -> p.getNumber().equalsIgnoreCase(item.getNumber())).map(OutParam::getOption).findFirst().orElseGet(HashMap::new);
            String value = String.format("${proc.%s.%s}", macro.getNumber(), item.getNumber());
            String dataTypeCaption = NcEntityTypeUtil.getDataTypeCaption((String)item.getDataType(), (Map)option);
            this.addVar(NcEntityTypeUtil.getDataTitle((String)dataTypeCaption, (String)item.getName()), value, item.getDataType(), option, fieldVars, node);
        }
    }
}

