/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer.sync.node;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.ext.constant.CompareTypeEnum;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.info.FilterItem;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeJudge;
import kd.bos.nocode.ext.wf.control.events.WfDesignerMetaSyncEvent;
import kd.bos.nocode.util.DataRangeCompareUtil;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.wf.designer.helper.VariableHelper;
import kd.bos.nocode.wf.designer.helper.WfDesignerCtx;
import kd.bos.nocode.wf.designer.sync.AbstractWfModelSync;
import org.apache.commons.collections.CollectionUtils;

public class WfModelJudgeSync
extends AbstractWfModelSync<NoCodeWfNodeJudge> {
    public WfModelJudgeSync(WfDesignerCtx ctx, WfDesignerMetaSyncEvent syncArgs, NoCodeWfMetaData ncMetaData) {
        super(ctx, syncArgs, ncMetaData);
    }

    @Override
    protected boolean hasVar(NoCodeWfNodeJudge node) {
        return true;
    }

    @Override
    protected void genVars(NoCodeWfNodeJudge node, JSONArray fieldVars) {
        this.addNodeNameVar(node, fieldVars);
    }

    @Override
    protected void genErrors(NoCodeWfNodeJudge node, JSONArray errors) {
        String filterValid;
        List filter;
        if (StringUtils.isBlank((CharSequence)node.getName())) {
            WfModelJudgeSync.addRequiredErr("name", ResManager.loadKDString((String)"\u540d\u79f0", (String)"WfModelJudgeSync_0", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errors);
        }
        if ((filter = node.getFilter()).isEmpty()) {
            WfModelJudgeSync.addRequiredErr("filter", ResManager.loadKDString((String)"\u5224\u65ad", (String)"WfModelJudgeSync_1", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errors);
        }
        if (StringUtils.isNotBlank((CharSequence)(filterValid = this.isFilterValid(node)))) {
            this.addErr("error", filterValid, "filter", errors);
        }
    }

    private String isFilterValid(NoCodeWfNodeJudge node) {
        List filters = node.getFilter();
        logger.debug("\u6d41\u7a0b\u6a21\u578bfilters: {}", (Object)SerializationUtils.toJsonString((Object)filters));
        if (filters == null || filters.isEmpty()) {
            return null;
        }
        for (FilterItem filter : filters) {
            if (StringUtils.isBlank((CharSequence)filter.getCompareType()) || StringUtils.isBlank((CharSequence)filter.getFieldName())) {
                return ResManager.loadKDString((String)"\u5224\u65ad\u6761\u4ef6\u4e0d\u5b8c\u6574", (String)"WfModelJudgeSync_2", (String)"bos-nocode-formplugin", (Object[])new Object[0]);
            }
            String filterItemValid = this.isFilterItemValid(filter, node);
            if (!StringUtils.isNotBlank((CharSequence)filterItemValid)) continue;
            return filterItemValid;
        }
        return null;
    }

    private String isFilterItemValid(FilterItem filter, NoCodeWfNodeJudge node) {
        String leftDataType = null;
        String leftCaption = null;
        Map leftDatacOption = null;
        Matcher mField = WfConsts.varPattern.matcher(filter.getFieldName());
        while (mField.find()) {
            String varStr = mField.group();
            JSONObject variable = VariableHelper.findVariable(node.getId(), varStr, this.ctx.getVariables(), this.ncMetaData, this.ctx);
            if (variable == null || variable.isEmpty()) {
                logger.debug("nocode: \u5b57\u6bb5\u5f15\u7528\u5931\u6548\uff1a{}", (Object)filter.getFieldName());
                return ResManager.loadKDString((String)"\u5b57\u6bb5\u5f15\u7528\u5931\u6548", (String)"WfModelJudgeSync_3", (String)"bos-nocode-formplugin", (Object[])new Object[0]);
            }
            leftDataType = VariableHelper.getVarType(variable);
            leftCaption = VariableHelper.getVarTitle(variable);
            leftDatacOption = (Map)variable.get((Object)"option");
        }
        if (!this.mustHasValue(filter)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)filter.getValue()) || "[]".equalsIgnoreCase(filter.getValue())) {
            return ResManager.loadKDString((String)"\u5224\u65ad\u6761\u4ef6\u4e0d\u5b8c\u6574", (String)"WfModelJudgeSync_2", (String)"bos-nocode-formplugin", (Object[])new Object[0]);
        }
        if (filter.getFieldName().startsWith("${proc.Proc") && filter.getFieldName().endsWith("AuditNumber}")) {
            JSONObject variable = VariableHelper.findVariable(node.getId(), filter.getFieldName(), this.ctx.getVariables(), this.ncMetaData, this.ctx);
            List valueList = Optional.ofNullable(variable).map(e -> variable.getJSONObject("option")).map(e -> e.getJSONArray("valueItems")).map(e -> e.stream().map(JSONObject.class::cast).map(v -> v.getString("value")).collect(Collectors.toList())).orElseGet(ArrayList::new);
            List values = SerializationUtils.fromJsonStringToList((String)filter.getValue(), Map.class);
            if (CollectionUtils.isEmpty((Collection)values)) {
                return ResManager.loadKDString((String)"\u5224\u65ad\u6761\u4ef6\u4e0d\u5b8c\u6574", (String)"WfModelJudgeSync_2", (String)"bos-nocode-formplugin", (Object[])new Object[0]);
            }
            String fieldValue = (String)((Map)values.get(0)).get("fieldValue");
            if (!valueList.contains(fieldValue)) {
                return ResManager.loadKDString((String)"\u5224\u65ad\u6761\u4ef6\u4e0d\u5b8c\u6574", (String)"WfModelJudgeSync_2", (String)"bos-nocode-formplugin", (Object[])new Object[0]);
            }
        }
        String sError = null;
        String rightDataType = null;
        Map rightDatacOption = null;
        String rightCaption = null;
        Matcher mValue = WfConsts.varPattern.matcher(filter.getValue());
        while (mValue.find()) {
            String varStr = mValue.group();
            JSONObject variable = VariableHelper.findVariable(node.getId(), varStr, this.ctx.getVariables(), this.ncMetaData, this.ctx);
            if (variable == null || variable.isEmpty()) {
                return ResManager.loadKDString((String)"\u5b57\u6bb5\u503c\u5f15\u7528\u5931\u6548", (String)"WfModelJudgeSync_4", (String)"bos-nocode-formplugin", (Object[])new Object[0]);
            }
            rightDataType = VariableHelper.getVarType(variable);
            rightCaption = VariableHelper.getVarTitle(variable);
            rightDatacOption = (Map)variable.get((Object)"option");
        }
        if (leftDataType != null && rightDataType != null && NcEntityTypeUtil.isRefBill((String)leftDataType) && !NcEntityTypeUtil.isTypeCanCompare2RefBill(rightDataType, (String)leftDataType, rightDatacOption, (Map)leftDatacOption)) {
            return ResManager.loadKDString((String)"\u5de6\u53f3\u4e24\u8fb9\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d", (String)"WfModelJudgeSync_5", (String)"bos-nocode-formplugin", (Object[])new Object[0]);
        }
        sError = DataRangeCompareUtil.isFilterValueValid2DateRange((FilterItem)filter, (String)ResManager.loadKDString((String)"\u5224\u65ad\u6761\u4ef6", (String)"WfModelJudgeSync_6", (String)"bos-nocode-formplugin", (Object[])new Object[0]));
        return sError;
    }

    private boolean mustHasValue(FilterItem filter) {
        return !CompareTypeEnum.EMPTY.getId().equalsIgnoreCase(filter.getCompareType()) && !CompareTypeEnum.NOT_EMPTY.getId().equalsIgnoreCase(filter.getCompareType()) && !CompareTypeEnum.CUR_USER.getId().equalsIgnoreCase(filter.getCompareType()) && !CompareTypeEnum.NOT_CUR_USER.getId().equalsIgnoreCase(filter.getCompareType()) && !CompareTypeEnum.CUR_USER_ORG.getId().equalsIgnoreCase(filter.getCompareType()) && !CompareTypeEnum.NOT_CUR_USER_ORG.getId().equalsIgnoreCase(filter.getCompareType());
    }
}

