/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer.sync.node;

import com.alibaba.fastjson.JSONArray;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfNode;
import kd.bos.nocode.ext.metadata.wf.info.NewSettingItem;
import kd.bos.nocode.ext.metadata.wf.info.SettingItem;
import kd.bos.nocode.ext.metadata.wf.nodes.IHasFormId;
import kd.bos.nocode.ext.metadata.wf.nodes.IHasTriggerProcess;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeApiInvoke;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeNewBill;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.AssignmentInfo;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.NoCodeWfNodeAutoMicroSrv;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.OutParam;
import kd.bos.nocode.ext.wf.control.events.WfDesignerMetaSyncEvent;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.nocode.utils.WfUtils;
import kd.bos.nocode.wf.designer.helper.AssignmentHelper;
import kd.bos.nocode.wf.designer.helper.VariableHelper;
import kd.bos.nocode.wf.designer.helper.WfDesignerCtx;
import kd.bos.nocode.wf.designer.sync.node.AbstractWfModelSyncWithMacro;
import kd.bos.workflow.api.model.MacroItem;
import kd.bos.workflow.api.model.NodeMacro;

public class WfModelNewBillSync
extends AbstractWfModelSyncWithMacro<NoCodeWfNodeNewBill> {
    public static final String ERROR = "error";

    public WfModelNewBillSync(WfDesignerCtx ctx, WfDesignerMetaSyncEvent syncArgs, NoCodeWfMetaData ncMetaData, NoCodeWfMetaData oldNcMetaData) {
        super(ctx, syncArgs, ncMetaData, oldNcMetaData);
    }

    @Override
    protected void genVars(NoCodeWfNodeNewBill node, JSONArray fieldVars) {
        super.genVars(node, fieldVars);
        NodeMacro macro = this.getMacroByNode((NoCodeWfNode)node);
        if (macro != null) {
            for (MacroItem item : macro.getItems()) {
                String newValue;
                String formId;
                if (this.isEmptyMacroItem(item)) continue;
                Map option = node.getOutParams().stream().filter(p -> p.getNumber().equalsIgnoreCase(item.getNumber())).map(p -> p.getOption()).findFirst().orElseGet(HashMap::new);
                String value = String.format("${proc.%s.%s}", macro.getNumber(), item.getNumber());
                if ("QueryDataSet".equalsIgnoreCase(item.getNumber())) {
                    formId = node.getFormId();
                    this.expendChildrenToMultiRefBill(option, formId, value, false);
                } else if (NcEntityTypeUtil.isMultiRefBill((String)item.getDataType(), (Map)option)) {
                    formId = (String)option.get("billEntityId");
                    newValue = WfUtils.appendId((String)value);
                    this.expendChildrenToMultiRefBill(option, formId, newValue, true);
                } else if (NcEntityTypeUtil.isRefBill((String)item.getDataType())) {
                    formId = (String)option.get("billEntityId");
                    newValue = WfUtils.appendId((String)value);
                    this.expendChildrenToSimpleRefBill(option, formId, newValue, false);
                }
                String dataTypeCaption = NcEntityTypeUtil.getDataTypeCaption((String)item.getDataType(), (Map)option);
                this.addVar(NcEntityTypeUtil.getDataTitle((String)dataTypeCaption, (String)item.getName()), value, item.getDataType(), option, fieldVars, node);
            }
        }
    }

    @Override
    protected void genErrors(NoCodeWfNodeNewBill node, JSONArray errors) {
        String formId;
        if (StringUtils.isBlank((CharSequence)node.getName())) {
            WfModelNewBillSync.addRequiredErr("name", ResManager.loadKDString((String)"\u540d\u79f0", (String)"WfModelNewBillSync_0", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errors);
        }
        if (StringUtils.isBlank((CharSequence)(formId = node.getFormId()))) {
            WfModelNewBillSync.addRequiredErr("formId", ResManager.loadKDString((String)"\u9009\u62e9\u8868\u5355", (String)"WfModelNewBillSync_1", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errors);
        }
        if (StringUtils.isNotBlank((CharSequence)formId) && !NcEntityTypeUtil.isFormExist((String)node.getFormId())) {
            this.addErr(ERROR, ResManager.loadKDString((String)"\u5173\u8054\u8868\u5355\u4e0d\u5b58\u5728", (String)"WfModelNewBillSync_2", (String)"bos-nocode-formplugin", (Object[])new Object[0]), "formId", errors);
        } else if (!NoCodePermHelper.checkPublishEnt((String)this.ctx.getAppId(), (String)node.getFormId())) {
            this.addErr(ERROR, ResManager.loadKDString((String)"\u8de8\u5e94\u7528\u8868\u5355\u672a\u6388\u6743", (String)"WfModelNewBillSync_3", (String)"bos-nocode-formplugin", (Object[])new Object[0]), "formId", errors);
        }
        if (node.getNewMode() == WfConsts.NewModeEnum.multi) {
            if (StringUtils.isBlank((CharSequence)node.getLoopby())) {
                WfModelNewBillSync.addRequiredErr("loopby", ResManager.loadKDString((String)"\u57fa\u4e8e\u7684\u591a\u6761\u8bb0\u5f55", (String)"WfModelNewBillSync_4", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errors);
            } else {
                NoCodeWfNode refNode = VariableHelper.getRefNode(node.getId(), node.getLoopby(), this.ncMetaData, this.ctx);
                if (!(refNode instanceof NoCodeWfNodeApiInvoke) && VariableHelper.getVarOfNodeFormPkId(node.getId(), node.getLoopby(), this.ncMetaData, this.ctx.getVariables(), this.ctx) == null) {
                    this.addErr(ERROR, ResManager.loadKDString((String)"\u5173\u8054\u7684\u8868\u5355\u8bb0\u5f55\u5931\u6548", (String)"WfModelNewBillSync_5", (String)"bos-nocode-formplugin", (Object[])new Object[0]), "loopby", errors);
                } else if (!this.isMultiRefNode(node)) {
                    this.addErr(ERROR, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u591a\u6761\u8868\u5355\u8bb0\u5f55\u7684\u8282\u70b9", (String)"WfModelNewBillSync_6", (String)"bos-nocode-formplugin", (Object[])new Object[0]), "loopby", errors);
                }
            }
        }
        this.genErrors_TriggerProcess((IHasTriggerProcess)node, errors);
        List setting = node.getSetting();
        if (setting != null && !setting.isEmpty()) {
            this.genError2Settings(setting, errors, node);
        }
    }

    @Override
    protected <S extends SettingItem> boolean genAssignmentErrors(S setting, JSONArray errors, NoCodeWfNodeNewBill node) {
        return false;
    }

    @Override
    protected <S extends SettingItem> boolean isExpressionMustInput(S setting, NoCodeWfNodeNewBill node) {
        Optional<OutParam> first = node.getOutParams().stream().filter(p -> p.getNumber() == setting.getAssignment()).findFirst();
        if (!first.isPresent()) {
            return false;
        }
        OutParam outParam = first.get();
        return outParam.getOption().getOrDefault("required", false);
    }

    @Override
    protected <S extends SettingItem> String getAssignmentTitle(S setting, NoCodeWfNodeNewBill node) {
        Optional<OutParam> first = node.getOutParams().stream().filter(p -> p.getNumber() == setting.getAssignment()).findFirst();
        if (!first.isPresent()) {
            return null;
        }
        OutParam outParam = first.get();
        return outParam.getName();
    }

    @Override
    protected <S extends SettingItem> AssignmentInfo getAssignmentFieldInfo(S setting, NoCodeWfNodeNewBill node) {
        return AssignmentHelper.getAssignmentFieldInfoByNewBill(node, (NewSettingItem)setting);
    }

    private boolean isMultiRefNode(NoCodeWfNodeNewBill node) {
        NoCodeWfNode loopByRefNode = this.getLoopByRefNode(node);
        if (loopByRefNode == null || !(loopByRefNode instanceof NoCodeWfNodeAutoMicroSrv)) {
            return false;
        }
        List outParams = ((NoCodeWfNodeAutoMicroSrv)loopByRefNode).getOutParams();
        return outParams.stream().anyMatch(o -> "QueryDataSet".equalsIgnoreCase(o.getNumber()));
    }

    private NoCodeWfNode getLoopByRefNode(NoCodeWfNodeNewBill node) {
        String nodeId = node.getLoopby();
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return null;
        }
        Optional<NoCodeWfNode> first = this.ncMetaData.getNodes().stream().filter(n -> nodeId.equalsIgnoreCase(n.getId())).findFirst();
        if (first.isPresent()) {
            return first.get();
        }
        return null;
    }

    private String getLoopByFormId(NoCodeWfNodeNewBill node) {
        NoCodeWfNode loopByRefNode = this.getLoopByRefNode(node);
        if (loopByRefNode == null || !(loopByRefNode instanceof IHasFormId)) {
            return null;
        }
        return ((IHasFormId)loopByRefNode).getTargetFormId();
    }
}

