/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer.sync.node;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.ext.constant.CompareTypeEnum;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfNode;
import kd.bos.nocode.ext.metadata.wf.info.FilterItem;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeQueryData;
import kd.bos.nocode.ext.wf.control.events.WfDesignerMetaSyncEvent;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.util.DataRangeCompareUtil;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.nocode.utils.OpenApiUtil;
import kd.bos.nocode.utils.ShowColumnInfo;
import kd.bos.nocode.utils.WfUtils;
import kd.bos.nocode.wf.designer.helper.VariableHelper;
import kd.bos.nocode.wf.designer.helper.WfDesignerCtx;
import kd.bos.nocode.wf.designer.sync.node.AbstractWfModelSyncWithMacro;
import kd.bos.workflow.api.model.MacroItem;
import kd.bos.workflow.api.model.NodeMacro;

public class WfModelQueryDataSync
extends AbstractWfModelSyncWithMacro<NoCodeWfNodeQueryData> {
    public WfModelQueryDataSync(WfDesignerCtx ctx, WfDesignerMetaSyncEvent syncArgs, NoCodeWfMetaData ncMetaData, NoCodeWfMetaData oldNcMetaData) {
        super(ctx, syncArgs, ncMetaData, oldNcMetaData);
    }

    @Override
    protected void genVars(NoCodeWfNodeQueryData node, JSONArray fieldVars) {
        block12: {
            super.genVars(node, fieldVars);
            NodeMacro macro = this.getMacroByNode((NoCodeWfNode)node);
            if (macro == null) break block12;
            if (WfConsts.QueryModeEnum.byapi == node.getQueryModel()) {
                for (MacroItem item : macro.getItems()) {
                    if (this.isEmptyMacroItem(item)) continue;
                    Map option = node.getOutParams().stream().filter(p -> p.getNumber().equalsIgnoreCase(item.getNumber())).map(p -> p.getOption()).findFirst().orElseGet(HashMap::new);
                    if (WfModelQueryDataSync.isQueryResultMacro(item)) {
                        option.put("valueItems", WfConsts.QueryResultEnum.getItems());
                        option.put("isResult", true);
                    }
                    String value = String.format("${proc.%s.%s}", macro.getNumber(), item.getNumber());
                    if ("QueryDataSet".equalsIgnoreCase(item.getNumber())) {
                        String formId = this.getFormId(node);
                        this.expendChildrenToMultiByApi(option, node.getApiId(), formId, value, false);
                    }
                    String dataTypeCaption = NcEntityTypeUtil.getDataTypeCaption((String)item.getDataType(), (Map)option);
                    this.addVar(NcEntityTypeUtil.getDataTitle((String)dataTypeCaption, (String)item.getName()), value, item.getDataType(), option, fieldVars, node);
                }
            } else {
                for (MacroItem item : macro.getItems()) {
                    String newValue;
                    String formId;
                    if (this.isEmptyMacroItem(item)) continue;
                    Map option = node.getOutParams().stream().filter(p -> p.getNumber().equalsIgnoreCase(item.getNumber())).map(p -> p.getOption()).findFirst().orElseGet(HashMap::new);
                    if (WfModelQueryDataSync.isQueryResultMacro(item)) {
                        option.put("valueItems", WfConsts.QueryResultEnum.getItems());
                        option.put("isResult", true);
                    }
                    String value = String.format("${proc.%s.%s}", macro.getNumber(), item.getNumber());
                    if ("QueryDataSet".equalsIgnoreCase(item.getNumber())) {
                        formId = this.getFormId(node);
                        this.expendChildrenToMultiRefBill(option, formId, value, false);
                    } else if (NcEntityTypeUtil.isMultiRefBill((String)item.getDataType(), (Map)option)) {
                        formId = (String)option.get("billEntityId");
                        newValue = WfUtils.appendId((String)value);
                        this.expendChildrenToMultiRefBill(option, formId, newValue, true);
                    } else if (NcEntityTypeUtil.isRefBill((String)item.getDataType())) {
                        formId = (String)option.get("billEntityId");
                        newValue = WfUtils.appendId((String)value);
                        this.expendChildrenToSimpleRefBill(option, formId, newValue, false);
                    }
                    String dataTypeCaption = NcEntityTypeUtil.getDataTypeCaption((String)item.getDataType(), (Map)option);
                    this.addVar(NcEntityTypeUtil.getDataTitle((String)dataTypeCaption, (String)item.getName()), value, item.getDataType(), option, fieldVars, node);
                }
            }
        }
    }

    private static boolean isQueryResultMacro(MacroItem item) {
        return "QueryResult".equalsIgnoreCase(item.getNumber());
    }

    @Override
    protected void genErrors(NoCodeWfNodeQueryData node, JSONArray errors) {
        if (StringUtils.isBlank((CharSequence)node.getName())) {
            WfModelQueryDataSync.addRequiredErr("name", ResManager.loadKDString((String)"\u540d\u79f0", (String)"WfModelQueryDataSync_0", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errors);
        }
        if (WfConsts.QueryModeEnum.byfilter == node.getQueryModel()) {
            this.genErrorByFilter(node, errors);
        } else if (WfConsts.QueryModeEnum.byapi == node.getQueryModel()) {
            this.genErrorByApi(node, errors);
        } else {
            this.genErrorByRela(node, errors);
        }
    }

    private void genErrorByFilter(NoCodeWfNodeQueryData node, JSONArray errors) {
        String formId = node.getFormId();
        if (StringUtils.isBlank((CharSequence)formId)) {
            WfModelQueryDataSync.addRequiredErr("formId", ResManager.loadKDString((String)"\u67e5\u627e\u8868\u5355", (String)"WfModelQueryDataSync_1", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errors);
        }
        if (StringUtils.isNotBlank((CharSequence)formId) && !NcEntityTypeUtil.isFormExist((String)node.getFormId())) {
            this.addErr("error", ResManager.loadKDString((String)"\u5173\u8054\u8868\u5355\u4e0d\u5b58\u5728", (String)"WfModelQueryDataSync_2", (String)"bos-nocode-formplugin", (Object[])new Object[0]), "formId", errors);
        } else if (!NoCodePermHelper.checkPublishEnt((String)this.ctx.getAppId(), (String)node.getFormId())) {
            this.addErr("error", ResManager.loadKDString((String)"\u8de8\u5e94\u7528\u8868\u5355\u672a\u6388\u6743", (String)"WfModelQueryDataSync_3", (String)"bos-nocode-formplugin", (Object[])new Object[0]), "formId", errors);
        }
        String filterValid = this.isFilterValid(node);
        if (StringUtils.isNotBlank((CharSequence)filterValid)) {
            this.addErr("error", filterValid, "filter", errors);
        }
    }

    private void genErrorByApi(NoCodeWfNodeQueryData node, JSONArray errors) {
        String filterValid;
        String apiId = node.getApiId();
        if (StringUtils.isBlank((CharSequence)apiId)) {
            WfModelQueryDataSync.addRequiredErr("apiId", ResManager.loadKDString((String)"\u67e5\u627e\u8868\u5355", (String)"WfModelQueryDataSync_1", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errors);
        }
        if (StringUtils.isNotBlank((CharSequence)apiId) && !OpenApiUtil.isApiExist((String)apiId)) {
            this.addErr("error", ResManager.loadKDString((String)"\u5173\u8054Api\u4e0d\u5b58\u5728", (String)"WfModelQueryDataSync_4", (String)"bos-nocode-formplugin", (Object[])new Object[0]), "apiId", errors);
        }
        if (StringUtils.isNotBlank((CharSequence)(filterValid = this.isFilterValidForApi(node)))) {
            this.addErr("error", filterValid, "apiFilter", errors);
        }
    }

    private void genErrorByRela(NoCodeWfNodeQueryData node, JSONArray errors) {
        String relaFormId;
        String refbillField = node.getRefbillField();
        if (StringUtils.isBlank((CharSequence)refbillField)) {
            WfModelQueryDataSync.addRequiredErr("refbillField", ResManager.loadKDString((String)"\u9009\u62e9\u5173\u8054\u8868\u5355", (String)"WfModelQueryDataSync_5", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errors);
        } else if (VariableHelper.findVariable(node.getId(), refbillField, this.variables, this.ncMetaData, this.ctx) == null) {
            this.addErr("error", ResManager.loadKDString((String)"\u5173\u8054\u8868\u5355\u5f15\u7528\u5931\u6548", (String)"WfModelQueryDataSync_6", (String)"bos-nocode-formplugin", (Object[])new Object[0]), "refbillField", errors);
        } else if (VariableHelper.isAssigneeVar(refbillField)) {
            this.addErr("error", ResManager.loadKDString((String)"\u5173\u8054\u8868\u5355\u5f15\u7528\u975e\u6cd5", (String)"WfModelQueryDataSync_7", (String)"bos-nocode-formplugin", (Object[])new Object[0]), "refbillField", errors);
        }
        if (StringUtils.isNotBlank((CharSequence)node.getRefBillFormId()) && (StringUtils.isBlank((CharSequence)(relaFormId = node.getRefBillFormId())) || !NcEntityTypeUtil.isFormExist((String)relaFormId))) {
            this.addErr("error", ResManager.loadKDString((String)"\u5173\u8054\u8868\u5355\u4e0d\u5b58\u5728", (String)"WfModelQueryDataSync_2", (String)"bos-nocode-formplugin", (Object[])new Object[0]), "refbillField", errors);
        }
    }

    private String isFilterValid(NoCodeWfNodeQueryData node) {
        List filters = node.getFilter();
        logger.debug("\u6d41\u7a0b\u6a21\u578bfilters: {}", (Object)SerializationUtils.toJsonString((Object)filters));
        if (filters == null || filters.isEmpty()) {
            return null;
        }
        for (FilterItem filter : filters) {
            if (StringUtils.isBlank((CharSequence)filter.getCompareType()) || StringUtils.isBlank((CharSequence)filter.getFieldName())) {
                return ResManager.loadKDString((String)"\u7b5b\u9009\u6761\u4ef6\u4e0d\u5b8c\u6574", (String)"WfModelQueryDataSync_8", (String)"bos-nocode-formplugin", (Object[])new Object[0]);
            }
            String filterValueValid = this.isFilterValueValid(filter, node);
            if (!StringUtils.isNotBlank((CharSequence)filterValueValid)) continue;
            return filterValueValid;
        }
        return null;
    }

    private String isFilterValueValid(FilterItem filter, NoCodeWfNodeQueryData node) {
        String leftDataType;
        BillEntityType dt = NcEntityTypeUtil.getMainEntityType((String)node.getFormId());
        String leftCaption = null;
        HashMap<String, String> leftDatacOption = new HashMap<String, String>(1);
        if (Objects.isNull(dt)) {
            leftDataType = "unknown";
        } else {
            IDataEntityProperty property = NcEntityTypeUtil.findProperty((DynamicObjectType)dt, (String)filter.getFieldName());
            if (Objects.isNull(property)) {
                return ResManager.loadKDString((String)"\u5b57\u6bb5\u5f15\u7528\u5931\u6548", (String)"WfModelQueryDataSync_9", (String)"bos-nocode-formplugin", (Object[])new Object[0]);
            }
            leftDataType = NcEntityTypeUtil.getDataType((IDataEntityProperty)property);
            leftCaption = property.getDisplayName().toString();
            if (property instanceof INoCodeRefBillProp) {
                leftDatacOption.put("billEntityId", ((INoCodeRefBillProp)property).getBillEntityId());
            }
        }
        if (!this.mustHasValue(filter)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)filter.getValue()) || "[]".equalsIgnoreCase(filter.getValue())) {
            return ResManager.loadKDString((String)"\u7b5b\u9009\u6761\u4ef6\u4e0d\u5b8c\u6574", (String)"WfModelQueryDataSync_8", (String)"bos-nocode-formplugin", (Object[])new Object[0]);
        }
        String sError = null;
        Matcher m = WfConsts.varPattern.matcher(filter.getValue());
        while (m.find()) {
            String varStr = m.group();
            JSONObject variable = VariableHelper.findVariable(node.getId(), varStr, this.ctx.getVariables(), this.ncMetaData, this.ctx);
            if (variable == null || variable.isEmpty()) {
                return ResManager.loadKDString((String)"\u5b57\u6bb5\u503c\u5f15\u7528\u5931\u6548", (String)"WfModelQueryDataSync_10", (String)"bos-nocode-formplugin", (Object[])new Object[0]);
            }
            String rightDataType = VariableHelper.getVarType(variable);
            Map rightDatacOption = (Map)variable.get((Object)"option");
            if (!NcEntityTypeUtil.isRefBill((String)leftDataType) || NcEntityTypeUtil.isTypeCanCompare2RefBill((String)rightDataType, (String)leftDataType, (Map)rightDatacOption, leftDatacOption)) continue;
            return ResManager.loadKDString((String)"\u5de6\u53f3\u4e24\u8fb9\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d", (String)"WfModelQueryDataSync_11", (String)"bos-nocode-formplugin", (Object[])new Object[0]);
        }
        sError = DataRangeCompareUtil.isFilterValueValid2DateRange((FilterItem)filter, (String)ResManager.loadKDString((String)"\u7b5b\u9009\u6761\u4ef6", (String)"WfModelQueryDataSync_12", (String)"bos-nocode-formplugin", (Object[])new Object[0]));
        return sError;
    }

    private boolean mustHasValue(FilterItem filter) {
        return !CompareTypeEnum.EMPTY.getId().equalsIgnoreCase(filter.getCompareType()) && !CompareTypeEnum.NOT_EMPTY.getId().equalsIgnoreCase(filter.getCompareType()) && !CompareTypeEnum.CUR_USER.getId().equalsIgnoreCase(filter.getCompareType()) && !CompareTypeEnum.NOT_CUR_USER.getId().equalsIgnoreCase(filter.getCompareType()) && !CompareTypeEnum.CUR_USER_ORG.getId().equalsIgnoreCase(filter.getCompareType()) && !CompareTypeEnum.NOT_CUR_USER_ORG.getId().equalsIgnoreCase(filter.getCompareType());
    }

    private String isFilterValidForApi(NoCodeWfNodeQueryData node) {
        List openApiInParams;
        List filters = node.getApiFilter();
        String filterMustInputForApi = this.isFilterMustInputForApi(filters, node, openApiInParams = OpenApiUtil.getOpenApiInParams((String)node.getApiId(), (boolean)false));
        if (StringUtils.isNotBlank((CharSequence)filterMustInputForApi)) {
            return filterMustInputForApi;
        }
        if (filters != null && !filters.isEmpty()) {
            for (FilterItem filter : filters) {
                if (StringUtils.isBlank((CharSequence)filter.getCompareType()) || StringUtils.isBlank((CharSequence)filter.getFieldName())) {
                    return ResManager.loadKDString((String)"\u7b5b\u9009\u6761\u4ef6\u4e0d\u5b8c\u6574", (String)"WfModelQueryDataSync_8", (String)"bos-nocode-formplugin", (Object[])new Object[0]);
                }
                String filterValueValid = this.isFilterValueValidForApi(filter, node);
                if (!StringUtils.isNotBlank((CharSequence)filterValueValid)) continue;
                return filterValueValid;
            }
        }
        return null;
    }

    private String isFilterValueValidForApi(FilterItem filter, NoCodeWfNodeQueryData node) {
        if (!this.mustHasValue(filter)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)filter.getValue()) || "[]".equalsIgnoreCase(filter.getValue())) {
            return ResManager.loadKDString((String)"\u7b5b\u9009\u6761\u4ef6\u4e0d\u5b8c\u6574", (String)"WfModelQueryDataSync_8", (String)"bos-nocode-formplugin", (Object[])new Object[0]);
        }
        String sError = null;
        Matcher m = WfConsts.varPattern.matcher(filter.getValue());
        while (m.find()) {
            String varStr = m.group();
            JSONObject variable = VariableHelper.findVariable(node.getId(), varStr, this.ctx.getVariables(), this.ncMetaData, this.ctx);
            if (variable != null && !variable.isEmpty()) continue;
            return ResManager.loadKDString((String)"\u5b57\u6bb5\u503c\u5f15\u7528\u5931\u6548", (String)"WfModelQueryDataSync_10", (String)"bos-nocode-formplugin", (Object[])new Object[0]);
        }
        return sError;
    }

    private String isFilterMustInputForApi(List<FilterItem> filters, NoCodeWfNodeQueryData node, List<ShowColumnInfo> openApiInParams) {
        if (openApiInParams == null || openApiInParams.isEmpty()) {
            return null;
        }
        for (ShowColumnInfo openApiInParam : openApiInParams) {
            boolean exist;
            Object mustInputObj = openApiInParam.getOption().get("mustInput");
            if (mustInputObj == null || !Boolean.parseBoolean(mustInputObj.toString()) || (exist = filters != null && !filters.isEmpty() && filters.stream().anyMatch(f -> f.getFieldName().equalsIgnoreCase(openApiInParam.getId()) && f.getValue() != null))) continue;
            return ResManager.loadKDString((String)"[%s]\u662f\u5fc5\u5f55\u7684\u53c2\u6570\uff0c\u8bf7\u9009\u62e9\u53c2\u6570", (String)"WfModelQueryDataSync_13", (String)"bos-nocode-formplugin", (Object[])new Object[]{openApiInParam.getCaption()});
        }
        return null;
    }

    private String getFormId(NoCodeWfNodeQueryData node) {
        if (WfConsts.QueryModeEnum.byfilter == node.getQueryModel()) {
            return node.getFormId();
        }
        if (WfConsts.QueryModeEnum.byapi == node.getQueryModel()) {
            return OpenApiUtil.getFormIdByApiId((String)node.getApiId());
        }
        return VariableHelper.getFormIdFromRefbillVariable(node.getId(), node.getRefbillField(), this.ctx.getVariables(), this.ncMetaData, this.ctx);
    }
}

