/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer.sync.node;

import com.alibaba.fastjson.JSONArray;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.nocode.constant.LoopTypeEnum;
import kd.bos.nocode.constant.TriggerModeEnum;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.ext.constant.CompareTypeEnum;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.info.FilterItem;
import kd.bos.nocode.ext.metadata.wf.info.TriggerTime;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeStart;
import kd.bos.nocode.ext.wf.control.events.WfDesignerMetaSyncEvent;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.nocode.utils.ShowColumnInfo;
import kd.bos.nocode.utils.WfUtils;
import kd.bos.nocode.wf.designer.helper.VariableHelper;
import kd.bos.nocode.wf.designer.helper.WfDesignerCtx;
import kd.bos.nocode.wf.designer.sync.AbstractWfModelSync;
import org.apache.commons.collections4.CollectionUtils;

public class WfModelStartSync
extends AbstractWfModelSync<NoCodeWfNodeStart> {
    public WfModelStartSync(WfDesignerCtx ctx, WfDesignerMetaSyncEvent syncArgs, NoCodeWfMetaData ncMetaData) {
        super(ctx, syncArgs, ncMetaData);
    }

    @Override
    protected boolean hasVar(NoCodeWfNodeStart node) {
        return StringUtils.isNotBlank((CharSequence)node.getFormIdWithoutAppId());
    }

    @Override
    protected void genVars(NoCodeWfNodeStart node, JSONArray fieldVars) {
        List<ShowColumnInfo> showColumns;
        String formId = Objects.equals(node.getTriggerMode(), TriggerModeEnum.TIME.getCode()) ? node.getEntityNumberWithoutAppId() : node.getFormIdWithoutAppId();
        if (NcEntityTypeUtil.isFormExist((String)formId) && (showColumns = VariableHelper.getShowColumnsIncludePk(formId)) != null && !showColumns.isEmpty()) {
            for (ShowColumnInfo showColumn : showColumns) {
                String value = String.format("${model.%s}", showColumn.getId());
                boolean multiRefBill = NcEntityTypeUtil.isMultiRefBill((String)showColumn.getType(), (Map)showColumn.getOption());
                if (multiRefBill) {
                    String refFormId = (String)showColumn.getOption().get("billEntityId");
                    String newValue = WfUtils.appendId((String)value);
                    this.expendChildrenToMultiRefBill(showColumn.getOption(), refFormId, newValue, true);
                }
                this.addVar(NcEntityTypeUtil.getDataTitle((String)showColumn.getTypeCaption(), (String)showColumn.getCaption()), value, showColumn.getType(), showColumn.getOption(), fieldVars, node);
                if (!NcEntityTypeUtil.isRefBill((String)showColumn.getType()) || "pk".equalsIgnoreCase(showColumn.getType())) continue;
                value = String.format("${model.%s}", showColumn.getId() + ".id");
                HashMap<String, Object> newOption = new HashMap<String, Object>();
                newOption.putAll(showColumn.getOption());
                newOption.put("visible", false);
                newOption.put("multiPk", multiRefBill);
                this.addVar("visible", value, "pk", newOption, fieldVars, node);
                if (multiRefBill) continue;
                String refFormId = (String)showColumn.getOption().get("billEntityId");
                this.expendChildrenToSimpleRefBill(showColumn.getOption(), refFormId, value, false);
            }
        }
    }

    @Override
    protected void genErrors(NoCodeWfNodeStart node, JSONArray errors) {
        if (StringUtils.isBlank((CharSequence)node.getName())) {
            WfModelStartSync.addRequiredErr("name", ResManager.loadKDString((String)"\u540d\u79f0", (String)"WfModelStartSync_0", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errors);
        }
        String formId = node.getFormIdWithoutAppId();
        if (Objects.equals(node.getTriggerMode(), TriggerModeEnum.BILL.getCode())) {
            if (StringUtils.isBlank((CharSequence)formId)) {
                WfModelStartSync.addRequiredErr("formId", WfConsts.getFireFormName(), errors);
            } else if (!NcEntityTypeUtil.isFormExist((String)formId)) {
                this.addErr("error", ResManager.loadKDString((String)"\u5173\u8054\u8868\u5355\u4e0d\u5b58\u5728", (String)"WfModelStartSync_1", (String)"bos-nocode-formplugin", (Object[])new Object[0]), "formId", errors);
            } else if (!NoCodePermHelper.checkPublishEnt((String)this.ctx.getAppId(), (String)node.getFormId())) {
                this.addErr("error", ResManager.loadKDString((String)"\u8de8\u5e94\u7528\u8868\u5355\u672a\u6388\u6743", (String)"WfModelStartSync_2", (String)"bos-nocode-formplugin", (Object[])new Object[0]), "formId", errors);
            }
        } else {
            String filterValid;
            String queryFormId = node.getQueryFormId();
            if (StringUtils.isBlank((CharSequence)queryFormId)) {
                WfModelStartSync.addRequiredErr("queryFormId", WfConsts.getNodeStartQueryFormName(), errors);
            } else if (!NcEntityTypeUtil.isFormExist((String)queryFormId)) {
                this.addErr("error", ResManager.loadKDString((String)"\u5173\u8054\u8868\u5355\u4e0d\u5b58\u5728", (String)"WfModelStartSync_1", (String)"bos-nocode-formplugin", (Object[])new Object[0]), "queryFormId", errors);
            }
            if (StringUtils.isEmpty((CharSequence)node.getStartTime())) {
                WfModelStartSync.addRequiredErr("startTime", WfConsts.getNodeStartStartTimeName(), errors);
            }
            if (StringUtils.isEmpty((CharSequence)node.getEndTime())) {
                WfModelStartSync.addRequiredErr("endTime", WfConsts.getNodeStartEndTimeName(), errors);
            }
            if (StringUtils.isEmpty((CharSequence)node.getLoopType())) {
                WfModelStartSync.addRequiredErr("loopType", WfConsts.getNodeStartLoopTypeName(), errors);
            }
            if (this.isTriggerTimeEmpty(node.getLoopType(), node.getTriggerTime())) {
                WfModelStartSync.addRequiredErr("triggerTime", WfConsts.getNodeStartTriggerTimeName(), errors);
            }
            if (StringUtils.isNotBlank((CharSequence)(filterValid = this.isFilterValid(node)))) {
                this.addErr("error", filterValid, "filter", errors);
            }
        }
    }

    private String isFilterValid(NoCodeWfNodeStart node) {
        List filters = node.getFilter();
        if (filters == null || filters.isEmpty()) {
            return null;
        }
        for (FilterItem filter : filters) {
            if (StringUtils.isBlank((CharSequence)filter.getCompareType()) || StringUtils.isBlank((CharSequence)filter.getFieldName())) {
                return ResManager.loadKDString((String)"\u7b5b\u9009\u6761\u4ef6\u4e0d\u5b8c\u6574", (String)"WfModelStartSync_3", (String)"bos-nocode-formplugin", (Object[])new Object[0]);
            }
            String filterValueValid = this.isFilterValueValid(filter, node);
            if (!StringUtils.isNotBlank((CharSequence)filterValueValid)) continue;
            return filterValueValid;
        }
        return null;
    }

    private String isFilterValueValid(FilterItem filter, NoCodeWfNodeStart node) {
        BillEntityType dt = NcEntityTypeUtil.getMainEntityType((String)node.getFormId());
        if (Objects.isNull(dt)) {
            return null;
        }
        IDataEntityProperty property = NcEntityTypeUtil.findProperty((DynamicObjectType)dt, (String)filter.getFieldName());
        if (Objects.isNull(property)) {
            return ResManager.loadKDString((String)"\u5b57\u6bb5\u5f15\u7528\u5931\u6548", (String)"WfModelStartSync_4", (String)"bos-nocode-formplugin", (Object[])new Object[0]);
        }
        if (!this.mustHasValue(filter)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)filter.getValue()) || "[]".equalsIgnoreCase(filter.getValue())) {
            return ResManager.loadKDString((String)"\u7b5b\u9009\u6761\u4ef6\u4e0d\u5b8c\u6574", (String)"WfModelStartSync_3", (String)"bos-nocode-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private boolean mustHasValue(FilterItem filter) {
        return !CompareTypeEnum.EMPTY.getId().equalsIgnoreCase(filter.getCompareType()) && !CompareTypeEnum.NOT_EMPTY.getId().equalsIgnoreCase(filter.getCompareType()) && !CompareTypeEnum.CUR_USER.getId().equalsIgnoreCase(filter.getCompareType()) && !CompareTypeEnum.NOT_CUR_USER.getId().equalsIgnoreCase(filter.getCompareType()) && !CompareTypeEnum.CUR_USER_ORG.getId().equalsIgnoreCase(filter.getCompareType()) && !CompareTypeEnum.NOT_CUR_USER_ORG.getId().equalsIgnoreCase(filter.getCompareType());
    }

    private boolean isTriggerTimeEmpty(String loopType, TriggerTime triggerTime) {
        List date = triggerTime.getDate();
        String time = triggerTime.getTime();
        if (CollectionUtils.isEmpty((Collection)date) && StringUtils.isEmpty((CharSequence)time)) {
            return true;
        }
        LoopTypeEnum code = LoopTypeEnum.getByCode((String)loopType);
        switch (code) {
            case DAY: {
                return StringUtils.isEmpty((CharSequence)time);
            }
            case WEEK: 
            case MONTH: 
            case YEAR: {
                return CollectionUtils.isEmpty((Collection)date) || StringUtils.isEmpty((CharSequence)time);
            }
        }
        return false;
    }
}

