/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer.sync.node;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfNode;
import kd.bos.nocode.ext.metadata.wf.info.ParticipantInfo;
import kd.bos.nocode.ext.metadata.wf.nodes.IHasTriggerProcess;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeQueryData;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeUserInput;
import kd.bos.nocode.ext.wf.control.events.WfDesignerMetaSyncEvent;
import kd.bos.nocode.wf.designer.helper.ParticipantHelper;
import kd.bos.nocode.wf.designer.helper.VariableHelper;
import kd.bos.nocode.wf.designer.helper.WfDesignerCtx;
import kd.bos.nocode.wf.designer.sync.AbstractWfModelSync;
import kd.bos.orm.util.CollectionUtils;

public class WfModelUserInputSync
extends AbstractWfModelSync<NoCodeWfNodeUserInput> {
    public static final String ERROR = "error";

    public WfModelUserInputSync(WfDesignerCtx ctx, WfDesignerMetaSyncEvent syncArgs, NoCodeWfMetaData ncMetaData) {
        super(ctx, syncArgs, ncMetaData);
    }

    @Override
    protected boolean hasVar(NoCodeWfNodeUserInput node) {
        return true;
    }

    @Override
    protected void genVars(NoCodeWfNodeUserInput node, JSONArray fieldVars) {
        this.addNodeNameVar(node, fieldVars);
        this.addAssigneeVar(ResManager.loadKDString((String)"\u5f55\u5165\u4eba", (String)"WfModelUserInputSync_0", (String)"bos-nocode-formplugin", (Object[])new Object[0]), node, fieldVars);
    }

    @Override
    protected void genErrors(NoCodeWfNodeUserInput node, JSONArray errors) {
        if (StringUtils.isBlank((CharSequence)node.getName())) {
            WfModelUserInputSync.addRequiredErr("name", ResManager.loadKDString((String)"\u540d\u79f0", (String)"WfModelUserInputSync_1", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errors);
        }
        if (StringUtils.isBlank((CharSequence)node.getRefNodeId())) {
            WfModelUserInputSync.addRequiredErr("refNodeId", ResManager.loadKDString((String)"\u5f55\u5165\u8868\u5355", (String)"WfModelUserInputSync_2", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errors);
        } else if (VariableHelper.getVarOfNodeFormPkId(node.getId(), node.getRefNodeId(), this.ncMetaData, this.ctx.getVariables(), this.ctx) == null) {
            this.addErr(ERROR, ResManager.loadKDString((String)"\u5f55\u5165\u8868\u5355\u5f15\u7528\u5931\u6548", (String)"WfModelUserInputSync_3", (String)"bos-nocode-formplugin", (Object[])new Object[0]), "refNodeId", errors);
        } else if (this.isMultiQueryDataset(node.getRefNodeId())) {
            this.addErr(ERROR, ResManager.loadKDString((String)"\u591a\u6761\u8bb0\u5f55\u65e0\u6cd5\u5f55\u5165\uff0c\u8bf7\u9009\u62e9\u5355\u6761\u8bb0\u5f55", (String)"WfModelUserInputSync_4", (String)"bos-nocode-formplugin", (Object[])new Object[0]), "refNodeId", errors);
        } else if (this.isRefUserOrOrgBill(node.getRefNodeId())) {
            this.addErr(ERROR, ResManager.loadKDString((String)"\u5f55\u5165\u8868\u5355\u5f15\u7528\u5931\u6548", (String)"WfModelUserInputSync_3", (String)"bos-nocode-formplugin", (Object[])new Object[0]), "refNodeId", errors);
        }
        ParticipantInfo participantInfo = ParticipantHelper.getParticipantInfo((NoCodeWfNode)node, node.getInputUser(), this.ctx, this.ncMetaData);
        node.setInputUser(participantInfo);
        if (CollectionUtils.isEmpty((Collection)participantInfo.getSourceData())) {
            WfModelUserInputSync.addRequiredErr("inputUser", ResManager.loadKDString((String)"\u5f55\u5165\u4eba", (String)"WfModelUserInputSync_0", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errors);
        } else {
            List sourceData = participantInfo.getSourceData();
            if (sourceData.stream().anyMatch(e -> !e.isValid())) {
                this.addErr(ERROR, ResManager.loadKDString((String)"\u5b58\u5728\u5931\u6548\u7684\u5f55\u5165\u4eba", (String)"WfModelUserInputSync_5", (String)"bos-nocode-formplugin", (Object[])new Object[0]), "inputUser", errors);
            } else {
                String[] person = participantInfo.getPerson();
                Arrays.stream(person).forEach(userId -> {
                    String varType;
                    JSONObject variable;
                    if (StringUtils.isNotBlank((CharSequence)userId) && userId.startsWith("${") && (variable = VariableHelper.findVariable(node.getId(), userId, this.ctx.getVariables(), this.ncMetaData, this.ctx)) != null && !"user".equalsIgnoreCase(varType = VariableHelper.getVarType(variable))) {
                        this.addErr(ERROR, ResManager.loadKDString((String)"\u5f55\u5165\u4eba\u53ea\u80fd\u5173\u8054\u4eba\u5458\u7c7b\u578b", (String)"WfModelUserInputSync_6", (String)"bos-nocode-formplugin", (Object[])new Object[0]), "inputUser", errors);
                    }
                });
            }
        }
        this.genErrors_TriggerProcess((IHasTriggerProcess)node, errors);
    }

    private boolean isRefUserOrOrgBill(String nodeId) {
        NoCodeWfNode noCodeWfNode;
        Optional<NoCodeWfNode> first = this.ncMetaData.getNodes().stream().filter(n -> n.getId().equalsIgnoreCase(nodeId)).findFirst();
        if (first.isPresent() && (noCodeWfNode = first.get()) instanceof NoCodeWfNodeQueryData) {
            NoCodeWfNodeQueryData queryNode = (NoCodeWfNodeQueryData)noCodeWfNode;
            return queryNode.getTargetFormId().equalsIgnoreCase("bos_user") || queryNode.getTargetFormId().equalsIgnoreCase("bos_adminorg");
        }
        return false;
    }
}

