/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.servicehelper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class AssociationServiceHelper {
    private static final String FIRST_FORMID = "first_formid";
    private static final String FIRST_FORM_REF_FIELDKEY = "first_form_ref_fieldkey";
    private static final String SECOND_FORMID = "second_formid";
    private static final String SECOND_FORM_REF_FIELDKEY = "second_form_ref_fieldkey";
    public static final String SELECTFIELDS = "id,first_formid,first_form_ref_fieldkey,second_formid,second_form_ref_fieldkey";

    public static Tuple<Boolean, String> existAssociation(String formId, String fieldKey) {
        String targetKey = "";
        QFilter filter = AssociationServiceHelper.buildQFilter(formId, fieldKey);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bos_nocode_association", (String)SELECTFIELDS, (QFilter[])new QFilter[]{filter});
        if (collection.isEmpty()) {
            return Tuple.create((Object)false, null);
        }
        DynamicObject obj = (DynamicObject)collection.get(0);
        String firstKey = obj.getString(FIRST_FORM_REF_FIELDKEY);
        String secondKey = obj.getString(SECOND_FORM_REF_FIELDKEY);
        targetKey = firstKey.equals(fieldKey) ? secondKey : firstKey;
        if (StringUtils.isBlank((CharSequence)targetKey)) {
            Tuple.create((Object)false, null);
        }
        return Tuple.create((Object)true, (Object)targetKey);
    }

    public static Map<String, String> getAssociatedFields(String formId) {
        HashMap<String, String> fields = new HashMap<String, String>();
        QFilter f1 = new QFilter(FIRST_FORMID, "=", (Object)formId);
        QFilter f2 = new QFilter(SECOND_FORMID, "=", (Object)formId);
        QFilter filter = f1.or(f2);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bos_nocode_association", (String)SELECTFIELDS, (QFilter[])new QFilter[]{filter});
        for (DynamicObject obj : collection) {
            if (formId.equals(obj.getString(FIRST_FORMID))) {
                fields.put(obj.getString(FIRST_FORM_REF_FIELDKEY), obj.getString(SECOND_FORM_REF_FIELDKEY));
            }
            if (!formId.equals(obj.getString(SECOND_FORMID))) continue;
            fields.put(obj.getString(SECOND_FORM_REF_FIELDKEY), obj.getString(FIRST_FORM_REF_FIELDKEY));
        }
        return fields;
    }

    public static void deleteAssociation(String formId, String fieldKey) {
        QFilter filter = AssociationServiceHelper.buildQFilter(formId, fieldKey);
        DeleteServiceHelper.delete((String)"bos_nocode_association", (QFilter[])new QFilter[]{filter});
    }

    public static void deleteAssociations(String formId, List<String> fieldKey) {
        QFilter filter = AssociationServiceHelper.buildQFilter(formId, fieldKey);
        DeleteServiceHelper.delete((String)"bos_nocode_association", (QFilter[])new QFilter[]{filter});
    }

    public static void updateAssociation(String sourceFormId, String sourceFieldKey, String targetFormId, String targetFieldKey) {
        QFilter filter = AssociationServiceHelper.buildQFilter(sourceFormId, sourceFieldKey);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)targetFormId, (QFilter[])new QFilter[]{QFilter.exists((String)targetFieldKey)});
        if (obj != null) {
            throw new KDBizException("targetFieldKey has data");
        }
        DeleteServiceHelper.delete((String)"bos_nocode_association", (QFilter[])new QFilter[]{filter});
        DynamicObject association = BusinessDataServiceHelper.newDynamicObject((String)"bos_nocode_association");
        association.set(FIRST_FORMID, (Object)sourceFormId);
        association.set(FIRST_FORM_REF_FIELDKEY, (Object)sourceFieldKey);
        association.set(SECOND_FORMID, (Object)targetFormId);
        association.set(SECOND_FORM_REF_FIELDKEY, (Object)targetFieldKey);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{association});
    }

    public static Map<String, Map<String, String>> getAssociationFields(String formId) {
        HashMap<String, Map<String, String>> formMap = new HashMap<String, Map<String, String>>();
        QFilter f1 = new QFilter(FIRST_FORMID, "=", (Object)formId);
        QFilter f2 = new QFilter(SECOND_FORMID, "=", (Object)formId);
        QFilter filter = f1.or(f2);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bos_nocode_association", (String)SELECTFIELDS, (QFilter[])new QFilter[]{filter});
        for (DynamicObject obj : collection) {
            String targetFormId = "";
            if (obj.getString(FIRST_FORMID).equals(formId)) {
                targetFormId = obj.getString(SECOND_FORMID);
                formMap.computeIfAbsent(targetFormId, k -> new HashMap()).put(obj.getString(FIRST_FORM_REF_FIELDKEY), obj.getString(SECOND_FORM_REF_FIELDKEY));
            }
            if (!obj.getString(SECOND_FORMID).equals(formId)) continue;
            targetFormId = obj.getString(FIRST_FORMID);
            formMap.computeIfAbsent(targetFormId, k -> new HashMap()).put(obj.getString(SECOND_FORM_REF_FIELDKEY), obj.getString(FIRST_FORM_REF_FIELDKEY));
        }
        return formMap;
    }

    private static QFilter buildQFilter(String formId, String fieldKey) {
        ArrayList<String> fieldKeys = new ArrayList<String>();
        fieldKeys.add(fieldKey);
        return AssociationServiceHelper.buildQFilter(formId, fieldKeys);
    }

    private static QFilter buildQFilter(String formId, List<String> fieldKeys) {
        QFilter f1 = new QFilter(FIRST_FORMID, "=", (Object)formId);
        QFilter f2 = f1.and(new QFilter(FIRST_FORM_REF_FIELDKEY, "in", fieldKeys));
        QFilter f3 = new QFilter(SECOND_FORMID, "=", (Object)formId);
        QFilter f4 = f3.and(new QFilter(SECOND_FORM_REF_FIELDKEY, "in", fieldKeys));
        return f2.or(f4);
    }
}

