/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.servicehelper;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;

public class ServiceFactory {
    private static final Map<String, String> SERVICE_MAP = new HashMap<String, String>(14);

    private ServiceFactory() {
    }

    public static Object getService(String serviceName) {
        String className = SERVICE_MAP.get(serviceName);
        if (Objects.isNull(className)) {
            String appName = Instance.getAppName();
            String errMsg = ResManager.loadKDString((String)"%1$s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u5728%2$s\u672a\u627e\u5230", (String)"ServiceFactory_0", (String)"BOS_NOCODE", (Object[])new Object[]{serviceName, appName});
            throw new KDException(new ErrorCode("SERVICE_NOT_FOUND", errMsg), new Object[0]);
        }
        return TypesContainer.getOrRegisterSingletonInstance((String)className);
    }

    static {
        SERVICE_MAP.put("QueryRestApiService", "kd.bos.nocode.restapi.service.query.QueryRestApiServiceImpl");
        SERVICE_MAP.put("TreeQueryRestApiService", "kd.bos.nocode.restapi.service.query.TreeQueryRestApiServiceImpl");
        SERVICE_MAP.put("SaveRestApiService", "kd.bos.nocode.restapi.service.save.SaveRestApiServiceImpl");
        SERVICE_MAP.put("DeleteRestApiService", "kd.bos.nocode.restapi.service.delete.DeleteRestApiServiceImpl");
        SERVICE_MAP.put("SubmitRestApiService", "kd.bos.nocode.restapi.service.rowstatusconvert.SubmitRestApiServiceImpl");
        SERVICE_MAP.put("UnSubmitRestApiService", "kd.bos.nocode.restapi.service.rowstatusconvert.UnSubmitRestApiServiceImpl");
        SERVICE_MAP.put("AuditRestApiService", "kd.bos.nocode.restapi.service.rowstatusconvert.AuditRestApiServiceImpl");
        SERVICE_MAP.put("UnAuditRestApiService", "kd.bos.nocode.restapi.service.rowstatusconvert.UnAuditRestApiServiceImpl");
        SERVICE_MAP.put("AppendEntryRowsRestApiService", "kd.bos.nocode.restapi.service.save.AppendEntryRowsRestApiServiceImpl");
        SERVICE_MAP.put("DeleteEntryRowsRestApiService", "kd.bos.nocode.restapi.service.save.DeleteEntryRowsRestApiServiceImpl");
        SERVICE_MAP.put("EnableRestApiService", "kd.bos.nocode.restapi.service.rowstatusconvert.EnableRestApiServiceImpl");
        SERVICE_MAP.put("DisableRestApiService", "kd.bos.nocode.restapi.service.rowstatusconvert.DisableRestApiServiceImpl");
        SERVICE_MAP.put("ImageRestApiService", "kd.bos.nocode.restapi.service.sys.ImageRestApiServiceImpl");
        SERVICE_MAP.put("AttachmentRestApiService", "kd.bos.nocode.restapi.service.sys.AttachmentRestApiServiceImpl");
        SERVICE_MAP.put("NoCodeDebugService", "kd.bos.nocode.debug.NoCodeDebugServiceImpl");
        SERVICE_MAP.put("NoCodeQingService", "kd.bos.nocode.mservice.NoCodeQingServiceImpl");
        SERVICE_MAP.put("ListQueryService", "kd.bos.nocode.mservice.NoCodeQingServiceImpl");
        SERVICE_MAP.put("NoCodeDesignMetadataService", "kd.bos.nocode.metadata.design.NoCodeDesignMetadataServiceImpl");
        SERVICE_MAP.put("NoCodeWfDesignerService", "kd.bos.nocode.wf.NoCodeWfDesignerServiceImpl");
        SERVICE_MAP.put("NoCodeWfService", "kd.bos.nocode.wf.NoCodeWfServiceImpl");
        SERVICE_MAP.put("RestApiWrap", "kd.bos.nocode.restapi.RestApiWrapImpl");
        SERVICE_MAP.put("NoCodeWfRecordApiService", "kd.bos.nocode.wf.NoCodeWfRecordApiServiceImpl");
        SERVICE_MAP.put("NoCodeDefValueCalculatorService", "kd.bos.nocode.mservice.NoCodeDefValueCalculatorServiceImpl");
        SERVICE_MAP.put("NoCodeRuleService", "kd.bos.nocode.mservice.NoCodeRuleServiceImpl");
        SERVICE_MAP.put("NoCodeFilterService", "kd.bos.nocode.restapi.service.query.NoCodeFilterServiceImpl");
        SERVICE_MAP.put("BatchRestApiService", "kd.bos.nocode.restapi.service.batch.api.BatchRestApiServiceImpl");
        SERVICE_MAP.put("PrintRestApiService", "kd.bos.nocode.restapi.service.print.PrintRestApiServiceImpl");
        SERVICE_MAP.put("NoCodeRefBillTableService", "kd.bos.nocode.mservice.NoCodeRefBillTableServiceImpl");
        SERVICE_MAP.put("NoCodeExternalApiService", "kd.bos.nocode.mservice.ApiInvokeImpl");
        SERVICE_MAP.put("NoCodeSoftDeleteService", "kd.bos.nocode.mservice.NoCodeSoftDeleteServiceImpl");
    }
}

