/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.constant;

import java.util.Optional;
import kd.bos.nocode.constant.MultiLangEnumBridge;

public enum RegExpEnum {
    EMAIL("email", new MultiLangEnumBridge("\u90ae\u7bb1\u683c\u5f0f\u6821\u9a8c", "RegExpEnum_0", "bos-nocode-ext"), new MultiLangEnumBridge("\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e", "RegExpEnum_1", "bos-nocode-ext"), "\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*", "\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*"),
    URL("url", new MultiLangEnumBridge("\u7f51\u5740\u683c\u5f0f\u6821\u9a8c", "RegExpEnum_2", "bos-nocode-ext"), new MultiLangEnumBridge("\u7f51\u5740\u683c\u5f0f\u4e0d\u6b63\u786e", "RegExpEnum_3", "bos-nocode-ext"), "^((http|https)://)?([\\w-]+\\.)+[\\w-]+(:[0-9]{1,5})?(/[\\w-./?%&=]*)?$", "^((http|https)://)?([\\w-]+\\.)+[\\w-]+(:[0-9]{1,5})?(/[\\w-./?%&=]*)?$"),
    ID_CARD("idcard", new MultiLangEnumBridge("\u8eab\u4efd\u8bc1\u683c\u5f0f\u6821\u9a8c", "RegExpEnum_4", "bos-nocode-ext"), new MultiLangEnumBridge("\u8eab\u4efd\u8bc1\u683c\u5f0f\u4e0d\u6b63\u786e", "RegExpEnum_5", "bos-nocode-ext"), "^(\\d{6})(18|19|20)?(\\d{2})([01]\\d)([0123]\\d)(\\d{3})(\\d|X|x)?$", "^(\\d{6})(18|19|20)?(\\d{2})([01]\\d)([0123]\\d)(\\d{3})(\\d|X|x)?$"),
    PHONE("phone", new MultiLangEnumBridge("\u624b\u673a\u53f7\u7801\u683c\u5f0f\u6821\u9a8c", "RegExpEnum_6", "bos-nocode-ext"), new MultiLangEnumBridge("\u624b\u673a\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e", "RegExpEnum_7", "bos-nocode-ext"), "^((\\+)?\\d+\\s)?\\d{3}\\s\\d{4}\\s\\d{4}$", "^\\d{11,}$");

    private final String code;
    private final MultiLangEnumBridge bridgeDesc;
    private final MultiLangEnumBridge bridgeMessage;
    private final String clientRegex;
    private final String serverRegex;

    private RegExpEnum(String code, MultiLangEnumBridge bridgeDesc, MultiLangEnumBridge bridgeMessage, String clientRegex, String serverRegex) {
        this.code = code;
        this.bridgeDesc = bridgeDesc;
        this.bridgeMessage = bridgeMessage;
        this.clientRegex = clientRegex;
        this.serverRegex = serverRegex;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.bridgeDesc.loadKDString();
    }

    public String getMessage() {
        return this.bridgeMessage.loadKDString();
    }

    public String getClientRegex() {
        return this.clientRegex;
    }

    public String getServerRegex() {
        return this.serverRegex;
    }

    public static Optional<RegExpEnum> of(String code) {
        for (RegExpEnum value : RegExpEnum.values()) {
            if (!value.getCode().equalsIgnoreCase(code)) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }
}

