/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.datamask;

import java.util.Map;
import kd.bos.nocode.ext.datamask.IDataMaskProcessor;

public class CustomMaskProcessor
implements IDataMaskProcessor {
    public static final String BEGIN_CHAR = "beginChar";
    public static final String END_CHAR = "endChar";

    @Override
    public String getDesensitizeValue(Map<String, Object> dataMaskMap, Object value) {
        char[] chars = value.toString().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = 42;
        }
        String maskValue = new String(chars);
        String beginStr = this.processBeginChar(dataMaskMap, maskValue, value.toString());
        String endStr = this.processEndChar(dataMaskMap, beginStr, value.toString());
        return this.processVmLengthChar(dataMaskMap, endStr);
    }

    private String processBeginChar(Map<String, Object> dataMaskMap, String value, String originValue) {
        Object begin = dataMaskMap.get("beginConfig");
        if (begin == null) {
            return originValue;
        }
        int beginConfig = Integer.parseInt(begin.toString());
        if (beginConfig == 2) {
            Object charSizeStr = dataMaskMap.get(BEGIN_CHAR);
            if (charSizeStr == null) {
                return value;
            }
            int charSize = Integer.parseInt(charSizeStr.toString());
            if (charSize >= originValue.length()) {
                return originValue;
            }
            String subStr = originValue.substring(0, charSize);
            return subStr + value.substring(charSize);
        }
        if (beginConfig == 3) {
            Object charSizeStr = dataMaskMap.get(BEGIN_CHAR);
            if (charSizeStr == null) {
                return value;
            }
            String charStr = charSizeStr.toString();
            int index = originValue.indexOf(charStr);
            if (index == -1) {
                return value;
            }
            if (charStr.length() >= originValue.length()) {
                return originValue;
            }
            String beginStr = originValue.substring(0, index);
            return beginStr + value.substring(index);
        }
        if (beginConfig == 4) {
            Object charSizeStr = dataMaskMap.get(BEGIN_CHAR);
            if (charSizeStr == null) {
                return value;
            }
            String charStr = charSizeStr.toString();
            int index = originValue.indexOf(charStr);
            if (index == -1) {
                return value;
            }
            if (charStr.length() >= originValue.length()) {
                return originValue;
            }
            String beginStr = originValue.substring(0, index + charStr.length());
            return beginStr + value.substring(index + charStr.length());
        }
        return value;
    }

    private String processEndChar(Map<String, Object> dataMaskMap, String beginValue, String originValue) {
        Object end = dataMaskMap.get("endConfig");
        if (end == null) {
            return beginValue;
        }
        int endConfig = Integer.parseInt(end.toString());
        if (endConfig == 2) {
            Object charSizeStr = dataMaskMap.get(END_CHAR);
            if (charSizeStr == null) {
                return beginValue;
            }
            int charSize = Integer.parseInt(charSizeStr.toString());
            if (charSize >= originValue.length()) {
                return originValue;
            }
            String subStr = originValue.substring(originValue.length() - charSize);
            return beginValue.substring(0, originValue.length() - charSize) + subStr;
        }
        if (endConfig == 3) {
            Object charSizeStr = dataMaskMap.get(END_CHAR);
            if (charSizeStr == null) {
                return beginValue;
            }
            String charStr = charSizeStr.toString();
            int index = originValue.lastIndexOf(charStr);
            if (index == -1) {
                return beginValue;
            }
            if (charStr.length() >= originValue.length()) {
                return originValue;
            }
            String endStr = originValue.substring(index + charStr.length());
            return beginValue.substring(0, index + charStr.length()) + endStr;
        }
        if (endConfig == 4) {
            Object charSizeStr = dataMaskMap.get(END_CHAR);
            if (charSizeStr == null) {
                return beginValue;
            }
            String charStr = charSizeStr.toString();
            int index = originValue.lastIndexOf(charStr);
            if (index == -1) {
                return beginValue;
            }
            if (charStr.length() >= originValue.length()) {
                return originValue;
            }
            String endStr = originValue.substring(index);
            return beginValue.substring(0, index) + endStr;
        }
        return beginValue;
    }

    private String processVmLengthChar(Map<String, Object> dataMaskMap, String endValue) {
        Object vmLength = dataMaskMap.get("vmLength");
        if (vmLength == null) {
            return endValue;
        }
        char[] chars = endValue.toCharArray();
        int length = Integer.parseInt(vmLength.toString());
        char[] temp = new char[length];
        for (int i = 0; i < length; ++i) {
            temp[i] = 42;
        }
        String tempStr = new String(temp);
        boolean hasFound = false;
        int begin = -1;
        int end = chars.length;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '*' && !hasFound) {
                hasFound = true;
                begin = i;
            }
            if (chars[i] == '*' || !hasFound) continue;
            hasFound = false;
            end = i;
            break;
        }
        if (hasFound) {
            end = chars.length;
        }
        if (begin == 0 && end == chars.length) {
            return tempStr;
        }
        if (begin == -1 && end == chars.length) {
            return endValue;
        }
        if (begin == 0) {
            return tempStr + endValue.substring(end, chars.length);
        }
        if (end == chars.length) {
            return endValue.substring(0, begin) + tempStr;
        }
        return endValue.substring(0, begin) + tempStr + endValue.substring(end, chars.length);
    }

    public static void main(String[] args) {
        String s2 = "1.11111";
        char[] chars = s2.toCharArray();
        int index = s2.indexOf(".");
        for (int i = 1; i < chars.length - 2; ++i) {
            chars[i] = 42;
        }
        System.out.println(new String(chars));
    }
}

