/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.datamask;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.nocode.ext.datamask.AddressMaskProcessor;
import kd.bos.nocode.ext.datamask.AllMaskProcessor;
import kd.bos.nocode.ext.datamask.AmountMaskProcessor;
import kd.bos.nocode.ext.datamask.CarCardMaskProcessor;
import kd.bos.nocode.ext.datamask.CustomMaskProcessor;
import kd.bos.nocode.ext.datamask.DefaultDataMaskProcessor;
import kd.bos.nocode.ext.datamask.EmailMaskProcessor;
import kd.bos.nocode.ext.datamask.IDCardMaskProcessor;
import kd.bos.nocode.ext.datamask.IDataMaskProcessor;
import kd.bos.nocode.ext.datamask.IPMaskProcessor;
import kd.bos.nocode.ext.datamask.NameMaskProcessor;
import kd.bos.nocode.ext.datamask.TelePhoneMaskProcessor;

public class DataMaskFactory {
    private static Map<String, String> processorMap = new HashMap<String, String>();

    public static IDataMaskProcessor getDataMaskprocessor(String maskType) {
        String className = processorMap.get(maskType);
        if (className == null) {
            className = processorMap.get("default");
        }
        IDataMaskProcessor processor = (IDataMaskProcessor)TypesContainer.getOrRegisterSingletonInstance((String)className);
        return processor;
    }

    static {
        processorMap.put("1", AllMaskProcessor.class.getName());
        processorMap.put("2", NameMaskProcessor.class.getName());
        processorMap.put("3", TelePhoneMaskProcessor.class.getName());
        processorMap.put("4", EmailMaskProcessor.class.getName());
        processorMap.put("5", AmountMaskProcessor.class.getName());
        processorMap.put("6", IDCardMaskProcessor.class.getName());
        processorMap.put("7", AddressMaskProcessor.class.getName());
        processorMap.put("8", IPMaskProcessor.class.getName());
        processorMap.put("9", CarCardMaskProcessor.class.getName());
        processorMap.put("10", CustomMaskProcessor.class.getName());
        processorMap.put("default", DefaultDataMaskProcessor.class.getName());
    }
}

