/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.form.control;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.NoCodeWorkflowServiceHelper;
import kd.bos.workflow.api.model.ProcessModel;

public class NoCodeBizButton
extends Button {
    private static final Log logger = LogFactory.getLog(NoCodeBizButton.class);
    private final String TARGET_FORMID = "targetFormId";
    private final String UDDATE = "update";
    private final String PARENT_FORM_ID = "parentFormId";
    private final String PARENT_PKID = "parentPkId";
    private final String UPDATE_FIELD = "updateField";
    private final String REFRESH = "refresh";
    private final String REFRESH_ALL = "refreshAll";
    private final String PKID = "pkId";
    private final String TRIGGER_PROCESS = "triggerProcess";
    private final String TRIGGER_PKID = "triggerPkId";
    private final String TRIGGER = "trigger";
    private String operationType = "1";
    private String triggerProcess;
    private String inputForm = "";
    private String inputType = "1";
    private String inputContent;
    private boolean replaceRecord;
    private boolean addWhileEmpty;
    private String triggerProcessAfterInput;
    private Object pkId;
    private String operationCaption;
    private String parentPageId;

    @SimplePropertyAttribute(name="InputForm")
    @DefaultValueAttribute(value="")
    public String getInputForm() {
        return this.inputForm;
    }

    public void setInputForm(String inputForm) {
        this.inputForm = inputForm;
    }

    @SimplePropertyAttribute(name="InputType")
    public String getInputType() {
        return this.inputType;
    }

    @SimplePropertyAttribute(name="InputContent")
    public String getInputContent() {
        return this.inputContent;
    }

    public void setInputContent(String inputContent) {
        this.inputContent = inputContent;
    }

    public void setInputType(String inputType) {
        this.inputType = inputType;
    }

    @SimplePropertyAttribute(name="OperationType")
    public String getOperationType() {
        return this.operationType;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    @SimplePropertyAttribute(name="ReplaceRecord")
    public boolean isReplaceRecord() {
        return this.replaceRecord;
    }

    public void setReplaceRecord(boolean replaceRecord) {
        this.replaceRecord = replaceRecord;
    }

    @SimplePropertyAttribute(name="AddWhileEmpty")
    public boolean isAddWhileEmpty() {
        return this.addWhileEmpty;
    }

    public void setAddWhileEmpty(boolean addWhileEmpty) {
        this.addWhileEmpty = addWhileEmpty;
    }

    @SimplePropertyAttribute(name="TriggerProcessAfterInput")
    public String getTriggerProcessAfterInput() {
        return this.triggerProcessAfterInput;
    }

    public void setTriggerProcessAfterInput(String triggerProcessAfterInput) {
        this.triggerProcessAfterInput = triggerProcessAfterInput;
    }

    public String getTriggerProcess() {
        return this.triggerProcess;
    }

    public void setTriggerProcess(String triggerProcess) {
        this.triggerProcess = triggerProcess;
    }

    public void click() {
        super.click();
        String id = this.getId();
        String appId = this.getView().getFormShowParameter().getAppId();
        String formId = this.getView().getFormShowParameter().getFormId();
        Set permSet = NoCodePermHelper.getNoViewFieldPermSet((String)formId);
        if (permSet.contains(id)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6743\u9650\u4e0d\u8db3", (String)"NoCodeBizButton_0", (String)"bos-nocode-ext", (Object[])new Object[0]));
            return;
        }
        switch (this.operationType) {
            case "1": {
                this.triggerProcess();
                break;
            }
            case "2": {
                this.openForm();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openForm() {
        Object parentPkId;
        String updateField;
        String parentFormId;
        boolean refreshAll;
        boolean refresh;
        boolean update;
        OperationStatus operationStatus;
        Object pkId;
        String formId;
        IDataModel model;
        block32: {
            String[] path;
            block34: {
                block33: {
                    model = SessionManager.getCurrent().getView(this.getParentPageId()).getModel();
                    if (StringUtils.isBlank((CharSequence)this.inputForm)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u5f55\u5165\u8868\u5355", (String)"NoCodeBizButton_1", (String)"bos-nocode-ext", (Object[])new Object[0]));
                        return;
                    }
                    path = this.inputForm.contains(".") ? this.inputForm.split("\\.") : new String[]{this.inputForm};
                    formId = null;
                    pkId = null;
                    operationStatus = null;
                    update = false;
                    refresh = false;
                    refreshAll = false;
                    parentFormId = null;
                    updateField = null;
                    parentPkId = null;
                    if (path.length != 1) break block33;
                    formId = path[0];
                    if (formId.contains("$")) {
                        formId = formId.replace("$", "");
                        if (this.inputType.equals("1")) {
                            operationStatus = OperationStatus.ADDNEW;
                            break block32;
                        } else {
                            operationStatus = OperationStatus.EDIT;
                            pkId = model.getDataEntity().getPkValue().toString();
                            refresh = true;
                            refreshAll = true;
                        }
                        break block32;
                    } else {
                        operationStatus = OperationStatus.ADDNEW;
                    }
                    break block32;
                }
                if (path.length != 2) break block34;
                String pace = path[1];
                String field = pace.substring(pace.indexOf(91) + 1, pace.indexOf(93));
                formId = pace.substring(0, pace.indexOf(91));
                if (this.inputType.equals("1")) {
                    operationStatus = OperationStatus.ADDNEW;
                    if (this.replaceRecord) {
                        refresh = true;
                        update = true;
                        parentFormId = path[0];
                        parentFormId = parentFormId.replace("$", "");
                        parentPkId = model.getDataEntity().getPkValue();
                        updateField = field;
                    }
                    break block32;
                } else {
                    DynamicObject value = null;
                    try {
                        Object obj = model.getValue(field);
                        value = obj instanceof DynamicObject ? BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)obj).getPkValue(), (String)formId) : BusinessDataServiceHelper.loadSingle((Object)model.getValue(field), (String)formId);
                    }
                    catch (Exception e) {
                        logger.warn((Throwable)e);
                    }
                    updateField = field;
                    if (value == null) {
                        if (!this.addWhileEmpty) {
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5f55\u5165\u7684\u8868\u5355\u65e0\u53ef\u7f16\u8f91\u8bb0\u5f55", (String)"NoCodeBizButton_2", (String)"bos-nocode-ext", (Object[])new Object[0]));
                            return;
                        }
                        operationStatus = OperationStatus.ADDNEW;
                        update = true;
                        parentFormId = path[0];
                        parentFormId = parentFormId.replace("$", "");
                        parentPkId = model.getDataEntity().getPkValue();
                        refresh = true;
                        break block32;
                    } else {
                        operationStatus = OperationStatus.EDIT;
                        refresh = true;
                        pkId = value.getPkValue().toString();
                    }
                }
                break block32;
            }
            if (path.length == 3) {
                String pace1 = path[1];
                String pace2 = path[2];
                formId = pace2.substring(0, pace2.indexOf(91));
                String field1 = pace1.substring(pace1.indexOf(91) + 1, pace1.indexOf(93));
                String formId2 = pace1.substring(0, pace1.indexOf(91));
                String field2 = pace2.substring(pace2.indexOf(91) + 1, pace2.indexOf(93));
                DynamicObject value1 = null;
                try {
                    Object obj = model.getValue(field1);
                    value1 = obj instanceof DynamicObject ? BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)obj).getPkValue(), (String)formId2) : BusinessDataServiceHelper.loadSingle((Object)obj, (String)formId2);
                }
                catch (Exception e) {
                    logger.warn((Throwable)e);
                }
                if (value1 == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5f55\u5165\u7684\u8868\u5355\u65e0\u53ef\u7f16\u8f91\u8bb0\u5f55", (String)"NoCodeBizButton_2", (String)"bos-nocode-ext", (Object[])new Object[0]));
                    return;
                }
                if (this.inputType.equals("1")) {
                    operationStatus = OperationStatus.ADDNEW;
                    if (this.replaceRecord) {
                        update = true;
                        parentFormId = formId2;
                        parentPkId = value1.getPkValue();
                        updateField = field2;
                    }
                } else {
                    DynamicObject value2 = null;
                    try {
                        Object obj = value1.get(field2);
                        value2 = obj instanceof DynamicObject ? BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)obj).getPkValue(), (String)formId) : BusinessDataServiceHelper.loadSingle((Object)obj, (String)formId);
                    }
                    catch (Exception e) {
                        logger.warn((Throwable)e);
                    }
                    if (value2 == null) {
                        if (!this.addWhileEmpty) {
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5f55\u5165\u7684\u8868\u5355\u65e0\u53ef\u7f16\u8f91\u8bb0\u5f55", (String)"NoCodeBizButton_2", (String)"bos-nocode-ext", (Object[])new Object[0]));
                            return;
                        }
                        operationStatus = OperationStatus.ADDNEW;
                        update = true;
                        parentFormId = formId2;
                        parentPkId = value1.getPkValue();
                        updateField = field2;
                    } else {
                        operationStatus = OperationStatus.EDIT;
                        pkId = value2.getPkValue();
                    }
                }
            }
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_nocode_bill_nested");
        String appId = this.getModel().getDataEntityType().getAppId();
        parameter.setCustomParam("ServiceAppId", (Object)("bos." + appId));
        parameter.setStatus(operationStatus);
        parameter.setParentPageId(this.getView().getPageId());
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("targetFormId", (Object)formId);
        parameter.setCustomParam("update", (Object)update);
        parameter.setCustomParam("parentFormId", (Object)parentFormId);
        parameter.setCustomParam("parentPkId", parentPkId);
        parameter.setCustomParam("updateField", (Object)updateField);
        parameter.setCustomParam("refresh", (Object)refresh);
        parameter.setCustomParam("refreshAll", (Object)refreshAll);
        parameter.setCustomParam("parentPageId", (Object)this.getParentPageId());
        if (pkId != null) {
            parameter.setCustomParam("pkId", (Object)pkId.toString());
        }
        boolean trigger = false;
        if (StringUtils.isNotEmpty((CharSequence)this.triggerProcessAfterInput)) {
            try {
                JSONObject json = JSON.parseObject((String)this.triggerProcessAfterInput);
                String value = json.get((Object)"value").toString();
                trigger = json.getBooleanValue("enable") && StringUtils.isNotEmpty((CharSequence)value);
                parameter.setCustomParam("triggerProcess", (Object)value);
                parameter.setCustomParam("triggerPkId", model.getDataEntity().getPkValue());
            }
            catch (Exception e) {
                logger.warn((Throwable)e);
            }
        }
        parameter.setCustomParam("trigger", (Object)trigger);
        parameter.setCustomParam("inputContent", (Object)this.getInputContent());
        if (operationStatus == OperationStatus.EDIT) {
            parameter.setCaption(ResManager.loadKDString((String)"\u7f16\u8f91", (String)"NoCodeBizButton_3", (String)"bos-nocode-ext", (Object[])new Object[0]));
        } else if (operationStatus == OperationStatus.ADDNEW) {
            parameter.setCaption(ResManager.loadKDString((String)"\u5f55\u5165", (String)"NoCodeBizButton_4", (String)"bos-nocode-ext", (Object[])new Object[0]));
        }
        parameter.setCustomParam("skip", (Object)true);
        this.getView().showForm(parameter);
    }

    private void triggerProcess() {
        String triggerProcess = this.getTriggerProcess();
        if (StringUtils.isBlank((CharSequence)triggerProcess) || !StringUtils.isNumeric((CharSequence)triggerProcess)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u89e6\u53d1\u6d41\u7a0b", (String)"NoCodeBizButton_5", (String)"bos-nocode-ext", (Object[])new Object[0]));
            return;
        }
        long modelId = Long.parseLong(triggerProcess);
        Object pkId = this.getPkId();
        if (pkId == null) {
            this.getView().showErrorNotification("getPkId invalid");
            return;
        }
        boolean isProcessExist = true;
        boolean isTimeProc = false;
        try {
            ProcessModel process = NoCodeWorkflowServiceHelper.getProcess((Long)modelId);
            isTimeProc = process.getData().indexOf("\"triggerMode\":\"time\"") != -1;
            isProcessExist = process != null;
        }
        catch (Exception ex) {
            logger.warn((Throwable)ex);
            isProcessExist = false;
        }
        if (!isProcessExist) {
            this.getView().showErrorNotification(this.getOperationCaption() + ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6d41\u7a0b\u5df2\u5931\u6548", (String)"NoCodeBizButton_6", (String)"bos-nocode-ext", (Object[])new Object[0]));
            return;
        }
        if (isTimeProc) {
            NoCodeWorkflowServiceHelper.tryTriggerProcess((Long)modelId, null, (String)"timer");
        } else {
            NoCodeWorkflowServiceHelper.tryTriggerProcess((Long)modelId, (String)pkId.toString(), (String)"bizOperate");
        }
        this.getView().showSuccessNotification(this.getOperationCaption() + ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"NoCodeBizButton_7", (String)"bos-nocode-ext", (Object[])new Object[0]));
    }

    public Object getPkId() {
        return this.pkId;
    }

    public void setPkId(Object pkId) {
        this.pkId = pkId;
    }

    public String getOperationCaption() {
        return this.operationCaption;
    }

    public void setOperationCaption(String operationCaption) {
        this.operationCaption = operationCaption;
    }

    public String getParentPageId() {
        return this.parentPageId;
    }

    public void setParentPageId(String parentPageId) {
        this.parentPageId = parentPageId;
    }
}

