/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.form.control;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.DesignerBarListener;
import kd.bos.form.control.DesignerCallListener;
import kd.bos.form.control.FormDesigner;
import kd.bos.form.control.events.DesignerBarAction;
import kd.bos.form.control.events.DesignerBarEvent;
import kd.bos.form.control.events.DesignerCallEvent;
import kd.bos.nocode.ext.datamask.DataMaskFactory;
import kd.bos.nocode.ext.datamask.IDataMaskProcessor;
import kd.bos.nocode.ext.defvalue.NoCodeFilterConfigEvent;
import kd.bos.nocode.ext.defvalue.NoCodeFilterConfigListener;
import kd.bos.nocode.ext.defvalue.RuleListener;
import kd.bos.nocode.ext.wf.control.events.WfDesignerCommonEvent;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;

@KSObject
public class NoCodeFormDesigner
extends FormDesigner {
    private List<DesignerBarListener> barListeners = new ArrayList<DesignerBarListener>();
    private List<DesignerCallListener> callListeners = new ArrayList<DesignerCallListener>();
    private List<NoCodeFilterConfigListener> formDesignerListeners = new ArrayList<NoCodeFilterConfigListener>();
    private List<RuleListener> ruleListeners = new ArrayList<RuleListener>();
    public static final String METAMENUID = "metaMenuId";
    private static final String CALL_ACTION_CAN_SWITCH_FIELD_TYPES = "canSwitchFieldTypes";
    private static final String CALL_ACTION_GET_TRIGGER_PROCESS = "getTriggerProcess";
    private static final String CALL_ACTION_GET_INPUT_CONTENT = "getInputContent";

    public void addBarListener(DesignerBarListener barListener) {
        this.barListeners.add(barListener);
    }

    public void addCallListener(DesignerCallListener callListener) {
        this.callListeners.add(callListener);
    }

    public void addRuleListener(RuleListener ruleListener) {
        this.ruleListeners.add(ruleListener);
    }

    public void designerTypeChange(String key) {
        if (this.barListeners != null) {
            DesignerBarEvent e = new DesignerBarEvent();
            e.setActionId(DesignerBarAction.Change);
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("key", key);
            e.setBarItemKey(key);
            e.setParam(param);
            for (DesignerBarListener l : this.barListeners) {
                l.designerTypeChange(e);
            }
        }
    }

    public void designerBarClick(String key) {
        this.designerBarClick(key, "");
    }

    public void designerBarClick(String key, String formType) {
        if (this.barListeners != null) {
            DesignerBarEvent e = new DesignerBarEvent();
            e.setActionId(DesignerBarAction.Click);
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("batItemKey", key);
            param.put(METAMENUID, formType);
            e.setBarItemKey(key);
            e.setParam(param);
            for (DesignerBarListener l : this.barListeners) {
                l.designerBarClick(e);
            }
        }
    }

    public void designerBarClickBefore(String key) {
        this.designerBarClickBefore(key, "");
    }

    public void designerBarClickBefore(String key, String formType) {
        if (this.barListeners != null) {
            DesignerBarEvent e = new DesignerBarEvent();
            e.setActionId(DesignerBarAction.Click);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("barItemKey", key);
            param.put(METAMENUID, formType);
            param.put("isBeforeClick", true);
            e.setBarItemKey(key);
            e.setParam(param);
            for (DesignerBarListener l : this.barListeners) {
                l.beforeDesignerBarClick(e);
            }
        }
    }

    public void openLayoutList() {
        if (this.barListeners != null) {
            DesignerBarEvent e = new DesignerBarEvent();
            e.setActionId(DesignerBarAction.OpenLayoutList);
            for (DesignerBarListener l : this.barListeners) {
                l.designerBarClick(e);
            }
        }
    }

    public void open(String modelType, Map<String, Object> doc) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.key, "open", new Object[]{modelType, true, doc});
    }

    public void resetSideBar(String[] items) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "resetSideBar", Arrays.asList(items).toArray(new Object[items.length]));
    }

    public void canSwitchFieldTypes(List<String> fieldKeys) {
        if (this.callListeners != null) {
            DesignerCallEvent e = new DesignerCallEvent();
            e.setActionId(CALL_ACTION_CAN_SWITCH_FIELD_TYPES);
            e.setParam(fieldKeys);
            for (DesignerCallListener l : this.callListeners) {
                l.doCall(e);
            }
        }
    }

    public void getTriggerProcess() {
        if (this.callListeners != null) {
            DesignerCallEvent e = new DesignerCallEvent();
            e.setActionId(CALL_ACTION_GET_TRIGGER_PROCESS);
            for (DesignerCallListener l : this.callListeners) {
                l.doCall(e);
            }
        }
    }

    public void getInputContent(String target) {
        if (this.callListeners != null) {
            DesignerCallEvent e = new DesignerCallEvent();
            e.setActionId(CALL_ACTION_GET_INPUT_CONTENT);
            e.setParam((Object)target);
            for (DesignerCallListener l : this.callListeners) {
                l.doCall(e);
            }
        }
    }

    public void addFormDesignerListeners(NoCodeFilterConfigListener barListener) {
        this.formDesignerListeners.add(barListener);
    }

    private void fireListconfig(NoCodeFilterConfigEvent arg) {
        if (this.formDesignerListeners != null) {
            for (NoCodeFilterConfigListener l : this.formDesignerListeners) {
                l.listconfig(arg);
            }
        }
    }

    @KSMethod
    public void listconfig(String formId) {
        NoCodeFilterConfigEvent arg = new NoCodeFilterConfigEvent(formId, FormMetaUtil.getRealFormIdExcludeAppId((String)formId), null);
        this.fireListconfig(arg);
    }

    @KSMethod
    public void listtreeconfig(String formId) {
        NoCodeFilterConfigEvent arg = new NoCodeFilterConfigEvent(formId, FormMetaUtil.getRealFormIdExcludeAppId((String)formId), new HashMap<String, Object>());
        this.fireListTreeConfig(arg);
    }

    @KSMethod
    public void listtreeconfig(String formId, String sourceType) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("sourceType", sourceType);
        NoCodeFilterConfigEvent arg = new NoCodeFilterConfigEvent(formId, FormMetaUtil.getRealFormIdExcludeAppId((String)formId), map);
        this.fireListTreeConfig(arg);
    }

    private void fireListTreeConfig(NoCodeFilterConfigEvent arg) {
        if (this.formDesignerListeners != null) {
            for (NoCodeFilterConfigListener l : this.formDesignerListeners) {
                l.listTreeConfig(arg);
            }
        }
    }

    private void fireGetFilterItemLook(NoCodeFilterConfigEvent arg) {
        if (this.formDesignerListeners != null) {
            for (NoCodeFilterConfigListener l : this.formDesignerListeners) {
                l.getFilterItemLook(arg);
            }
        }
    }

    @KSMethod
    public void getFilterItemLook(String formId, Map<String, Object> param) {
        NoCodeFilterConfigEvent arg = new NoCodeFilterConfigEvent(formId, FormMetaUtil.getRealFormIdExcludeAppId((String)formId), param);
        this.fireGetFilterItemLook(arg);
    }

    public void saveBizRule(Map<String, Object> data) {
        if (this.ruleListeners != null) {
            for (RuleListener l : this.ruleListeners) {
                l.saveBizRule(data);
            }
        }
    }

    public void getBizRule(Map<String, Object> data) {
        if (this.ruleListeners != null) {
            for (RuleListener l : this.ruleListeners) {
                l.getBizRule(data);
            }
        }
    }

    public void getBizRules(Map<String, Object> data) {
        if (this.ruleListeners != null) {
            for (RuleListener l : this.ruleListeners) {
                l.getBizRules(data);
            }
        }
    }

    public void getFormRules(Map<String, Object> data) {
        if (this.ruleListeners != null) {
            for (RuleListener l : this.ruleListeners) {
                l.getFormRules(data);
            }
        }
    }

    public void saveFormRule(Map<String, Object> data) {
        if (this.ruleListeners != null) {
            for (RuleListener l : this.ruleListeners) {
                l.saveFormRule(data);
            }
        }
    }

    public void deleteFormRule(String ruleId) {
        if (this.ruleListeners != null) {
            for (RuleListener l : this.ruleListeners) {
                l.deleteFormRule(Long.parseLong(ruleId));
            }
        }
    }

    public void getDesensitizeValue(Map<String, Object> dataMaskMap, Object value) {
        String maskType = (String)dataMaskMap.get("maskType");
        IDataMaskProcessor processor = DataMaskFactory.getDataMaskprocessor(maskType);
        String result = processor.getDesensitizeValue(dataMaskMap, value);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(this.getKey(), "setDesensitizeVale", new Object[]{result});
    }

    public void queryTreeNodeChildren(String appId) {
        List children = NcEntityTypeUtil.getCosmicRefBillTreeData((String)appId);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(this.getKey(), "setTreeNodeChildren", new Object[]{children});
    }

    private void fireQuery(WfDesignerCommonEvent arg) {
        if (this.formDesignerListeners != null) {
            for (NoCodeFilterConfigListener l : this.formDesignerListeners) {
                l.query(arg);
            }
        }
    }

    @KSMethod
    public void query(String formId, Map<String, Object> param) {
        WfDesignerCommonEvent arg = new WfDesignerCommonEvent(formId, FormMetaUtil.getRealFormIdExcludeAppId((String)formId), param);
        this.fireQuery(arg);
    }

    @KSMethod
    public void getSvgLine() {
        this.fireSvgLine();
    }

    private void fireSvgLine() {
        if (this.formDesignerListeners != null) {
            for (NoCodeFilterConfigListener l : this.formDesignerListeners) {
                l.getSvgLine();
            }
        }
    }

    public void deleteBizRule(Map<String, Object> data) {
        if (this.ruleListeners != null) {
            for (RuleListener l : this.ruleListeners) {
                l.deleteBizRule(data);
            }
        }
    }

    public void updateAssociation(String sourceFormId, String sourceFieldKey, String targetFormId, String targetFieldKey) {
        if (this.formDesignerListeners != null) {
            for (NoCodeFilterConfigListener l : this.formDesignerListeners) {
                l.updateAssociation(sourceFormId, sourceFieldKey, targetFormId, targetFieldKey);
            }
        }
    }

    public void getAvailableAssociationFields(String sourceFormId, String sourceFieldKey, String targetFormId) {
        if (this.formDesignerListeners != null) {
            for (NoCodeFilterConfigListener l : this.formDesignerListeners) {
                l.getAvailableAssociationFields(sourceFormId, sourceFieldKey, targetFormId);
            }
        }
    }

    public void getDesignerMetadata(String formId) {
        if (this.formDesignerListeners != null) {
            for (NoCodeFilterConfigListener l : this.formDesignerListeners) {
                l.getDesignerMetadata(formId);
            }
        }
    }
}

