/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.form.control;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.RaiseEventType;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.rule.RaiseEventSource;
import kd.bos.entity.rule.RuleContainer;
import kd.bos.entity.rule.RuleExecuteContext;
import kd.bos.form.BindingContext;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.rule.FormRuleExecuteContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.session.impl.CodelessShareSessionServiceImpl;
import kd.bos.mservice.attachment.IAttachmentService;
import kd.bos.mvc.form.FormRuleContainer;
import kd.bos.nocode.ext.form.field.NoCodeDateRangeEdit;
import kd.bos.nocode.ext.form.field.NoCodeMulRefBillEdit;
import kd.bos.nocode.ext.form.field.NoCodeRefBillEdit;
import kd.bos.nocode.ext.property.NoCodeAttachmentProp;
import kd.bos.nocode.ext.property.NoCodeMulRefBillProp;
import kd.bos.nocode.ext.property.NoCodeRefBillProp;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.restapi.common.util.Maps;
import kd.bos.nocode.utils.BlackFormUtil;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class NoCodeRefBillTableGrid
extends EntryGrid {
    private static final Log log = LogFactory.getLog(NoCodeRefBillTableGrid.class);
    private String refBillKey;
    private int multi = 1;
    private String sourceForm;
    private String billEntityIdEx = null;
    private String gridStatus;

    @SimplePropertyAttribute
    public String getRefBillKey() {
        return this.refBillKey;
    }

    public void setRefBillKey(String refBillKey) {
        this.refBillKey = refBillKey;
    }

    @SimplePropertyAttribute(name="Multi")
    @DefaultValueAttribute(value="1")
    public int getMulti() {
        return this.multi;
    }

    public void setMulti(int multi) {
        this.multi = multi;
    }

    @SimplePropertyAttribute(name="SourceForm")
    public String getSourceForm() {
        return this.sourceForm;
    }

    public void setSourceForm(String sourceForm) {
        this.sourceForm = sourceForm;
    }

    public void bindData(BindingContext bctx) {
        try (EntityTraceSpan span = EntityTracer.create((String)"NoCodeRefBillTableGrid", (String)"bindData");){
            ArrayList<Map> controls;
            String hasRule;
            if (BlackFormUtil.isCosmicForm((String)this.getBillEntityIdEx())) {
                HashMap<String, Boolean> map = new HashMap<String, Boolean>(16);
                map.put("readonly", true);
                this.clientViewProxy.invokeControlMethod(this.getKey(), "setGridState", new Object[]{map});
            }
            String string = hasRule = this.getView().getPageCache().get("nocode_table_formrule" + this.getKey()) == null ? "false" : "true";
            if ("false".equals(hasRule) && !this.canShowNewBtn()) {
                controls = new ArrayList<Map>();
                controls.add(Maps.of((Object)"k", this.getCustomProperties().get("newEntry"), (Object)"v", (Object)"4"));
                this.clientViewProxy.addAction("setControlState", controls);
            }
            if ("false".equals(hasRule) && !this.canShowSelectBtn() && StringUtils.isNotBlank(this.getCustomProperties().get("selectEntry"))) {
                controls = new ArrayList();
                controls.add(Maps.of((Object)"k", this.getCustomProperties().get("selectEntry"), (Object)"v", (Object)"4"));
                this.clientViewProxy.addAction("setControlState", controls);
            }
            this.getView().getPageCache().remove("nocode_table_formrule" + this.getKey());
            List<String> fieldKeys = this.getFieldKeys();
            if (!fieldKeys.isEmpty()) {
                IDataEntityProperty property = this.getModel().getProperty(this.getRefBillKey());
                ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>();
                DynamicObjectCollection cols = this.getModel().getEntryEntity(this.getKey());
                if (cols.isEmpty() && StringUtils.isNotBlank((CharSequence)((INoCodeRefBillProp)property).getBillEntityId())) {
                    String pks;
                    INoCodeRefBillProp prop = (INoCodeRefBillProp)property;
                    MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)prop.getBillEntityId());
                    if (property instanceof NoCodeRefBillProp) {
                        DynamicObject dataEntity = (DynamicObject)this.getModel().getValue(this.getRefBillKey());
                        if (dataEntity != null) {
                            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)entityType.getName());
                            objs.add(obj);
                        }
                    } else if (property instanceof NoCodeMulRefBillProp && !StringUtils.isBlank((CharSequence)(pks = (String)this.getModel().getValue(this.getRefBillKey())))) {
                        String[] pkArray = pks.split(",");
                        ArrayList<Long> pkList = new ArrayList<Long>(10);
                        for (int i = 0; i < pkArray.length; ++i) {
                            pkList.add(Long.parseLong(pkArray[i]));
                        }
                        DynamicObject[] objArray = BusinessDataServiceHelper.load((Object[])pkList.toArray(new Object[0]), (DynamicObjectType)entityType);
                        Collections.addAll(objs, objArray);
                    }
                }
                if (objs.isEmpty()) {
                    this.getModel().updateEntryCache(cols);
                    super.bindData(bctx);
                    return;
                }
                boolean isCopy = false;
                if (this.getView().getFormShowParameter().getCustomParams().containsKey("iscopy")) {
                    isCopy = (Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy");
                }
                if (isCopy && "1".equals(this.getSourceForm())) {
                    this.getModel().setValue(this.getRefBillKey(), null);
                }
                this.fillTableData(cols, objs, fieldKeys, isCopy, new DynamicObjectCollection());
                this.getModel().updateEntryCache(cols);
                span.addLocaleTag("dataEntity:", (Object)this.getModel().getDataEntity(true));
                super.bindData(bctx);
            }
        }
    }

    public List<String> getFieldKeys() {
        ArrayList<String> fieldKeys = new ArrayList<String>();
        for (Control ctl : this.getControls()) {
            if (ctl instanceof NoCodeDateRangeEdit) {
                NoCodeDateRangeEdit rangeEdit = (NoCodeDateRangeEdit)ctl;
                fieldKeys.add(rangeEdit.getStartDateFieldKey());
                fieldKeys.add(rangeEdit.getEndDateFieldKey());
                continue;
            }
            if (!(ctl instanceof FieldEdit)) continue;
            fieldKeys.add(ctl.getKey());
        }
        return fieldKeys;
    }

    public void itemClick(String id, String operationKey) {
        FormOperate operate = (FormOperate)FormMetadataCache.getFormOperation((String)this.getView().getEntityId(), (String)operationKey);
        if (StringUtils.isNotBlank((CharSequence)operationKey)) {
            if (operate instanceof DeleteEntry && !NcEntityTypeUtil.isFormExist((String)this.getBillEntityIdEx())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664", (String)"NoCodeRefBillEdit_5", (String)"bos-nocode-ext", (Object[])new Object[0]));
                return;
            }
            this.getView().invokeOperation(operationKey);
        }
        if (operate instanceof DeleteEntry) {
            DynamicObjectCollection col = this.getModel().getEntryEntity(this.getKey());
            ArrayList<Object> pks = new ArrayList<Object>();
            for (DynamicObject obj : col) {
                if (obj.getPkValue() == null || Long.parseLong(obj.getPkValue().toString()) == 0L) continue;
                pks.add(obj.getPkValue());
            }
            IDataEntityProperty property = this.getModel().getProperty(this.getRefBillKey());
            if (property instanceof NoCodeRefBillProp) {
                if (pks.size() == 0) {
                    this.getModel().setValue(this.getRefBillKey(), null);
                } else {
                    this.getModel().setValue(this.getRefBillKey(), pks.get(0));
                }
            } else if (property instanceof NoCodeMulRefBillProp) {
                if (pks.size() == 0) {
                    this.getModel().setValue(this.getRefBillKey(), null);
                } else {
                    String pkIds = String.join((CharSequence)",", (CharSequence[])pks.stream().map(Object::toString).toArray(String[]::new));
                    this.getModel().setValue(this.getRefBillKey(), (Object)pkIds);
                }
            }
            ArrayList<RowDataEntity> objs = new ArrayList<RowDataEntity>(1);
            objs.add(new RowDataEntity(0, this.getModel().getDataEntity(true)));
            FormRuleContainer ruleContainer = (FormRuleContainer)this.view.getService(RuleContainer.class);
            ruleContainer.raiseItemAdded((IDataEntityType)this.getModel().getEntryEntity(this.getKey()).getDynamicObjectType(), objs, new FormRuleExecuteContext(this.view));
        }
    }

    public List<Object> getRowBindValue(BindingContext arg) {
        ArrayList<Object> entryRow = new ArrayList<Object>();
        entryRow.add(arg.getRowIndex());
        entryRow.add(arg.getRowIndex() + 1);
        DynamicObject obj = (DynamicObject)arg.getDataEntity();
        entryRow.add("" + obj.getPkValue());
        entryRow.add(null);
        for (Control ctl : this.getControls()) {
            ArrayList<OperationColItem> formatVal = null;
            ArrayList<OperationColItem> operationColItems = new ArrayList<OperationColItem>();
            if (ctl instanceof FieldEdit) {
                FieldEdit fldEdit = (FieldEdit)ctl;
                formatVal = fldEdit.getBindingValue(arg);
            } else if (ctl instanceof OperationColumn) {
                for (OperationColItem operationColItem : ((OperationColumn)ctl).getOperationColItems()) {
                    OperationColItem newOperationColItem = new OperationColItem(operationColItem);
                    operationColItems.add(newOperationColItem);
                }
                formatVal = operationColItems;
            }
            if (ctl instanceof OperationColumn) {
                entryRow.add(((OperationColumn)ctl).getBindingOperationColItems(operationColItems));
                continue;
            }
            if (!(ctl instanceof FieldEdit) || ((FieldEdit)ctl).isFlatField()) continue;
            entryRow.add(formatVal);
        }
        entryRow.add(new HashMap(0));
        entryRow.add(new HashMap(0));
        entryRow.add(new HashMap(0));
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(16);
        if (!this.canEditData(obj.getPkValue())) {
            map.put("canEditRow", false);
        } else {
            map.put("canEditRow", true);
        }
        entryRow.add(map);
        return entryRow;
    }

    private boolean canEditData(Object pk) {
        if ("1".equals(this.getSourceForm())) {
            return true;
        }
        if (BlackFormUtil.isCosmicForm((String)this.getBillEntityIdEx())) {
            return false;
        }
        if (StringUtils.isBlank((Object)pk)) {
            return true;
        }
        if (pk instanceof Long && (Long)pk == 0L) {
            return true;
        }
        return NoCodePermHelper.checkDataEditPermInNoCode((String)this.getBillEntityIdEx(), (Object)pk);
    }

    public void getListConfig(List<Object> args) {
        NoCodeMulRefBillEdit refBillEdit = (NoCodeMulRefBillEdit)this.getView().getControl(this.getRefBillKey());
        Map<String, Object> result = refBillEdit.getTableConfig(args);
        if (!result.isEmpty()) {
            this.invokeSetListConfig(result);
        }
    }

    public void showInfo(List<Object> args) {
        String childKey = (String)args.get(1);
        FieldEdit noCodeEdit = (FieldEdit)this.getView().getControl(childKey);
        List<Map<String, Object>> list = null;
        if (noCodeEdit instanceof NoCodeMulRefBillEdit) {
            list = ((NoCodeMulRefBillEdit)noCodeEdit).getInfo(args);
        } else if (noCodeEdit instanceof NoCodeRefBillEdit) {
            list = ((NoCodeRefBillEdit)noCodeEdit).getInfo(args);
        }
        if (list == null) {
            return;
        }
        String target = "";
        if (noCodeEdit instanceof NoCodeMulRefBillEdit) {
            NoCodeMulRefBillEdit refBillEdit = (NoCodeMulRefBillEdit)noCodeEdit;
            target = NcEntityTypeUtil.getRealBillEntityNumber((String)((INoCodeRefBillProp)refBillEdit.getProperty()).getBillEntityId());
        } else if (noCodeEdit instanceof NoCodeRefBillEdit) {
            NoCodeRefBillEdit refBillEdit = (NoCodeRefBillEdit)noCodeEdit;
            target = NcEntityTypeUtil.getRealBillEntityNumber((String)((INoCodeRefBillProp)refBillEdit.getProperty()).getBillEntityId());
        }
        if ("bos_user".equals(target)) {
            this.invokeUserInfo(list);
        } else if ("bos_adminorg".equals(target)) {
            this.invokeOrgInfo(list);
        }
    }

    private void invokeUserInfo(List<Map<String, Object>> list) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.addAction("InvokeControlMethod", (Object)Maps.of((Object)"key", (Object)this.key, (Object)"methodname", (Object)"showUserInfo", (Object)"args", list));
    }

    private void invokeOrgInfo(List<Map<String, Object>> list) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.addAction("InvokeControlMethod", (Object)Maps.of((Object)"key", (Object)this.key, (Object)"methodname", (Object)"showOrgInfo", (Object)"args", list));
    }

    public void getListQuery(List<Object> args) {
        NoCodeMulRefBillEdit refBillEdit = (NoCodeMulRefBillEdit)this.getView().getControl(this.getRefBillKey());
        Map<String, Object> result = refBillEdit.getTableData(args);
        if (!result.isEmpty()) {
            this.invokeSetListQuery(result);
        }
    }

    public void getHeadFieldFilterItem(List<Object> args) {
        NoCodeMulRefBillEdit refBillEdit = (NoCodeMulRefBillEdit)this.getView().getControl(this.getRefBillKey());
        Map<String, Object> result = refBillEdit.getTableFilterItem(args);
        if (!result.isEmpty()) {
            this.invokeSetHeadFieldFilterItem(result);
        }
    }

    public void addNewRef(List<Object> args) {
        NoCodeMulRefBillEdit refBillEdit = (NoCodeMulRefBillEdit)this.getView().getControl(this.getRefBillKey());
        refBillEdit.addNewRef(args);
    }

    public void editInfo(List<Object> args) {
        NoCodeMulRefBillEdit refBillEdit = (NoCodeMulRefBillEdit)this.getView().getControl(this.getRefBillKey());
        refBillEdit.editInfo(args);
    }

    public void getLookUpList(List<Object> args) {
        if (StringUtils.isBlank((CharSequence)this.getBillEntityIdEx())) {
            this.lookUpListInvoke(new HashMap<String, Object>());
            return;
        }
        NoCodeMulRefBillEdit refBillEdit = (NoCodeMulRefBillEdit)this.getView().getControl(this.getRefBillKey());
        if (args != null) {
            BillEntityType dt = refBillEdit.getMainEntityType();
            if (dt == null) {
                this.lookUpListInvoke(new HashMap<String, Object>());
                return;
            }
            this.lookUpListInvoke(refBillEdit.getLookUpData(args, dt));
        }
    }

    private void lookUpListInvoke(Map<String, Object> data) {
        data.put("r", -1);
        this.clientViewProxy.invokeControlMethod(this.key, "setLookUpListValue", new Object[]{data});
    }

    private void invokeSetHeadFieldFilterItem(Map<String, Object> data) {
        data.put("r", -1);
        this.clientViewProxy.invokeControlMethod(this.key, "setHeadFieldFilterItem", new Object[]{data});
    }

    private void invokeSetListQuery(Map<String, Object> data) {
        data.put("r", -1);
        this.clientViewProxy.invokeControlMethod(this.key, "setListQuery", new Object[]{data});
    }

    private void invokeSetListConfig(Map<String, Object> data) {
        data.put("r", -1);
        this.clientViewProxy.invokeControlMethod(this.key, "setListConfig", new Object[]{data});
    }

    public void appendTableRows(Map<String, Object> map) {
        try (EntityTraceSpan span = EntityTracer.create((String)"NoCodeRefBillTableGrid", (String)"appendTableRows");){
            ArrayList<Long> appendRows = new ArrayList<Long>(10);
            List ids = (List)map.get("rows");
            for (String id : ids) {
                appendRows.add(Long.parseLong(id));
            }
            DynamicObjectCollection col = this.getModel().getEntryEntity(this.getKey());
            DynamicObjectCollection newObjs = new DynamicObjectCollection();
            if (this.getMulti() == 0) {
                col.clear();
            } else {
                col.removeIf(obj -> {
                    Object pkValue = obj.getPkValue();
                    return pkValue != null && Long.parseLong(obj.getPkValue().toString()) != 0L;
                });
                newObjs = (DynamicObjectCollection)col.clone();
                col.clear();
            }
            List<String> fieldKeys = this.getFieldKeys();
            ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>();
            if (!appendRows.isEmpty()) {
                String billEntityId = "";
                IDataEntityProperty property = this.getModel().getProperty(this.getRefBillKey());
                if (property instanceof NoCodeRefBillProp) {
                    billEntityId = ((NoCodeRefBillProp)property).getBillEntityId();
                } else if (property instanceof NoCodeMulRefBillProp) {
                    billEntityId = ((NoCodeMulRefBillProp)property).getBillEntityId();
                }
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billEntityId);
                DynamicObject[] objArray = BusinessDataServiceHelper.load((Object[])appendRows.toArray(new Object[0]), (DynamicObjectType)entityType);
                Collections.addAll(objs, objArray);
            }
            this.fillTableData(col, objs, fieldKeys, false, newObjs);
            this.getModel().updateEntryCache(col);
            super.bindData(new BindingContext((Object)this.getModel().getDataEntity(true), 0));
            IDataEntityProperty property = this.getModel().getProperty(this.getRefBillKey());
            if (property instanceof NoCodeRefBillProp) {
                if (ids.size() == 0) {
                    this.getModel().setValue(this.getRefBillKey(), null);
                } else {
                    this.getModel().setValue(this.getRefBillKey(), (Object)Long.parseLong((String)ids.get(0)));
                }
            } else if (property instanceof NoCodeMulRefBillProp) {
                if (ids.size() == 0) {
                    this.getModel().setValue(this.getRefBillKey(), null);
                } else {
                    String pkIds = ids.stream().collect(Collectors.joining(","));
                    this.getModel().setValue(this.getRefBillKey(), (Object)pkIds);
                }
            }
            ArrayList<RowDataEntity> rows = new ArrayList<RowDataEntity>(1);
            rows.add(new RowDataEntity(0, this.getModel().getDataEntity(true)));
            FormRuleContainer ruleContainer = (FormRuleContainer)this.view.getService(RuleContainer.class);
            RaiseEventSource s = new RaiseEventSource(RaiseEventType.ItemReset, rows, (IDataEntityType)this.getModel().getEntryEntity(this.getKey()).getDynamicObjectType());
            ruleContainer.raise(s, (RuleExecuteContext)new FormRuleExecuteContext(this.view));
            span.addLocaleTag("before appendRows dataEntity:", (Object)this.getModel().getDataEntity(true));
        }
    }

    @SimplePropertyAttribute
    public String getBillEntityIdEx() {
        return this.billEntityIdEx;
    }

    public void setBillEntityIdEx(String billEntityIdEx) {
        this.billEntityIdEx = billEntityIdEx;
    }

    public void fillTableData(DynamicObjectCollection cols, List<DynamicObject> objs, List<String> fieldKeys, boolean isCopy, DynamicObjectCollection newObjs) {
        for (int i = 0; i < objs.size(); ++i) {
            DynamicObject obj = objs.get(i);
            DynamicObject entryObj = new DynamicObject(cols.getDynamicObjectType());
            for (String key : fieldKeys) {
                String refTableKey = key.substring(0, key.lastIndexOf("_"));
                if (key.endsWith("_startdate") || key.endsWith("_enddate")) {
                    refTableKey = obj.getDynamicObjectType().getProperty(key) != null ? key : refTableKey.substring(0, refTableKey.lastIndexOf("_")) + key.substring(key.lastIndexOf("_"));
                }
                if (obj.getDynamicObjectType().getProperty(refTableKey) instanceof NoCodeAttachmentProp) {
                    if (isCopy && "1".equals(this.getSourceForm())) {
                        DynamicObjectCollection collection = obj.getDynamicObjectCollection(refTableKey);
                        DynamicObject newObj = new DynamicObject(obj.getDynamicObjectType());
                        DynamicObjectCollection newDynObjColl = newObj.getDynamicObjectCollection(refTableKey);
                        ((IAttachmentService)ServiceFactory.getService(IAttachmentService.class)).copyAttachmentField(collection, newDynObjColl, this.getView().getPageId());
                        entryObj.set(key, (Object)newDynObjColl);
                        continue;
                    }
                    entryObj.set(key, obj.get(refTableKey));
                    continue;
                }
                if ("bos_user".equals(this.getBillEntityIdEx()) && "gender".equals(refTableKey)) {
                    String gender = StringUtils.isBlank((Object)obj.get(refTableKey)) ? "" : this.transformGender(obj.get(refTableKey).toString());
                    entryObj.set(key, (Object)gender);
                    continue;
                }
                if (obj.getDynamicObjectType().getProperty(refTableKey) == null) {
                    this.getView().showErrorNotification(entryObj.getDynamicObjectType().getDisplayName().toString() + ResManager.loadKDString((String)"\u8868\u683c\u7684", (String)"NoCodeRefBillTableGrid_0", (String)"bos-nocode-ext", (Object[])new Object[0]) + entryObj.getDynamicObjectType().getProperty(key).getDisplayName().toString() + ResManager.loadKDString((String)"\u5b57\u6bb5\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u53d1\u5e03\u5f53\u524d\u8868\u5355", (String)"NoCodeRefBillTableGrid_1", (String)"bos-nocode-ext", (Object[])new Object[0]));
                    return;
                }
                entryObj.set(key, obj.get(refTableKey));
            }
            if (!isCopy || !"1".equals(this.getSourceForm())) {
                entryObj.set("id", obj.getPkValue());
            }
            cols.add((Object)entryObj);
        }
        cols.addAll((Collection)newObjs);
    }

    private String transformGender(String val) {
        if ("1".equals(val)) {
            return ResManager.loadKDString((String)"\u7537", (String)"NoCodeRefBillTableGrid_2", (String)"bos-nocode-ext", (Object[])new Object[0]);
        }
        if ("2".equals(val)) {
            return ResManager.loadKDString((String)"\u5973", (String)"NoCodeRefBillTableGrid_3", (String)"bos-nocode-ext", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u4fdd\u5bc6", (String)"NoCodeRefBillTableGrid_4", (String)"bos-nocode-ext", (Object[])new Object[0]);
    }

    private boolean canShowNewBtn() {
        if (!StringUtils.isBlank((CharSequence)this.getGridStatus()) && !"1".equals(this.getGridStatus())) {
            return false;
        }
        if ("1".equals(this.getSourceForm())) {
            return true;
        }
        if (BlackFormUtil.isCosmicForm((String)this.getBillEntityIdEx())) {
            return false;
        }
        CodelessShareSessionServiceImpl sessionService = new CodelessShareSessionServiceImpl();
        return !sessionService.isNocodeShareSession(RequestContext.get().getGlobalSessionId());
    }

    private boolean canShowSelectBtn() {
        if (!StringUtils.isBlank((CharSequence)this.getGridStatus()) && !"1".equals(this.getGridStatus())) {
            return false;
        }
        return !"1".equals(this.getSourceForm());
    }

    @SimplePropertyAttribute
    public String getGridStatus() {
        return this.gridStatus;
    }

    public void setGridStatus(String gridStatus) {
        this.gridStatus = gridStatus;
    }
}

