/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.form.field;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.nocode.ext.form.field.NoCodeEdit;
import kd.bos.nocode.ext.form.field.NoCodeReadableEdit;
import kd.bos.nocode.ext.property.NoCodeDateTimeProp;
import kd.bos.util.StringUtils;

public class NoCodeDateRangeEdit
extends DateRangeEdit
implements NoCodeReadableEdit,
NoCodeEdit {
    private static final String START = "start";
    private static final String END = "end";

    public void postBack(Object value, int rowIndex, int parentRowIndex) {
        this.beforePostBack(this.getModel(), this.getKey());
        IDataModel model = (IDataModel)this.view.getService(IDataModel.class);
        IDataEntityProperty prop = model.getProperty(this.getStartDateFieldKey());
        DateFormat simpleDateFormat = ((NoCodeDateTimeProp)prop).getDateFormat();
        try {
            boolean isOnlyStartDateChanged;
            Object oldEndDateValue;
            Object oldStartDateValue;
            Date startDate = null;
            Date endDate = null;
            if (value != null) {
                String end;
                Map map = (Map)value;
                String start = (String)map.get(START);
                if (StringUtils.isNotEmpty((String)start)) {
                    startDate = simpleDateFormat.parse(start);
                }
                if (StringUtils.isNotEmpty((String)(end = (String)map.get(END)))) {
                    endDate = simpleDateFormat.parse(end);
                }
            }
            IDataModel dataModel = this.view.getModel();
            IDataEntityProperty startDateProp = dataModel.getProperty(this.getStartDateFieldKey());
            IDataEntityProperty endDateProp = dataModel.getProperty(this.getEndDateFieldKey());
            if (StringUtils.isNotEmpty((String)this.getEntryKey())) {
                DynamicObject rowDynamicObject = dataModel.getEntryRowEntity(this.getEntryKey(), rowIndex);
                oldStartDateValue = rowDynamicObject.getDataStorage().getLocalValue(startDateProp);
                oldEndDateValue = rowDynamicObject.getDataStorage().getLocalValue(endDateProp);
            } else {
                oldStartDateValue = dataModel.getDataEntity().getDataStorage().getLocalValue(startDateProp);
                oldEndDateValue = dataModel.getDataEntity().getDataStorage().getLocalValue(endDateProp);
            }
            boolean bl = isOnlyStartDateChanged = !this.isValueEquals(oldStartDateValue, startDate) && this.isValueEquals(oldEndDateValue, endDate);
            if (!isOnlyStartDateChanged) {
                this.setAllowBindData(false);
            }
            dataModel.setValue(this.getStartDateFieldKey(), (Object)startDate, rowIndex, parentRowIndex);
            this.setAllowBindData(true);
            dataModel.setValue(this.getEndDateFieldKey(), (Object)endDate, rowIndex, parentRowIndex);
        }
        catch (ParseException e) {
            throw new KDBizException((Throwable)e, BosErrorCode.parse, new Object[]{e.toString()});
        }
    }

    private boolean isValueEquals(Object v1, Object v2) {
        if (v1 == null && v2 == null) {
            return true;
        }
        if (v1 == null) {
            return false;
        }
        return v1.equals(v2);
    }

    protected Object getValue(Object startDate, Object endDate) {
        IDataModel dataModel = (IDataModel)this.view.getService(IDataModel.class);
        IDataEntityProperty prop = dataModel.getProperty(this.getStartDateFieldKey());
        HashMap<String, String> result = new HashMap<String, String>(2);
        if (prop instanceof DateTimeProp) {
            if (startDate != null) {
                result.put(START, startDate instanceof Date ? ((DateTimeProp)prop).getDateFormat().format(startDate) : startDate.toString());
            } else {
                result.put(START, null);
            }
            if (endDate != null) {
                result.put(END, endDate instanceof Date ? ((DateTimeProp)prop).getDateFormat().format(endDate) : endDate.toString());
            } else {
                result.put(END, null);
            }
        } else {
            result.put(START, startDate.toString());
            result.put(END, endDate.toString());
        }
        return result;
    }

    protected boolean canRead() {
        return this.canRead(this.view, this.key);
    }
}

