/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.form.field;

import java.util.Map;
import kd.bos.dataentity.entity.ILocaleValue;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.nocode.ext.datamask.DataMaskFactory;
import kd.bos.nocode.ext.datamask.IDataMaskProcessor;
import kd.bos.nocode.ext.property.NoCodeTextProp;

public interface NoCodeEdit {
    default public Object getDesensitizeValue(Object value, IDataEntityProperty prop) {
        if (!(prop instanceof NoCodeTextProp)) {
            return value;
        }
        if (StringUtils.isBlank((Object)value)) {
            return value;
        }
        String dataMasking = "";
        if (prop instanceof NoCodeTextProp) {
            dataMasking = ((NoCodeTextProp)prop).getDataMasking();
        }
        if (StringUtils.isBlank((CharSequence)dataMasking)) {
            return value;
        }
        Map dataMaskMap = (Map)SerializationUtils.fromJsonString((String)dataMasking, Map.class);
        String maskType = (String)dataMaskMap.get("maskType");
        IDataMaskProcessor processor = DataMaskFactory.getDataMaskprocessor(maskType);
        String result = processor.getDesensitizeValue(dataMaskMap, value);
        if (value instanceof ILocaleValue) {
            return new LocaleString(result);
        }
        return result;
    }

    default public void beforePostBack(IDataModel model, String fieldKey) {
        model.putContextVariable("nocode_current_editable_fieldkey", (Object)fieldKey);
    }
}

