/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.form.field;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.GeoPointProp;
import kd.bos.entity.property.NameVersionEntryProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.BindingContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.constant.BillConsts;
import kd.bos.nocode.ext.form.field.NoCodeEdit;
import kd.bos.nocode.ext.form.field.NoCodeReadableEdit;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeDataRangeField;
import kd.bos.nocode.ext.metadata.entity.field.SelectScope;
import kd.bos.nocode.ext.property.NoCodeMulRefBillProp;
import kd.bos.nocode.ext.property.NoCodeRefBillProp;
import kd.bos.nocode.ext.proxy.EntityTypeUtilsProxy;
import kd.bos.nocode.ext.proxy.FuzzySearchUtilsProxy;
import kd.bos.nocode.ext.proxy.PropertyHandleUtilProxy;
import kd.bos.nocode.ext.util.FormMetadataUtils;
import kd.bos.nocode.mservice.NoCodeDefValueCalculatorService;
import kd.bos.nocode.mservice.NoCodeFilterService;
import kd.bos.nocode.property.INoCodeGraphicDisplayProp;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.property.INoCodeRichTextProp;
import kd.bos.nocode.restapi.RestApiWrap;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiRequest;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.api.sys.SysServiceFormId;
import kd.bos.nocode.restapi.common.constant.ApiVersion;
import kd.bos.nocode.restapi.common.constant.HttpMethod;
import kd.bos.nocode.restapi.common.constant.OperationType;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.JsonUtil;
import kd.bos.nocode.restapi.common.util.Maps;
import kd.bos.nocode.servicehelper.AssociationServiceHelper;
import kd.bos.nocode.servicehelper.DispatchApiServiceHelper;
import kd.bos.nocode.servicehelper.ServiceFactory;
import kd.bos.nocode.utils.BlackFormUtil;
import kd.bos.nocode.utils.FieldTreeBuilder;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.utils.FuncPermItemEnum;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NoCodeOrgServiceHelper;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.url.UrlService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

@KSObject
public class NoCodeMulRefBillEdit
extends FieldEdit
implements NoCodeReadableEdit,
NoCodeEdit {
    private static final int DEFAULT_PAGE_SIZE = 20;
    private static final int INITIAL_CAPACITY = 10;
    private static final int ARGS_IDX_SEARCH = 3;
    private static final int ARGS_IDX_ORDER_BY = 4;
    private static final int KEY_FIELDS_MAX_COUNT = 3;
    private static final String SET_LIST_QUERY = "setListQuery";
    private static final String SET_SELECTED_DISP = "setSelectedDisp";
    private static final String SET_LIST_CONFIG = "setListConfig";
    private static final String SET_FILTER_ITEM_LOOK = "setFilterItemLook";
    private static final String SET_ENTRY_DATA = "setEntryData";
    private static final String SET_HEAD_FIELD_FILTER_ITEM = "setHeadFieldFilterItem";
    private static final Log logger = LogFactory.getLog(NoCodeMulRefBillEdit.class);
    private static final String BOS_NOCODE_EXT = "bos-nocode-ext";
    private static final String FROM_REF_BILL = "fromrefbill";
    private static final String RESET_VALUE = "resetValue";
    private static final String KEY_V = "v";
    private static final String KEY_F = "f";
    private static final String ARGS = "args";
    private static final String LIST_CONFIG = "listConfig";
    private static final String SET_QUERY = "setQuery";

    protected void checkNullException() {
        if (StringUtils.isBlank((CharSequence)this.getBillEntityId())) {
            String name = (String)this.prop.getDisplayName().getDefaultItem();
            String errors = ResManager.loadKDString((String)"\u201c%s\u201d\u5173\u8054\u7684\u201c\u5173\u8054\u5176\u4ed6\u8868\u5355\u201d\u4e0d\u80fd\u4e3a\u7a7a", (String)"NoCodeMulRefBillEdit_0", (String)BOS_NOCODE_EXT, (Object[])new Object[]{name});
            throw new KDBizException(errors);
        }
    }

    protected String getDisplayProperty() {
        return ((INoCodeRefBillProp)this.getProperty()).getPropsDisplay();
    }

    protected List<Map<String, Object>> getDefaultFilterRows() {
        SelectScope selectScope = (SelectScope)((INoCodeRefBillProp)this.getProperty()).getSelectScope();
        if (!selectScope.isEnable()) {
            return new ArrayList<Map<String, Object>>(0);
        }
        List defaultFilterRows = SerializationUtils.fromJsonStringToList((String)SerializationUtils.toJsonString(selectScope.getValue()), Map.class);
        if ("bos_adminorg".equalsIgnoreCase(((INoCodeRefBillProp)this.getProperty()).getBillEntityId())) {
            defaultFilterRows.stream().filter(e -> "parent".equalsIgnoreCase((String)e.get("fieldName"))).forEach(e -> e.put("fieldName", "structure.viewparent.name"));
        }
        NoCodeDefValueCalculatorService defValueCalculatorService = (NoCodeDefValueCalculatorService)ServiceFactory.getService((String)"NoCodeDefValueCalculatorService");
        defValueCalculatorService.parseExpression(defaultFilterRows, this.getModel());
        return defaultFilterRows;
    }

    public Object getBindingValue(BindingContext bctx) {
        Object v = super.getBindingValue(bctx);
        if (v == null) {
            return null;
        }
        return this.getBindingRefBillValue(v);
    }

    protected Object getBindingRefBillValue(Object v) {
        IDataEntityProperty property = this.getProperty();
        if (property instanceof NoCodeMulRefBillProp) {
            NoCodeMulRefBillProp mulRefBillProp = (NoCodeMulRefBillProp)property;
            Object bindValue = mulRefBillProp.getBindingRefBillValue(v);
            return bindValue;
        }
        NoCodeRefBillProp refBillProp = (NoCodeRefBillProp)property;
        Object bindValue = refBillProp.getBindingRefBillValueFromMulRefEditor(v);
        return bindValue;
    }

    public void getLookUpList(List<Object> args) {
        if (StringUtils.isBlank((CharSequence)this.getBillEntityId())) {
            this.lookUpListInvoke(new HashMap<String, Object>());
            return;
        }
        if (args != null) {
            BillEntityType dt = this.getMainEntityType();
            if (dt == null) {
                this.lookUpListInvoke(new HashMap<String, Object>());
                return;
            }
            this.lookUpListInvoke(this.getLookUpData(args, dt));
        }
    }

    public Map<String, Object> getLookUpData(List<Object> args, BillEntityType dt) {
        String searchKey = (String)args.get(1);
        if (searchKey == null) {
            searchKey = "";
        }
        searchKey = searchKey.trim();
        Object[] selectedPks = this.parseSelectedPks(args, dt);
        int top = 50;
        HashMap<String, Object> data = new HashMap<String, Object>();
        String formId = this.getBillEntityId();
        FieldTreeBuilder fieldTreeBuilder = new FieldTreeBuilder(formId);
        List fieldTree = fieldTreeBuilder.withFeature(new FieldTreeBuilder.Feature[]{FieldTreeBuilder.Feature.IncludePK, FieldTreeBuilder.Feature.AttachmentDetail}).withSelectFields(this.getSelectFields()).withoutFieldTypes(new FieldTreeBuilder.FieldType[]{FieldTreeBuilder.FieldType.NoCodeRichTextField, FieldTreeBuilder.FieldType.NoCodeGraphicDisplayField, FieldTreeBuilder.FieldType.NoCodeAttachmentUploadField, FieldTreeBuilder.FieldType.NoCodeImageUploadField, FieldTreeBuilder.FieldType.EntryField}).build();
        data.put("columns", fieldTree);
        Tuple<List<Object>, Boolean> qData = this.queryDataForLookup(searchKey, dt, top, selectedPks);
        data.put("data", qData.item1);
        data.put("next", qData.item2);
        data.put("k", this.key);
        data.put("size", top);
        data.put(ARGS, args);
        return data;
    }

    private Object[] parseSelectedPks(List<Object> args, BillEntityType dt) {
        String selectedStr = "";
        Object[] selectedPks = new Object[]{};
        if (args.get(3) instanceof ArrayList && !((ArrayList)args.get(3)).isEmpty()) {
            ArrayList pks = (ArrayList)args.get(3);
            if (!pks.isEmpty()) {
                selectedPks = new Object[pks.size()];
                for (int i = 0; i < pks.size(); ++i) {
                    selectedPks[i] = NcEntityTypeUtil.convertPKValueType((DynamicObjectType)dt, pks.get(i));
                }
            }
        } else if (args.get(3) instanceof String && StringUtils.isNotBlank((CharSequence)((String)args.get(3)))) {
            selectedStr = (String)args.get(3);
            String[] split = selectedStr.split(",");
            selectedPks = new Object[split.length];
            for (int i = 0; i < split.length; ++i) {
                selectedPks[i] = NcEntityTypeUtil.convertPKValueType((DynamicObjectType)dt, (Object)split[i]);
            }
        } else {
            selectedPks = new Object[]{};
        }
        return selectedPks;
    }

    private Tuple<List<Object>, Boolean> queryDataForLookup(String searchKey, BillEntityType dt, int top, Object[] selectedPks) {
        List<Map<String, Object>> selectedData;
        boolean check;
        ArrayList<List<Object>> data = new ArrayList<List<Object>>();
        String selectFields = this.getSelectFields();
        Set hides = NoCodePermHelper.getNoViewFieldPermSet((String)dt.getName());
        List<String> collect = Arrays.stream(selectFields.split(",")).collect(Collectors.toList());
        collect.removeIf(hides::contains);
        String[] fields = collect.toArray(new String[0]);
        String orderBys = "id desc";
        ArrayList<String> searchFields = new ArrayList<String>();
        String displayProperty = this.getSelectFields();
        if (StringUtils.isNotBlank((CharSequence)displayProperty)) {
            for (String key : displayProperty.split(",")) {
                if (!EntityTypeUtilsProxy.existProperty((DynamicObjectType)dt, key)) continue;
                searchFields.add(key);
            }
        }
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String appId = showParameter.getAppId();
        boolean share = NoCodePermHelper.isShare((String)appId, (String)showParameter.getFormId(), (String)this.getView().getParentView().getPageCache().get("noCodeShareId"));
        String formId = dt.getName();
        if (!share ? !(check = NoCodePermHelper.checkFuncPermInNoCode((FuncPermItemEnum)FuncPermItemEnum.view, (String)formId)) : share && !(check = NoCodePermHelper.checkPublishEnt((String)appId, (String)formId))) {
            return new Tuple((Object)Collections.EMPTY_LIST, (Object)false);
        }
        List<Map<String, Object>> resultData = null;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        List<Map<String, Object>> defaultFilterRows = this.getDefaultFilterRows();
        if (!CollectionUtils.isEmpty(defaultFilterRows)) {
            NoCodeFilterService noCodeFilterService = (NoCodeFilterService)ServiceFactory.getService((String)"NoCodeFilterService");
            Object[] defaultQFilters = noCodeFilterService.getQFilters(formId, defaultFilterRows);
            CollectionUtils.addAll(filters, (Object[])defaultQFilters);
        }
        if (!share) {
            List permFilters = NoCodePermHelper.getDataPermFilters((String)formId);
            filters.addAll(permFilters);
        }
        if (selectedPks.length > 0) {
            QFilter filter = new QFilter("id", "not in", (Object)selectedPks);
            filters.add(filter);
        }
        if (StringUtils.isNotBlank((CharSequence)searchKey)) {
            Collection properties = dt.getAllFields().values();
            properties = properties.stream().filter(p -> searchFields.contains(p.getName())).collect(Collectors.toList());
            QFilter filter = FuzzySearchUtilsProxy.getSearchQFilter(dt.getName(), properties, searchKey);
            if (selectedPks.length > 0) {
                filter = filter.or(new QFilter("id", "in", (Object)selectedPks));
            }
            filters.add(filter);
            resultData = this.queryData(dt, filters.toArray(new QFilter[filters.size()]), orderBys, top + 1, selectedPks);
        } else {
            resultData = this.queryData(dt, filters.toArray(new QFilter[filters.size()]), orderBys, top + 1, selectedPks);
        }
        if (selectedPks.length > 0 && (selectedData = this.queryData(dt, new QFilter[]{new QFilter("id", "in", (Object)selectedPks)}, orderBys, top + 1, selectedPks)) != null && !selectedData.isEmpty()) {
            if (StringUtils.isNotBlank((CharSequence)searchKey)) {
                resultData.addAll(selectedData);
            } else {
                resultData.addAll(0, selectedData);
            }
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(fields));
        list.add(0, "cprop");
        String[] newFields = list.toArray(new String[0]);
        int keyFieldsCount = Math.max(newFields.length, 3);
        for (int i = 0; i < resultData.size(); ++i) {
            Map<String, Object> dynamicObjectMap = resultData.get(i);
            Object[] arr = new String[keyFieldsCount];
            for (int j = 0; j < keyFieldsCount; ++j) {
                arr[j] = "";
            }
            this.setDataByFields(newFields, dynamicObjectMap, arr);
            if (StringUtils.isNotBlank((CharSequence)searchKey) && !Arrays.stream(arr).anyMatch(a -> a != null && ((String)a).contains(searchKey)) && !this.existPkInSelected(selectedPks, dynamicObjectMap.get(dt.getPrimaryKey().getName()))) continue;
            data.add(Arrays.asList(arr));
        }
        Boolean hasNext = data.size() > top;
        return new Tuple(data, (Object)hasNext);
    }

    private boolean existPkInSelected(Object[] selectedPks, Object pk) {
        if (selectedPks == null || selectedPks.length == 0 || pk == null) {
            return false;
        }
        String pkStr = pk.toString();
        for (int i = 0; i < selectedPks.length; ++i) {
            String currStr;
            Object curr = selectedPks[i];
            if (curr == null || !pkStr.equalsIgnoreCase(currStr = curr.toString())) continue;
            return true;
        }
        return false;
    }

    private List<Map<String, Object>> queryData(BillEntityType dt, QFilter[] filters, String orderBys, int top, Object[] selectedPks) {
        String selectFields = this.getSelectFields();
        if ("bos_adminorg".equalsIgnoreCase(dt.getName())) {
            filters = (QFilter[])ArrayUtils.add((Object[])filters, (Object)new QFilter("structure.isfreeze", "=", (Object)Boolean.FALSE));
            filters = (QFilter[])ArrayUtils.add((Object[])filters, (Object)new QFilter("structure.view.number", "=", (Object)"01"));
            filters = (QFilter[])ArrayUtils.add((Object[])filters, (Object)new QFilter("fisadministrative", "=", (Object)Boolean.TRUE));
            filters = (QFilter[])ArrayUtils.add((Object[])filters, (Object)new QFilter("structure.vieworg.id", "=", (Object)NoCodeOrgServiceHelper.getRootOrgId()).or(QFilter.like((String)"structure.longnumber", (String)NoCodeOrgServiceHelper.getRootNumberSuffixLike())));
        } else if ("bos_user".equalsIgnoreCase(dt.getName())) {
            filters = (QFilter[])ArrayUtils.add((Object[])filters, (Object)new QFilter("enable", "=", (Object)Boolean.TRUE));
            filters = (QFilter[])ArrayUtils.add((Object[])filters, (Object)new QFilter("usertype", "!=", (Object)"7"));
        }
        Tuple tuple = AssociationServiceHelper.existAssociation((String)this.getView().getEntityId(), (String)this.getKey());
        String lastFields = selectFields;
        if (((Boolean)tuple.item1).booleanValue()) {
            lastFields = lastFields + "," + (String)tuple.item2;
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)dt.getName(), (String)lastFields, (QFilter[])filters, (String)orderBys, (int)top);
        List<Map<String, Object>> rows = PropertyHandleUtilProxy.toMapListRoot(dt.getName(), "$", dynamicObjects, Sets.newHashSet((Object[])lastFields.split(",")));
        if (((Boolean)tuple.item1).booleanValue()) {
            for (Map<String, Object> row : rows) {
                String[] segs;
                DynamicProperty property = dt.getProperty((String)tuple.item2);
                if (property instanceof NoCodeRefBillProp) {
                    if (row.get(tuple.item2) == null || this.containSelf(row, (String)tuple.item2 + ".id")) continue;
                    HashMap o = row.get("cprop") == null ? new HashMap() : (HashMap)row.get("cprop");
                    o.put("_state_", "disabled");
                    row.put("cprop", SerializationUtils.toJsonString((Object)o));
                    continue;
                }
                if (!(property instanceof NoCodeMulRefBillProp)) continue;
                NoCodeMulRefBillProp prop = (NoCodeMulRefBillProp)property;
                int max = Integer.parseInt(prop.getDataRange().getMax());
                String value = row.get(tuple.item2) == null ? null : row.get(tuple.item2).toString();
                if (StringUtils.isBlank(value) || value == null) continue;
                if (selectedPks != null) {
                    Long rowId = Long.parseLong(row.get("id").toString());
                    boolean containSelf = Arrays.stream(selectedPks).anyMatch(pk -> pk instanceof Long && pk.equals(rowId));
                    if (containSelf) continue;
                }
                if ((segs = value.split(",")).length < max) continue;
                HashMap o = row.get("cprop") == null ? new HashMap() : (HashMap)row.get("cprop");
                o.put("_state_", "disabled");
                row.put("cprop", SerializationUtils.toJsonString((Object)o));
            }
        }
        if ("bos_adminorg".equalsIgnoreCase(dt.getName()) && selectFields.contains("parent")) {
            this.addParentField(rows);
        }
        return rows;
    }

    private boolean containSelf(Map<String, Object> row, String refKeyId) {
        Long refId;
        Object dataPk = this.getModel().getDataEntity().getPkValue();
        if (dataPk == null || Long.parseLong(this.getModel().getDataEntity().getPkValue().toString()) == 0L) {
            return false;
        }
        Long currentPk = Long.parseLong(dataPk.toString());
        return currentPk.equals(refId = Long.valueOf(Long.parseLong(row.get(refKeyId).toString())));
    }

    private void addParentField(List<Map<String, Object>> rows) {
        rows.forEach(this::addParentField);
    }

    private void addParentField(Map<String, Object> row) {
        Long id = Long.parseLong(String.valueOf(row.get("id")));
        Map directSuperiorOrg = OrgUnitServiceHelper.getDirectSuperiorOrg((String)"01", Collections.singletonList(id));
        Long parentId = (Long)directSuperiorOrg.get(id);
        HashMap<String, Object> parent = new HashMap<String, Object>(2);
        if (Objects.isNull(parentId) || parentId == 0L) {
            parent.put("id", parentId);
            parent.put("name", "");
        } else {
            Map parentProperties = OrgUnitServiceHelper.getOrgProperty((long)parentId, (List)Lists.newArrayList((Object[])new String[]{"name"}));
            String name = "";
            name = MapUtils.isEmpty((Map)parentProperties) ? "" : ((ILocaleString)parentProperties.get("name")).getLocaleValue();
            parent.put("id", parentId);
            parent.put("name", name);
        }
        row.put("parent", parent.get("name"));
    }

    public String getSelectFields() {
        BillEntityType dt = this.getMainEntityType();
        ISimpleProperty primaryKey = dt.getPrimaryKey();
        ArrayList<String> props = new ArrayList<String>(10);
        props.add(primaryKey.getName());
        if (StringUtils.isNotBlank((CharSequence)this.getDisplayProperty())) {
            String[] split;
            for (String f : split = this.getDisplayProperty().split(",")) {
                IDataEntityProperty property = dt.findProperty(f);
                if (property == null || NoCodeMulRefBillEdit.defaultIgnoreProp(property)) continue;
                props.add(f);
            }
        }
        return String.join((CharSequence)",", props);
    }

    private static boolean defaultIgnoreProp(IDataEntityProperty fieldProp) {
        return fieldProp instanceof GeoPointProp || fieldProp.getParent() instanceof EntryType || fieldProp instanceof INoCodeRichTextProp || fieldProp instanceof NameVersionEntryProp || fieldProp instanceof INoCodeGraphicDisplayProp || fieldProp instanceof EntryProp || fieldProp instanceof AttachmentProp || fieldProp instanceof PictureProp;
    }

    private void setDataByFields(String[] fields, Map<String, Object> dynamicObjectMap, Object[] arr) {
        int fieldIndex = 0;
        for (String fld : fields) {
            String value = dynamicObjectMap.get(fld) == null ? "" : String.valueOf(dynamicObjectMap.get(fld));
            arr[fieldIndex] = value;
            ++fieldIndex;
        }
    }

    protected void lookUpListInvoke(Map<String, Object> data) {
        if (this.getProperty().getParent() instanceof EntryType) {
            int rowIndex = this.getCurrentRowIndex();
            data.put("r", rowIndex);
            String ctlKey = StringUtils.isBlank((CharSequence)this.getEntryControlKey()) ? this.getEntryKey() : this.getEntryControlKey();
            this.clientViewProxy.invokeControlMethod(ctlKey, "setLookUpListValue", new Object[]{data});
        } else {
            data.put("r", 0);
            this.clientViewProxy.invokeControlMethod(this.key, "setLookUpListValue", new Object[]{data});
        }
    }

    public void setItemByIdFromClient(List<Object> args) {
        int index = this.getCurrentRowIndex();
        if (args != null && StringUtils.isNotBlank((Object)args.get(0))) {
            Object pk = args.get(0);
            String value = pk instanceof ArrayList ? String.join((CharSequence)",", (ArrayList)pk) : (pk instanceof String ? (String)pk : (pk instanceof String && StringUtils.isBlank((Object)pk) ? null : null));
            if (this.checkDataRange(value)) {
                this.getModel().setValue(this.getProperty().getName(), (Object)value, index);
            }
            if (StringUtils.isNotBlank((Object)args.get(0))) {
                this.addNewLineIfKeyField(1, this.getCurrentRowIndex());
            }
        } else {
            this.getModel().setValue(this.getProperty().getName(), null, index);
        }
        this.getView().setReturnData(args);
    }

    private boolean checkDataRange(String value) {
        IDataEntityProperty property;
        int valueCount = 0;
        if (StringUtils.isNotBlank((CharSequence)value)) {
            valueCount = value.split(",").length;
        }
        if ((property = this.getProperty()) instanceof NoCodeRefBillProp) {
            return true;
        }
        NoCodeMulRefBillProp refProp = (NoCodeMulRefBillProp)property;
        if (refProp.getMulti() == 0) {
            return true;
        }
        NoCodeDataRangeField dataRange = refProp.getDataRange();
        int iMax = Integer.parseInt(dataRange.getMax());
        int iMin = Integer.parseInt(dataRange.getMin());
        if (valueCount > iMax || valueCount < iMin) {
            String sError = ResManager.loadKDString((String)"\u201c%1$s\u201d\u9009\u62e9\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e%2$s\uff0c\u4e0d\u80fd\u5927\u4e8e%3$s", (String)"NoCodeMulRefBillEdit_1", (String)BOS_NOCODE_EXT, (Object[])new Object[]{this.getProperty().getDisplayName().getLocaleValue(), dataRange.getMin(), dataRange.getMax()});
            this.getView().showErrorNotification(sError);
            Object selectedData = this.getSelectedData();
            this.clientViewProxy.invokeControlMethod(this.key, RESET_VALUE, new Object[]{selectedData});
            return false;
        }
        return true;
    }

    public BillEntityType getMainEntityType() {
        String formNumber = this.getBillEntityNumber();
        if (StringUtils.isBlank((CharSequence)formNumber) || !NcEntityTypeUtil.isFormExist((String)formNumber)) {
            return null;
        }
        return (BillEntityType)EntityMetadataCache.getDataEntityType((String)formNumber);
    }

    protected String getBillEntityId() {
        return ((INoCodeRefBillProp)this.getProperty()).getBillEntityId();
    }

    protected String getBillEntityNumber() {
        return ((INoCodeRefBillProp)this.getProperty()).getBillEntityNumber();
    }

    public void getListQuery(List<Object> args) {
        Map<String, Object> result = this.getTableData(args);
        if (!result.isEmpty()) {
            this.invokeSetListQuery(result);
        }
    }

    public Map<String, Object> getTableData(List<Object> args) {
        Map map;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String appId = formShowParameter.getAppId();
        String formId = formShowParameter.getFormId();
        String targetFormId = this.getBillEntityNumber();
        String shareId = this.getView().getParentView().getPageCache().get("noCodeShareId");
        boolean share = NoCodePermHelper.isShare((String)appId, (String)formId, (String)shareId);
        if (!share && FormMetadataUtils.isNoCodeBill(targetFormId) && !NoCodePermHelper.checkFuncPerm((FuncPermItemEnum)FuncPermItemEnum.view, (String)targetFormId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u8868\u5355\u6743\u9650", (String)"NoCodeMulRefBillEdit_2", (String)BOS_NOCODE_EXT, (Object[])new Object[0]));
            return Collections.emptyMap();
        }
        if (share && !NoCodePermHelper.checkPublishEnt((String)appId, (String)targetFormId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u8868\u5355\u6743\u9650", (String)"NoCodeMulRefBillEdit_2", (String)BOS_NOCODE_EXT, (Object[])new Object[0]));
            return Collections.emptyMap();
        }
        if (StringUtils.isEmpty((CharSequence)targetFormId)) {
            return Collections.emptyMap();
        }
        int pageSize = args.get(0) == null ? 20 : Integer.parseInt(args.get(0).toString());
        int pageNo = args.get(0) == null ? 1 : Integer.parseInt(args.get(1).toString());
        String keyword = args.get(2) == null ? "" : args.get(2).toString();
        String filter = "";
        String defaultFilter = this.parseFilterString(appId, targetFormId, this.getDefaultFilterRows());
        if (args.get(3) != null) {
            filter = args.get(3) instanceof String ? args.get(3).toString() : (args.get(3) instanceof List ? this.parseFilterString(appId, targetFormId, (List)args.get(3)) : "");
        }
        if (StringUtils.isNotBlank((CharSequence)defaultFilter)) {
            filter = StringUtils.isNotBlank((CharSequence)filter) ? filter + " and ( " + defaultFilter + " )" : defaultFilter;
        }
        String pksFilter = this.appendPksFilter(args);
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            if (StringUtils.isNotBlank((CharSequence)pksFilter)) {
                filter = filter + " and ( " + pksFilter + " )";
            }
        } else {
            filter = pksFilter;
        }
        String orderBy = Objects.isNull(args.get(4)) ? "" : args.get(4).toString();
        String queryStr = String.format("?page_size=%s&page_no=%s&order_by=%s", pageSize, pageNo, orderBy);
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            queryStr = queryStr + "&search=" + keyword;
        }
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            queryStr = queryStr + "&filter=" + filter;
        }
        HashMap reqData = new HashMap(10);
        reqData.put("data", new HashMap(10));
        String rootUrl = UrlService.getDomainContextUrl();
        String apiUrl = String.format("nocode/v2/%s/%s/%s", appId, targetFormId, queryStr);
        String fullRequestUrl = String.format("%s%s", rootUrl, apiUrl);
        HashMap<String, String> queryStringMap = new HashMap<String, String>(0);
        queryStringMap.put("search", keyword);
        queryStringMap.put(FROM_REF_BILL, "true");
        queryStringMap.put("showType", "list");
        if (args.size() >= 6 && (map = (Map)args.get(5)).get("showType") != null && "list".equals(map.get("showType").toString())) {
            queryStringMap.put("displayProperty", this.getDisplayProperty());
        }
        HashMap reqHeaders = new HashMap(16);
        RestApiRequest request = new RestApiRequest(fullRequestUrl, apiUrl, queryStringMap, OperationType.QUERY, HttpMethod.GET, ApiVersion.TWO, appId, targetFormId, reqData, reqHeaders, filter);
        RestApiQueryParam param = new RestApiQueryParam(request);
        param.setFormId(targetFormId);
        param.setAppNumber(appId);
        param.setPage_size(pageSize);
        param.setPage_no(pageNo);
        param.setOrder_by(orderBy);
        param.setShareId(shareId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        RestApiQueryResult data = (RestApiQueryResult)this.invokeRestApiQuery(param).getResponse().getData();
        if (data != null) {
            if (!data.getRows().isEmpty()) {
                this.fixupRowTitle(data, false);
                this.fixRowState(data);
            }
            data.setPageNo(pageNo);
            data.setPageSize(pageSize);
            result.put("data", JsonUtil.parseJson2Map((String)JsonUtil.format((Object)data)));
        }
        result.put("k", this.key);
        result.put(ARGS, args);
        return result;
    }

    public void getSelectedDisp(List<Object> args) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String appId = formShowParameter.getAppId();
        String formId = formShowParameter.getFormId();
        String targetFormId = this.getBillEntityNumber();
        String shareId = this.getView().getParentView().getPageCache().get("noCodeShareId");
        boolean share = NoCodePermHelper.isShare((String)appId, (String)formId, (String)shareId);
        if (!share && FormMetadataUtils.isNoCodeBill(targetFormId) && !NoCodePermHelper.checkFuncPerm((FuncPermItemEnum)FuncPermItemEnum.view, (String)targetFormId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u8868\u5355\u6743\u9650", (String)"NoCodeMulRefBillEdit_2", (String)BOS_NOCODE_EXT, (Object[])new Object[0]));
            return;
        }
        if (share && !NoCodePermHelper.checkPublishEnt((String)appId, (String)targetFormId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u8868\u5355\u6743\u9650", (String)"NoCodeMulRefBillEdit_2", (String)BOS_NOCODE_EXT, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)targetFormId)) {
            int pageSize = args.get(0) == null ? 20 : Integer.parseInt(args.get(0).toString());
            int pageNo = args.get(0) == null ? 1 : Integer.parseInt(args.get(1).toString());
            String filter = args.get(2) == null ? "" : args.get(2).toString();
            String queryStr = String.format("?page_size=%s&page_no=%s", pageSize, pageNo);
            if (StringUtils.isNotBlank((CharSequence)filter)) {
                queryStr = queryStr + "&filter=" + filter;
            }
            HashMap reqData = new HashMap(10);
            reqData.put("data", new HashMap(10));
            String rootUrl = UrlService.getDomainContextUrl();
            String apiUrl = String.format("nocode/v2/%s/%s/%s", appId, targetFormId, queryStr);
            String fullRequestUrl = String.format("%s%s", rootUrl, apiUrl);
            HashMap<String, String> queryStringMap = new HashMap<String, String>(0);
            queryStringMap.put(FROM_REF_BILL, "true");
            queryStringMap.put("showType", "list");
            HashMap reqHeaders = new HashMap(16);
            RestApiRequest request = new RestApiRequest(fullRequestUrl, apiUrl, queryStringMap, OperationType.QUERY, HttpMethod.GET, ApiVersion.TWO, appId, targetFormId, reqData, reqHeaders, filter);
            RestApiQueryParam param = new RestApiQueryParam(request);
            param.setFormId(targetFormId);
            param.setAppNumber(appId);
            param.setPage_size(pageSize);
            param.setPage_no(pageNo);
            param.setShareId(shareId);
            HashMap<String, Object> result = new HashMap<String, Object>();
            RestApiQueryResult data = (RestApiQueryResult)this.invokeRestApiQuery(param).getResponse().getData();
            if (data != null) {
                if (!data.getRows().isEmpty()) {
                    this.fixupRowTitle(data, true);
                }
                data.setPageNo(pageNo);
                data.setPageSize(pageSize);
                result.put("data", JsonUtil.parseJson2Map((String)JsonUtil.format((Object)data)));
            }
            result.put("k", this.key);
            result.put(ARGS, args);
            this.invokeSetSelectedDisp(result);
        }
    }

    private List<Map<String, Object>> showUserInfo(Object pkValue) {
        if (pkValue == null) {
            return null;
        }
        String filter = "id EQ " + pkValue;
        RestApiQueryResult data = this.queryUser(filter);
        return data.getRows();
    }

    private List<Map<String, Object>> showOrgInfo(Object pkValue) {
        if (pkValue == null) {
            return null;
        }
        Map map = OrgUnitServiceHelper.getOrgProperty((long)Long.parseLong(pkValue.toString()), Arrays.asList("number", "name"));
        Map directSuperiorOrg = OrgUnitServiceHelper.getDirectSuperiorOrg((String)"01", Collections.singletonList(Long.parseLong(pkValue.toString())));
        Long parentId = (Long)directSuperiorOrg.get(Long.parseLong(pkValue.toString()));
        if (Objects.isNull(parentId) || parentId == 0L) {
            map.put("parentid", "");
            map.put("parentname", "");
        } else {
            Map parentProperties = OrgUnitServiceHelper.getOrgProperty((long)parentId, (List)Lists.newArrayList((Object[])new String[]{"name"}));
            String name = "";
            name = MapUtils.isEmpty((Map)parentProperties) ? "" : ((ILocaleString)parentProperties.get("name")).getLocaleValue();
            map.put("parentid", parentId.toString());
            map.put("parentname", name);
        }
        if (map.get("name") != null) {
            map.put("name", ((ILocaleString)map.get("name")).getLocaleValue());
        }
        map.put("id", map.get("id").toString());
        String filter = "entryentity.dpt.number EQ " + map.get("number");
        RestApiQueryResult data = this.queryUser(filter);
        map.put("users", data);
        return Collections.singletonList(map);
    }

    private RestApiQueryResult queryUser(String filter) {
        String rootUrl = UrlService.getDomainContextUrl();
        String apiUrl = "nocode/v2/nocode_sys/common/user";
        String fullRequestUrl = String.format("%s%s", rootUrl, apiUrl);
        HashMap queryStringMap = new HashMap(0);
        fullRequestUrl = fullRequestUrl + "&filter=" + filter;
        HashMap reqData = new HashMap(10);
        reqData.put("data", new HashMap(10));
        HashMap reqHeaders = new HashMap(16);
        RestApiRequest request = new RestApiRequest(fullRequestUrl, apiUrl, queryStringMap, OperationType.QUERY, HttpMethod.GET, ApiVersion.TWO, "", "common", reqData, reqHeaders, filter);
        RestApiQueryParam param = new RestApiQueryParam(request);
        param.setFormId("common");
        param.setAppNumber("nocode_sys");
        return (RestApiQueryResult)this.invokeRestApiQuery(param).getResponse().getData();
    }

    public void showInfo(List<Object> args) {
        List<Map<String, Object>> list = this.getInfo(args);
        if (list == null) {
            return;
        }
        String target = NcEntityTypeUtil.getRealBillEntityNumber((String)this.getBillEntityId());
        if ("bos_user".equals(target)) {
            this.invokeUserInfo(list);
        } else if ("bos_adminorg".equals(target)) {
            this.invokeOrgInfo(list);
        }
    }

    private void invokeUserInfo(List<Map<String, Object>> list) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.addAction("InvokeControlMethod", (Object)Maps.of((Object)"key", (Object)this.key, (Object)"methodname", (Object)"showUserInfo", (Object)ARGS, list));
    }

    private void invokeOrgInfo(List<Map<String, Object>> list) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.addAction("InvokeControlMethod", (Object)Maps.of((Object)"key", (Object)this.key, (Object)"methodname", (Object)"showOrgInfo", (Object)ARGS, list));
    }

    public List<Map<String, Object>> getInfo(List<Object> args) {
        boolean check;
        Object pkId = args.get(0);
        if (pkId == null) {
            return null;
        }
        String target = NcEntityTypeUtil.getRealBillEntityNumber((String)this.getBillEntityId());
        boolean share = NoCodePermHelper.isShare(null, null, (String)this.getView().getParentView().getPageCache().get("noCodeShareId"));
        if ("bos_user".equals(target)) {
            if (!share) {
                return this.showUserInfo(pkId);
            }
        } else if ("bos_adminorg".equals(target) && !share) {
            return this.showOrgInfo(pkId);
        }
        if (!NcEntityTypeUtil.isNoCodeBill((String)target)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u8868\u5355\u6682\u4e0d\u652f\u6301\u67e5\u770b\u8be6\u60c5", (String)"NoCodeMulRefBillEdit_3", (String)BOS_NOCODE_EXT, (Object[])new Object[0]));
            return null;
        }
        if (NcEntityTypeUtil.isSoftDeleted((String)target)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"%s \u5173\u8054\u8868\u5355\u53ef\u80fd\u5df2\u5220\u9664\uff0c\u4e0d\u652f\u6301\u67e5\u770b\u8be6\u60c5", (String)"NoCodeMulRefBillEdit_4", (String)BOS_NOCODE_EXT, (Object[])new Object[]{this.getProperty().getDisplayName().getLocaleValue()}));
            return null;
        }
        boolean bl = check = NoCodePermHelper.checkFuncPermInNoCode((FuncPermItemEnum)FuncPermItemEnum.view, (String)target) && NoCodePermHelper.checkDataPermInNoCode((String)target, (Object)pkId);
        if (!check) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6743\u9650\u4e0d\u8db3", (String)"NoCodeMulRefBillEdit_5", (String)BOS_NOCODE_EXT, (Object[])new Object[0]));
            return null;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_nocode_bill_nested2");
        String appId = this.getModel().getDataEntityType().getAppId();
        parameter.setCustomParam("ServiceAppId", (Object)("bos." + appId));
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setParentPageId(this.getView().getPageId());
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("targetFormId", (Object)target);
        parameter.setCustomParam("pkId", (Object)pkId.toString());
        parameter.setCustomParam("nested", (Object)true);
        if (share) {
            parameter.setCustomParam("skip", (Object)true);
            parameter.setCustomParam("share", (Object)true);
        }
        parameter.setCustomParam("nestedType", (Object)"showInfo");
        parameter.setCustomParam("Status", (Object)OperationStatus.VIEW);
        parameter.setCaption(ResManager.loadKDString((String)"\u8be6\u60c5", (String)"NoCodeMulRefBillEdit_6", (String)BOS_NOCODE_EXT, (Object[])new Object[0]));
        this.getView().showForm(parameter);
        return null;
    }

    public void addNewRef(List<Object> args) {
        String billEntityId = this.getBillEntityId();
        if (StringUtils.isEmpty((CharSequence)billEntityId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5b57\u6bb5\u5173\u8054\u8868\u5355\u5c5e\u6027\u5df2\u88ab\u6e05\u7a7a\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e", (String)"NoCodeMulRefBillEdit_7", (String)BOS_NOCODE_EXT, (Object[])new Object[0]));
            return;
        }
        if (!NcEntityTypeUtil.isFormExist((String)billEntityId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664", (String)"NoCodeMulRefBillEdit_8", (String)BOS_NOCODE_EXT, (Object[])new Object[0]));
            return;
        }
        String target = NcEntityTypeUtil.getRealBillEntityNumber((String)billEntityId);
        if (NcEntityTypeUtil.isNoCodeBill((String)target)) {
            boolean check;
            String callbackProps = "";
            String callbackKey = "";
            if (args != null && args.size() > 0) {
                callbackProps = args.get(0).toString();
                callbackKey = args.size() > 1 ? args.get(1).toString() : this.key;
            }
            if (!(check = NoCodePermHelper.checkFuncPermInNoCode((FuncPermItemEnum)FuncPermItemEnum.input, (String)target))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6743\u9650\u4e0d\u8db3", (String)"NoCodeMulRefBillEdit_5", (String)BOS_NOCODE_EXT, (Object[])new Object[0]));
                return;
            }
            boolean share = NoCodePermHelper.isShare(null, null, (String)this.getView().getParentView().getPageCache().get("noCodeShareId"));
            if (share) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u4eab\u65f6\u4e0d\u53ef\u65b0\u589e", (String)"NoCodeMulRefBillEdit_9", (String)BOS_NOCODE_EXT, (Object[])new Object[0]));
                return;
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bos_nocode_bill_nested2");
            String appId = this.getModel().getDataEntityType().getAppId();
            parameter.setCustomParam("ServiceAppId", (Object)("bos." + appId));
            parameter.setStatus(OperationStatus.ADDNEW);
            parameter.setParentPageId(this.getView().getPageId());
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("isAddRef", (Object)true);
            parameter.setCustomParam("targetFormId", (Object)target);
            parameter.setCustomParam("saveCallbackProps", (Object)callbackProps);
            parameter.setCustomParam("controlKey", (Object)callbackKey);
            parameter.setCustomParam("nested", (Object)true);
            parameter.setCustomParam("nestedType", (Object)"addRef");
            parameter.setCustomParam("Status", (Object)OperationStatus.ADDNEW);
            parameter.setCaption(ResManager.loadKDString((String)"\u5f55\u5165", (String)"NoCodeMulRefBillEdit_10", (String)BOS_NOCODE_EXT, (Object[])new Object[0]));
            this.getView().showForm(parameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8868\u5355\u6682\u65f6\u65e0\u6cd5\u65b0\u589e", (String)"NoCodeMulRefBillEdit_11", (String)BOS_NOCODE_EXT, (Object[])new Object[0]));
        }
    }

    public void editInfo(List<Object> args) {
        String callbackProps = "";
        String callbackKey = "";
        Object pkId = null;
        if (args != null && args.size() > 1) {
            pkId = args.get(0);
            callbackProps = args.get(1).toString();
            callbackKey = args.size() > 2 ? args.get(2).toString() : this.key;
        }
        if (pkId == null) {
            return;
        }
        String target = NcEntityTypeUtil.getRealBillEntityNumber((String)this.getBillEntityId());
        if (!NcEntityTypeUtil.isNoCodeBill((String)target)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u8868\u5355\u6682\u4e0d\u652f\u6301\u7f16\u8f91", (String)"NoCodeMulRefBillEdit_12", (String)BOS_NOCODE_EXT, (Object[])new Object[0]));
            return;
        }
        boolean check = NoCodePermHelper.checkFuncPermInNoCode((FuncPermItemEnum)FuncPermItemEnum.edit, (String)target);
        if (!check) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6743\u9650\u4e0d\u8db3", (String)"NoCodeMulRefBillEdit_5", (String)BOS_NOCODE_EXT, (Object[])new Object[0]));
            return;
        }
        boolean share = NoCodePermHelper.isShare(null, null, (String)this.getView().getParentView().getPageCache().get("noCodeShareId"));
        if (share) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u4eab\u65f6\u4e0d\u53ef\u7f16\u8f91", (String)"NoCodeMulRefBillEdit_13", (String)BOS_NOCODE_EXT, (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_nocode_bill_nested2");
        String appId = this.getModel().getDataEntityType().getAppId();
        parameter.setCustomParam("ServiceAppId", (Object)("bos." + appId));
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setParentPageId(this.getView().getPageId());
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("targetFormId", (Object)target);
        parameter.setCustomParam("pkId", (Object)pkId.toString());
        parameter.setCustomParam("nested", (Object)true);
        parameter.setCustomParam("nestedType", (Object)"editF7");
        parameter.setCustomParam("Status", (Object)OperationStatus.EDIT);
        parameter.setCustomParam("saveCallbackProps", (Object)callbackProps);
        parameter.setCustomParam("controlKey", (Object)callbackKey);
        parameter.setCaption(ResManager.loadKDString((String)"\u7f16\u8f91", (String)"NoCodeMulRefBillEdit_14", (String)BOS_NOCODE_EXT, (Object[])new Object[0]));
        this.getView().showForm(parameter);
    }

    private String appendPksFilter(List<Object> args) {
        Object obj;
        Map map;
        if (args.size() >= 6 && (map = (Map)args.get(5)).get("showType") != null && "list".equals(map.get("showType").toString()) && (obj = map.get("pks")) != null) {
            List pks = (List)map.get("pks");
            StringBuilder pksFilter = new StringBuilder();
            for (Object o : pks) {
                pksFilter.append(o).append(",");
            }
            if (StringUtils.isNotBlank((CharSequence)pksFilter.toString())) {
                pksFilter = new StringBuilder(pksFilter.substring(0, pksFilter.length() - 1));
                return "ID IN (" + pksFilter + ")";
            }
            return "ID EQ -1";
        }
        return null;
    }

    private List<Object> parsePks(RestApiQueryResult data, BillEntityType dt) {
        ArrayList<Object> pks = new ArrayList<Object>(10);
        String pkName = dt.getPrimaryKey().getName();
        for (Map row : data.getRows()) {
            pks.add(row.get(pkName));
        }
        return pks;
    }

    private void fixRowState(RestApiQueryResult data) {
        Tuple tuple = AssociationServiceHelper.existAssociation((String)this.getView().getEntityId(), (String)this.getKey());
        if (!((Boolean)tuple.item1).booleanValue()) {
            return;
        }
        String associationKey = (String)tuple.item2;
        BillEntityType dt = this.getMainEntityType();
        for (Map row : data.getRows()) {
            String[] segs;
            DynamicProperty property = dt.getProperty(associationKey);
            if (property instanceof NoCodeRefBillProp) {
                if (row.get(associationKey) == null) continue;
                row.put("_state_", "disabled");
                continue;
            }
            if (!(property instanceof NoCodeMulRefBillProp)) continue;
            NoCodeMulRefBillProp prop = (NoCodeMulRefBillProp)property;
            int max = Integer.parseInt(prop.getDataRange().getMax());
            String value = row.get(associationKey) == null ? null : row.get(associationKey).toString();
            if (StringUtils.isBlank((CharSequence)value) || value == null || (segs = value.split(",")).length < max) continue;
            row.put("_state_", "disabled");
        }
    }

    private void fixupRowTitle(RestApiQueryResult data, boolean onlyTitle) {
        BillEntityType dt = this.getMainEntityType();
        List<Object> pks = this.parsePks(data, dt);
        String pkName = dt.getPrimaryKey().getName();
        QFilter[] filters = new QFilter[]{new QFilter(dt.getPrimaryKey().getName(), "in", pks)};
        List<Map<String, Object>> lookupData = this.queryData(this.getMainEntityType(), filters, null, pks.size(), null);
        String[] fields = this.getSelectFields().split(",");
        for (Map row : data.getRows()) {
            Long pkValue = (Long)row.get(pkName);
            Optional<Map> first = lookupData.stream().filter(d -> Long.parseLong(d.get(pkName).toString()) == pkValue).findFirst();
            if (!first.isPresent()) continue;
            StringBuilder sb = new StringBuilder();
            Map stringObjectMap = first.get();
            for (String field : fields) {
                Object o;
                if (field.equalsIgnoreCase(pkName) || !stringObjectMap.containsKey(field) || stringObjectMap.get(field) == null || StringUtils.isBlank((CharSequence)stringObjectMap.get(field).toString())) continue;
                if (field.equalsIgnoreCase(pkName) && onlyTitle) {
                    o = stringObjectMap.get(field);
                    if (sb.length() > 0) {
                        sb.append("|");
                    }
                    sb.append(o.toString());
                    break;
                }
                o = stringObjectMap.get(field);
                if (sb.length() > 0) {
                    sb.append("|");
                }
                sb.append(o.toString());
            }
            if (onlyTitle) {
                row.keySet().removeIf(k -> !pkName.equalsIgnoreCase((String)k));
            }
            row.put("_title_", sb.toString());
        }
    }

    protected void invokeSetListQuery(Map<String, Object> data) {
        if (this.getProperty().getParent() instanceof EntryType) {
            int rowIndex = this.getCurrentRowIndex();
            data.put("r", rowIndex);
            String ctlKey = StringUtils.isBlank((CharSequence)this.getEntryControlKey()) ? this.getEntryKey() : this.getEntryControlKey();
            this.clientViewProxy.invokeControlMethod(ctlKey, SET_LIST_QUERY, new Object[]{data});
        } else {
            data.put("r", 0);
            this.clientViewProxy.invokeControlMethod(this.key, SET_LIST_QUERY, new Object[]{data});
        }
    }

    protected void invokeSetSelectedDisp(Map<String, Object> data) {
        if (this.getProperty().getParent() instanceof EntryType) {
            int rowIndex = this.getCurrentRowIndex();
            data.put("r", rowIndex);
            String ctlKey = StringUtils.isBlank((CharSequence)this.getEntryControlKey()) ? this.getEntryKey() : this.getEntryControlKey();
            this.clientViewProxy.invokeControlMethod(ctlKey, SET_SELECTED_DISP, new Object[]{data});
        } else {
            data.put("r", 0);
            this.clientViewProxy.invokeControlMethod(this.key, SET_SELECTED_DISP, new Object[]{data});
        }
    }

    protected int getCurrentRowIndex() {
        int rowIndex = -1;
        if (this.isEntryProperty(this.getProperty())) {
            rowIndex = this.getModel().getEntryCurrentRowIndex(this.getProperty().getParent().getName());
        }
        return rowIndex;
    }

    protected boolean isEntryProperty(IDataEntityProperty property) {
        IDataEntityType propParentType = property.getParent();
        return propParentType instanceof EntryType;
    }

    private RestApiServiceData<RestApiQueryResult> invokeRestApiQuery(RestApiQueryParam param) {
        String shareId = this.getView().getParentView().getPageCache().get("noCodeShareId");
        param.setShareId(shareId);
        try {
            RestApiServiceData queryResult = (RestApiServiceData)DispatchApiServiceHelper.invokeApiService((String)QueryRestApiService.class.getSimpleName(), (Object[])new Object[]{param});
            if (param.isDyObjResult()) {
                return queryResult;
            }
            try {
                ((RestApiQueryResult)queryResult.getResponse().getData()).setRows(((RestApiQueryResult)queryResult.getResponse().getData()).getRows());
            }
            catch (Exception e) {
                logger.debug("set rows failed", (Object)e);
            }
            return queryResult;
        }
        catch (Exception ex) {
            logger.warn((Throwable)ex);
            this.getView().showErrorNotification(ex.getMessage());
            RestApiResponse response = new RestApiResponse();
            return RestApiServiceData.ofFalse((RestApiResponse)response, (long)0L);
        }
    }

    private RestApiServiceData<RestApiQueryResult> invokeRestApiPost(RestApiSaveParam param) {
        try {
            return (RestApiServiceData)DispatchApiServiceHelper.invokeApiService((String)SaveRestApiService.class.getSimpleName(), (Object[])new Object[]{param});
        }
        catch (Exception ex) {
            if (StringUtils.isNotBlank((CharSequence)ex.getMessage())) {
                this.getView().showErrorNotification(ex.getMessage());
            }
            logger.warn((Throwable)ex);
            return null;
        }
    }

    public void listConfig(List<Object> args) {
        if (CollectionUtils.isEmpty(args)) {
            throw new RestApiException(ResManager.loadKDString((String)"\u53c2\u6570\u5f02\u5e38", (String)"NoCodeMulRefBillEdit_15", (String)BOS_NOCODE_EXT, (Object[])new Object[0]));
        }
        String formId = (String)args.get(0);
        if (NcEntityTypeUtil.isFormExist((String)formId)) {
            try {
                Map result = (Map)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.nocode.servicehelper", (String)"nocode_sys", (String)RestApiWrap.class.getSimpleName(), (String)LIST_CONFIG, (Object[])new Object[]{formId, new HashMap()});
                result.put(ARGS, args);
                this.clientViewProxy.invokeControlMethod(this.key, LIST_CONFIG, new Object[]{result});
            }
            catch (Exception ex) {
                if (StringUtils.isNotBlank((CharSequence)ex.getMessage())) {
                    this.getView().showErrorNotification(ex.getMessage());
                }
                logger.warn((Throwable)ex);
            }
        }
    }

    public void query(List<Object> args) {
        if (CollectionUtils.isEmpty(args)) {
            throw new RestApiException(ResManager.loadKDString((String)"\u53c2\u6570\u5f02\u5e38", (String)"NoCodeMulRefBillEdit_15", (String)BOS_NOCODE_EXT, (Object[])new Object[0]));
        }
        String formId = (String)args.get(0);
        Map param = (Map)args.get(1);
        try {
            Map result = (Map)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.nocode.servicehelper", (String)"nocode_sys", (String)RestApiWrap.class.getSimpleName(), (String)"query", (Object[])new Object[]{formId, param});
            result.put(ARGS, args);
            this.clientViewProxy.invokeControlMethod(this.key, SET_QUERY, new Object[]{result});
        }
        catch (Exception ex) {
            if (StringUtils.isNotBlank((CharSequence)ex.getMessage())) {
                this.getView().showErrorNotification(ex.getMessage());
            }
            logger.warn((Throwable)ex);
        }
    }

    public void getListConfig(List<Object> args) {
        Map<String, Object> result = this.getTableConfig(args);
        if (!result.isEmpty()) {
            this.invokeSetListConfig(result);
        }
    }

    public Map<String, Object> getTableConfig(List<Object> args) {
        Map map;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String appId = formShowParameter.getAppId();
        String targetFormId = this.getBillEntityNumber();
        if (!NcEntityTypeUtil.isFormExist((String)targetFormId)) {
            return Collections.emptyMap();
        }
        String queryStr = String.format("?appId=%s&formId=%s", appId, targetFormId);
        HashMap reqData = new HashMap(10);
        reqData.put("data", new HashMap(10));
        String rootUrl = UrlService.getDomainContextUrl();
        String apiUrl = String.format("/nocode/v2/nocode_sys/common/list_config/common/query%s", queryStr);
        String fullRequestUrl = String.format("%s%s", rootUrl, apiUrl);
        HashMap<String, String> queryStringMap = new HashMap<String, String>(0);
        queryStringMap.put("appId", appId);
        queryStringMap.put("formId", targetFormId);
        queryStringMap.put(FROM_REF_BILL, "true");
        boolean share = NoCodePermHelper.isShare((String)appId, (String)targetFormId, (String)this.getView().getParentView().getPageCache().get("noCodeShareId"));
        queryStringMap.put("share", String.valueOf(share));
        if (!args.isEmpty() && (map = (Map)args.get(0)).get("showType") != null && "list".equals(map.get("showType").toString())) {
            queryStringMap.put("displayProperty", this.getDisplayProperty());
        }
        HashMap reqHeaders = new HashMap(16);
        RestApiRequest request = new RestApiRequest(fullRequestUrl, apiUrl, queryStringMap, OperationType.QUERY, HttpMethod.GET, ApiVersion.TWO, appId, SysServiceFormId.COMMON.getName(), reqData, reqHeaders, "");
        RestApiQueryParam param = new RestApiQueryParam(request);
        param.setFormId(SysServiceFormId.COMMON.getName());
        param.setAppNumber(appId);
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        RestApiServiceData<RestApiQueryResult> data = null;
        try {
            data = this.invokeRestApiQuery(param);
        }
        catch (Exception e) {
            logger.debug("\u67e5\u8be2\u5217\u8868\u914d\u7f6e\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            this.getView().showErrorNotification(e.getMessage());
            return Collections.emptyMap();
        }
        result.put("data", data.getResponse().getData());
        Object selectedData = this.getSelectedData();
        if (selectedData != null) {
            result.put("selected", selectedData);
        }
        if (BlackFormUtil.isCosmicForm((String)this.getBillEntityId())) {
            result.put("permission", "false");
        }
        result.put("k", this.key);
        result.put(ARGS, args);
        return result;
    }

    protected void invokeSetListConfig(Map<String, Object> data) {
        if (this.getProperty().getParent() instanceof EntryType) {
            int rowIndex = this.getCurrentRowIndex();
            data.put("r", rowIndex);
            String ctlKey = StringUtils.isBlank((CharSequence)this.getEntryControlKey()) ? this.getEntryKey() : this.getEntryControlKey();
            this.clientViewProxy.invokeControlMethod(ctlKey, SET_LIST_CONFIG, new Object[]{data});
        } else {
            data.put("r", 0);
            this.clientViewProxy.invokeControlMethod(this.key, SET_LIST_CONFIG, new Object[]{data});
        }
    }

    private Object getSelectedData() {
        IDataEntityProperty property = this.getProperty();
        if (property instanceof NoCodeMulRefBillProp) {
            NoCodeMulRefBillProp prop = (NoCodeMulRefBillProp)property;
            String currValue = (String)this.getModel().getValue(this.getProperty().getName(), this.getCurrentRowIndex());
            return prop.getBindingRefBillValue(currValue);
        }
        NoCodeRefBillProp prop = (NoCodeRefBillProp)property;
        Object currValue = this.getModel().getValue(this.getProperty().getName(), this.getCurrentRowIndex());
        return prop.getBindingRefBillValue(currValue, prop.getMainDisplayProperty());
    }

    public void getFilterItemLook(List<Object> args) {
        String fieldKey = (String)args.get(0);
        ArrayList filterRows = (ArrayList)args.get(1);
        String targetFormId = this.getBillEntityNumber();
        if (StringUtils.isBlank((CharSequence)fieldKey)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f3a\u5c11FieldKey\u4f20\u53c2", (String)"NoCodeMulRefBillEdit_16", (String)BOS_NOCODE_EXT, (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty((Collection)filterRows)) {
            filterRows = new ArrayList(0);
        }
        try {
            HashMap<String, Object> filterParam = new HashMap<String, Object>(3);
            filterParam.put("getEnumData", "true");
            filterParam.put("enumField", fieldKey);
            filterParam.put("filterrows", filterRows);
            filterParam.put("defaultFilterRows", this.getDefaultFilterRows());
            Map result = (Map)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.nocode.servicehelper", (String)"nocode_sys", (String)RestApiWrap.class.getSimpleName(), (String)"getFilterItemLook", (Object[])new Object[]{targetFormId, filterParam});
            result.put("k", this.key);
            result.put(ARGS, args);
            this.invokeSetFilterItemLook(result);
        }
        catch (Exception ex) {
            if (StringUtils.isNotBlank((CharSequence)ex.getMessage())) {
                this.getView().showErrorNotification(ex.getMessage());
            }
            logger.warn((Throwable)ex);
        }
    }

    protected void invokeSetFilterItemLook(Map<String, Object> data) {
        if (this.getProperty().getParent() instanceof EntryType) {
            int rowIndex = this.getCurrentRowIndex();
            data.put("r", rowIndex);
            String ctlKey = StringUtils.isBlank((CharSequence)this.getEntryControlKey()) ? this.getEntryKey() : this.getEntryControlKey();
            this.clientViewProxy.invokeControlMethod(ctlKey, SET_FILTER_ITEM_LOOK, new Object[]{data});
        } else {
            data.put("r", 0);
            this.clientViewProxy.invokeControlMethod(this.key, SET_FILTER_ITEM_LOOK, new Object[]{data});
        }
    }

    public void getEntryData(List<Object> args) {
        String billEntityNumber = this.getBillEntityNumber();
        String appId = FormMetaUtil.getAppIdByFormNumber((String)billEntityNumber);
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("pkId", args.get(0));
            params.put("pageNo", args.get(1));
            params.put("pageSize", args.get(2));
            params.put("entry", args.get(3));
            params.put("appId", appId);
            params.put("formId", billEntityNumber);
            Map result = (Map)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.nocode.servicehelper", (String)"nocode_sys", (String)RestApiWrap.class.getSimpleName(), (String)"getEntryData", (Object[])new Object[]{params});
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.invokeControlMethod(this.key, SET_ENTRY_DATA, new Object[]{result});
        }
        catch (Exception ex) {
            if (StringUtils.isNotBlank((CharSequence)ex.getMessage())) {
                this.getView().showErrorNotification(ex.getMessage());
            }
            logger.warn((Throwable)ex);
        }
    }

    public void getHeadFieldFilterItem(List<Object> args) {
        Map<String, Object> result = this.getTableFilterItem(args);
        if (!result.isEmpty()) {
            this.invokeSetHeadFieldFilterItem(result);
        }
    }

    public Map<String, Object> getTableFilterItem(List<Object> args) {
        String fieldKey = (String)args.get(0);
        ArrayList filterRows = (ArrayList)args.get(1);
        String targetFormId = this.getBillEntityNumber();
        if (StringUtils.isBlank((CharSequence)fieldKey)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f3a\u5c11FieldKey\u4f20\u53c2", (String)"NoCodeMulRefBillEdit_16", (String)BOS_NOCODE_EXT, (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty((Collection)filterRows)) {
            filterRows = new ArrayList(0);
        }
        try {
            HashMap<String, Object> filterParam = new HashMap<String, Object>(3);
            filterParam.put("headField", fieldKey);
            filterParam.put("filterRows", filterRows);
            filterParam.put("defaultFilterRows", this.getDefaultFilterRows());
            Map result = (Map)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.nocode.servicehelper", (String)"nocode_sys", (String)RestApiWrap.class.getSimpleName(), (String)"getHeadFieldFilterItem", (Object[])new Object[]{targetFormId, filterParam});
            result.put("k", this.key);
            result.put(ARGS, args);
            return result;
        }
        catch (Exception ex) {
            if (StringUtils.isNotBlank((CharSequence)ex.getMessage())) {
                this.getView().showErrorNotification(ex.getMessage());
            }
            logger.warn((Throwable)ex);
            return new HashMap<String, Object>(0);
        }
    }

    protected void invokeSetHeadFieldFilterItem(Map<String, Object> data) {
        if (this.getProperty().getParent() instanceof EntryType) {
            int rowIndex = this.getCurrentRowIndex();
            data.put("r", rowIndex);
            String ctlKey = StringUtils.isBlank((CharSequence)this.getEntryControlKey()) ? this.getEntryKey() : this.getEntryControlKey();
            this.clientViewProxy.invokeControlMethod(ctlKey, SET_HEAD_FIELD_FILTER_ITEM, new Object[]{data});
        } else {
            data.put("r", 0);
            this.clientViewProxy.invokeControlMethod(this.key, SET_HEAD_FIELD_FILTER_ITEM, new Object[]{data});
        }
    }

    private String parseFilterString(String appId, String formId, List<?> filterrows) {
        RestApiQueryResult queryResult;
        Map filterMap;
        if (filterrows == null || filterrows.isEmpty()) {
            return "";
        }
        HashMap reqData = new HashMap(10);
        HashMap payload = new HashMap(10);
        ArrayList dataItem = new ArrayList(10);
        HashMap<String, Object> plObj = new HashMap<String, Object>(10);
        plObj.put("appid", appId);
        plObj.put("formid", formId);
        plObj.put("filterrows", filterrows);
        dataItem.add(plObj);
        payload.put("data", dataItem);
        reqData.put("data", payload);
        String rootUrl = UrlService.getDomainContextUrl();
        String apiUrl = "/nocode/v2/nocode_sys/bos_nocode_filterconfig?getFilter=true";
        String fullRequestUrl = String.format("%s%s", rootUrl, apiUrl);
        HashMap<String, String> queryStringMap = new HashMap<String, String>(0);
        queryStringMap.put("appid", appId);
        queryStringMap.put("getFilter", "true");
        HashMap reqHeaders = new HashMap(16);
        RestApiRequest request = new RestApiRequest(fullRequestUrl, apiUrl, queryStringMap, OperationType.QUERY, HttpMethod.POST, ApiVersion.TWO, appId, "bos_nocode_filterconfig", reqData, reqHeaders, "");
        RestApiSaveParam param = new RestApiSaveParam(request);
        param.setAppNumber(appId);
        param.setFormId("bos_nocode_filterconfig");
        param.setApiVersion(ApiVersion.TWO);
        param.setUrl(apiUrl);
        param.setDataList(dataItem);
        RestApiServiceData<RestApiQueryResult> restServiceData = this.invokeRestApiPost(param);
        if (restServiceData != null && (filterMap = (Map)(queryResult = (RestApiQueryResult)restServiceData.getResponse().getData()).getRows().get(0)) != null) {
            String filter = (String)filterMap.get("filter");
            if (StringUtils.isEmpty((CharSequence)filter)) {
                return "";
            }
            return filter;
        }
        return "";
    }

    public void postBack(Object value, int rowIndex, int parentRowIndex) {
        this.beforePostBack(this.getModel(), this.getKey());
        String newValue = null;
        if (value instanceof List) {
            List valList = (List)value;
            newValue = String.join((CharSequence)",", valList);
        } else if (value instanceof Map) {
            Map valMap = (Map)value;
            newValue = this.getRealSelectedIds(valMap);
        } else {
            newValue = (String)value;
            if (StringUtils.isNotBlank((CharSequence)newValue) && BillConsts.ID_NOT_IN_PATTERN.matcher(newValue).find()) {
                newValue = this.getRealSelectedIds(newValue);
            }
        }
        super.postBack((Object)newValue, rowIndex, parentRowIndex);
    }

    private String getRealSelectedIds(String filter) {
        String targetFormId = this.getBillEntityNumber();
        if (StringUtils.isBlank((CharSequence)targetFormId)) {
            return filter;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String appId = formShowParameter.getAppId();
        int pageSize = 10000;
        int pageNo = 1;
        filter = filter == null ? "" : filter;
        String queryStr = String.format("?page_size=%s&page_no=%s", pageSize, pageNo);
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            queryStr = queryStr + "&filter=" + filter;
        }
        HashMap reqData = new HashMap(10);
        reqData.put("data", new HashMap(10));
        String rootUrl = UrlService.getDomainContextUrl();
        String apiUrl = String.format("nocode/v2/%s/%s/%s", appId, targetFormId, queryStr);
        String fullRequestUrl = String.format("%s%s", rootUrl, apiUrl);
        HashMap<String, String> queryStringMap = new HashMap<String, String>(0);
        queryStringMap.put(FROM_REF_BILL, "true");
        queryStringMap.put("showType", "list");
        HashMap reqHeaders = new HashMap(16);
        RestApiRequest request = new RestApiRequest(fullRequestUrl, apiUrl, queryStringMap, OperationType.QUERY, HttpMethod.GET, ApiVersion.TWO, appId, targetFormId, reqData, reqHeaders, filter);
        RestApiQueryParam param = new RestApiQueryParam(request);
        param.setFormId(targetFormId);
        param.setAppNumber(appId);
        param.setPage_size(pageSize);
        param.setPage_no(pageNo);
        RestApiQueryResult data = (RestApiQueryResult)this.invokeRestApiQuery(param).getResponse().getData();
        if (data != null && !data.getRows().isEmpty()) {
            BillEntityType dt = this.getMainEntityType();
            String pkName = dt.getPrimaryKey().getName();
            ArrayList<String> ids = new ArrayList<String>(data.getRows().size());
            for (Map row : data.getRows()) {
                String pkValue = String.valueOf(row.get(pkName));
                ids.add(pkValue);
            }
            return String.join((CharSequence)",", ids);
        }
        return null;
    }

    private String getRealSelectedIds(Map valMap) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String appId = formShowParameter.getAppId();
        String targetFormId = this.getBillEntityNumber();
        String filterStrEx = (String)valMap.get(KEY_V);
        List args = (List)valMap.get(KEY_F);
        int pageSize = args.get(0) == null ? 100000 : Integer.parseInt(args.get(0).toString());
        int pageNo = args.get(0) == null ? 1 : Integer.parseInt(args.get(1).toString());
        String keyword = args.get(2) == null ? "" : args.get(2).toString();
        String filter = "";
        if (args.get(3) != null) {
            filter = args.get(3) instanceof String ? args.get(3).toString() : (args.get(3) instanceof List ? this.parseFilterString(appId, targetFormId, (List)args.get(3)) : "");
        }
        String pksFilter = this.appendPksFilter(args);
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            if (StringUtils.isNotBlank((CharSequence)pksFilter)) {
                filter = filter + " and ( " + pksFilter + " )";
            }
        } else {
            filter = pksFilter;
        }
        if (StringUtils.isNotBlank((CharSequence)filterStrEx)) {
            filter = StringUtils.isNotBlank((CharSequence)filter) ? filter + " and ( " + filterStrEx + " )" : filterStrEx;
        }
        String orderBy = Objects.isNull(args.get(4)) ? "" : args.get(4).toString();
        String queryStr = String.format("?page_size=%s&page_no=%s&order_by=%s", pageSize, pageNo, orderBy);
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            queryStr = queryStr + "&search=" + keyword;
        }
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            queryStr = queryStr + "&filter=" + filter;
        }
        HashMap reqData = new HashMap(10);
        reqData.put("data", new HashMap(10));
        String rootUrl = UrlService.getDomainContextUrl();
        String apiUrl = String.format("nocode/v2/%s/%s/%s", appId, targetFormId, queryStr);
        String fullRequestUrl = String.format("%s%s", rootUrl, apiUrl);
        HashMap<String, String> queryStringMap = new HashMap<String, String>(0);
        queryStringMap.put(FROM_REF_BILL, "true");
        queryStringMap.put("showType", "list");
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            queryStringMap.put("search", keyword);
        }
        List<Map<String, Object>> defaultFilterRows = this.getDefaultFilterRows();
        queryStringMap.put("defaultFilterRows", SerializationUtils.toJsonString(defaultFilterRows));
        HashMap reqHeaders = new HashMap(16);
        RestApiRequest request = new RestApiRequest(fullRequestUrl, apiUrl, queryStringMap, OperationType.QUERY, HttpMethod.GET, ApiVersion.TWO, appId, targetFormId, reqData, reqHeaders, filter);
        RestApiQueryParam param = new RestApiQueryParam(request);
        param.setFormId(targetFormId);
        param.setAppNumber(appId);
        param.setPage_size(pageSize);
        param.setPage_no(pageNo);
        RestApiQueryResult data = (RestApiQueryResult)this.invokeRestApiQuery(param).getResponse().getData();
        if (data != null && !data.getRows().isEmpty()) {
            BillEntityType dt = this.getMainEntityType();
            String pkName = dt.getPrimaryKey().getName();
            ArrayList<String> ids = new ArrayList<String>(data.getRows().size());
            for (Map row : data.getRows()) {
                String pkValue = String.valueOf(row.get(pkName));
                ids.add(pkValue);
            }
            return String.join((CharSequence)",", ids);
        }
        return null;
    }

    protected boolean canRead() {
        return this.canRead(this.view, this.key);
    }
}

