/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.form.field;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.form.IFormView;
import kd.bos.nocode.utils.FuncPermItemEnum;
import kd.bos.servicehelper.permission.nocode.NoCodePermissionServiceHelper;
import kd.bos.util.StringUtils;

public interface NoCodeReadableEdit {
    default public boolean canRead(IFormView view, String key) {
        if (view.getParentView() == null) {
            return false;
        }
        String shareId = view.getParentView().getPageCache().get("noCodeShareId");
        if (StringUtils.isNotEmpty((String)shareId)) {
            return true;
        }
        String formId = view.getFormShowParameter().getFormId();
        long uid = RequestContext.get().getCurrUserId();
        Map fieldPermMap = NoCodePermissionServiceHelper.getNoPermProperties((long)uid, (String)formId);
        OperationStatus status = view.getFormShowParameter().getStatus();
        Set hides = new HashSet();
        switch (status) {
            case ADDNEW: {
                hides = fieldPermMap.getOrDefault(FuncPermItemEnum.input.getId(), new HashSet());
                break;
            }
            case VIEW: {
                hides = fieldPermMap.getOrDefault(FuncPermItemEnum.view.getId(), new HashSet());
                break;
            }
            case EDIT: {
                hides = fieldPermMap.getOrDefault(FuncPermItemEnum.edit.getId(), new HashSet());
            }
        }
        return !hides.contains(key);
    }
}

