/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.form.field;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.GeoPointProp;
import kd.bos.entity.property.NameVersionEntryProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.field.RefBillEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.ext.form.field.NoCodeEdit;
import kd.bos.nocode.ext.form.field.NoCodeReadableEdit;
import kd.bos.nocode.ext.property.NoCodeRefBillProp;
import kd.bos.nocode.ext.proxy.EntityTypeUtilsProxy;
import kd.bos.nocode.ext.proxy.FuzzySearchUtilsProxy;
import kd.bos.nocode.ext.proxy.PropertyHandleUtilProxy;
import kd.bos.nocode.ext.util.FormMetadataUtils;
import kd.bos.nocode.property.INoCodeGraphicDisplayProp;
import kd.bos.nocode.property.INoCodeRichTextProp;
import kd.bos.nocode.restapi.RestApiWrap;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiRequest;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.api.sys.SysServiceFormId;
import kd.bos.nocode.restapi.common.constant.ApiVersion;
import kd.bos.nocode.restapi.common.constant.HttpMethod;
import kd.bos.nocode.restapi.common.constant.OperationType;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.JsonUtil;
import kd.bos.nocode.restapi.common.util.Maps;
import kd.bos.nocode.servicehelper.DispatchApiServiceHelper;
import kd.bos.nocode.utils.FieldTreeBuilder;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.utils.FuncPermItemEnum;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.url.UrlService;
import org.apache.commons.collections4.MapUtils;

@KSObject
public class NoCodeRefBillEdit
extends RefBillEdit
implements NoCodeReadableEdit,
NoCodeEdit {
    private static final int DEFAULT_PAGE_SIZE = 20;
    private static final int INITIAL_CAPACITY = 10;
    private static final int ARGS_IDX_ORDER_BY = 4;
    private static final String SET_LIST_QUERY = "setListQuery";
    private static final String SET_LIST_CONFIG = "setListConfig";
    private static final String SET_SELECTED_DISP = "setSelectedDisp";
    private static final String SET_FILTER_ITEM_LOOK = "setFilterItemLook";
    private static final String SET_HEAD_FIELD_FILTER_ITEM = "setHeadFieldFilterItem";
    private static final Log logger = LogFactory.getLog(NoCodeRefBillEdit.class);
    private static final String FROM_REF_BILL = "fromrefbill";
    public static final String APPID = "appid";

    protected void checkNullException() {
        if (StringUtils.isBlank((CharSequence)this.getBillEntityId())) {
            String name = this.getItemTypeName();
            throw new KDBizException(name);
        }
    }

    protected boolean canRead() {
        return this.canRead(this.view, this.key);
    }

    protected String getDisplayProperty() {
        return ((NoCodeRefBillProp)this.getProperty()).getPropsDisplay();
    }

    protected Map<String, Object> getLookUpData(List<Object> args, BillEntityType dt) {
        String selectedStr;
        String searchKey = (String)args.get(1);
        if (searchKey == null) {
            searchKey = "";
        }
        searchKey = searchKey.trim();
        long selectedId = 0L;
        if (args.get(3) instanceof ArrayList) {
            String selectedStr2;
            ArrayList pks = (ArrayList)args.get(3);
            if (!pks.isEmpty() && StringUtils.isNotBlank((CharSequence)(selectedStr2 = (String)pks.get(0)))) {
                selectedId = Long.parseLong(selectedStr2);
            }
        } else if (args.get(3) instanceof String && StringUtils.isNotBlank((CharSequence)(selectedStr = (String)args.get(3)))) {
            selectedId = Long.parseLong(selectedStr);
        }
        int top = 50;
        HashMap<String, Object> data = new HashMap<String, Object>();
        String formId = this.getBillEntityId();
        FieldTreeBuilder fieldTreeBuilder = new FieldTreeBuilder(formId);
        List fieldTree = fieldTreeBuilder.withFeature(new FieldTreeBuilder.Feature[]{FieldTreeBuilder.Feature.IncludePK, FieldTreeBuilder.Feature.AttachmentDetail}).withSelectFields(this.getSelectFields()).withoutFieldTypes(new FieldTreeBuilder.FieldType[]{FieldTreeBuilder.FieldType.NoCodeRichTextField, FieldTreeBuilder.FieldType.NoCodeGraphicDisplayField, FieldTreeBuilder.FieldType.NoCodeAttachmentUploadField, FieldTreeBuilder.FieldType.NoCodeImageUploadField, FieldTreeBuilder.FieldType.EntryField}).build();
        data.put("columns", fieldTree);
        Tuple<List<Object>, Boolean> qData = this.queryDataForLookup(searchKey, dt, top, selectedId);
        data.put("data", qData.item1);
        data.put("next", qData.item2);
        data.put("k", this.key);
        data.put("size", top);
        data.put("args", args);
        return data;
    }

    private Tuple<List<Object>, Boolean> queryDataForLookup(String searchKey, BillEntityType dt, int top, long selectedId) {
        List<Map<String, Object>> resultData;
        Boolean hasNext = Boolean.FALSE;
        ArrayList<List<Object>> data = new ArrayList<List<Object>>();
        ArrayList<String> fields = new ArrayList<String>(10);
        fields.add(dt.getPrimaryKey().getName());
        String orderBys = null;
        ArrayList<String> searchFields = new ArrayList<String>();
        String displayProperty = this.getSelectFields();
        if (StringUtils.isNotBlank((CharSequence)displayProperty)) {
            for (String string : displayProperty.split(",")) {
                if (!EntityTypeUtilsProxy.existProperty((DynamicObjectType)dt, string)) continue;
                fields.add(string);
                searchFields.add(string);
                if (orderBys != null) continue;
                orderBys = string + " asc";
            }
        }
        QFilter filter = null;
        if (StringUtils.isNotBlank((CharSequence)searchKey)) {
            Collection properties = dt.getAllFields().values();
            properties = properties.stream().filter(p -> searchFields.contains(p.getName())).collect(Collectors.toList());
            filter = FuzzySearchUtilsProxy.getSearchQFilter(dt.getName(), properties, searchKey);
            if (selectedId > 0L) {
                filter = filter.or(new QFilter("id", "=", (Object)selectedId));
            }
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)dt.getName(), (String)String.join((CharSequence)",", fields), (QFilter[])new QFilter[]{filter}, orderBys, (int)(top + 1));
        if (selectedId > 0L) {
            DynamicObject dynamicObject;
            boolean exit = false;
            for (DynamicObject dynamicObject2 : dynamicObjects) {
                long id = (Long)dynamicObject2.get("id");
                if (selectedId != id) continue;
                exit = true;
                break;
            }
            if (!exit && (dynamicObject = BusinessDataServiceHelper.loadSingle((Object)selectedId, (DynamicObjectType)dt)) != null) {
                DynamicObject[] targetDynamicObjects = new DynamicObject[dynamicObjects.length + 1];
                System.arraycopy(dynamicObjects, 0, targetDynamicObjects, 1, dynamicObjects.length);
                targetDynamicObjects[0] = dynamicObject;
                dynamicObjects = targetDynamicObjects;
            }
        }
        if ((resultData = PropertyHandleUtilProxy.toMapListRoot(dt.getName(), "$", dynamicObjects, Sets.newHashSet(fields))).size() > top) {
            hasNext = Boolean.TRUE;
        }
        int n = Math.max(fields.size(), 3);
        for (int i = 0; i < resultData.size(); ++i) {
            if (i >= top) continue;
            Map<String, Object> dynamicObjectMap = resultData.get(i);
            Object[] arr = new String[n];
            for (int j = 0; j < n; ++j) {
                arr[j] = "";
            }
            this.setDataByFields(fields, dynamicObjectMap, arr);
            if (StringUtils.isNotBlank((CharSequence)searchKey) && !Arrays.stream(arr).anyMatch(a -> a != null && ((String)a).contains(searchKey))) continue;
            data.add(Arrays.asList(arr));
        }
        if (data.size() > top) {
            hasNext = Boolean.TRUE;
        }
        return new Tuple(data, (Object)hasNext);
    }

    private void setDataByFields(List<String> fields, Map<String, Object> dynamicObjectMap, Object[] arr) {
        int fieldIndex = 0;
        for (String fld : fields) {
            String value = dynamicObjectMap.get(fld) == null ? "" : String.valueOf(dynamicObjectMap.get(fld));
            arr[fieldIndex] = value;
            ++fieldIndex;
        }
    }

    public void setItemByIdFromClient(List<Object> args) {
        int index = this.getCurrentRowIndex();
        ArrayList baseQFilters = new ArrayList();
        if (args != null && StringUtils.isNotBlank((Object)args.get(0))) {
            ArrayList pks;
            Object pk = args.get(0);
            if (pk == null) {
                return;
            }
            if (pk instanceof String) {
                pk = StringUtils.isBlank((Object)pk) ? null : Long.valueOf(Long.parseLong((String)pk));
            } else if (pk instanceof ArrayList && !(pks = (ArrayList)pk).isEmpty()) {
                pk = Long.parseLong(pks.get(0).toString());
            }
            if (pk == null) {
                throw new RestApiException("illegal args");
            }
            this.setItemValueByID(pk, index, baseQFilters);
            if (StringUtils.isNotBlank((Object)args.get(0))) {
                this.addNewLineIfKeyField(1, this.getCurrentRowIndex());
            }
        } else {
            this.getDataModel().setValue(this.getProperty().getName(), null, index);
        }
        this.getView().setReturnData(args);
    }

    public void getListQuery(List<Object> args) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String appId = formShowParameter.getAppId();
        String formId = formShowParameter.getFormId();
        String targetFormId = this.getBillEntityId();
        boolean share = NoCodePermHelper.isShare((String)appId, (String)formId, (String)this.getView().getParentView().getPageCache().get("noCodeShareId"));
        if (!share && FormMetadataUtils.isNoCodeBill(targetFormId) && !NoCodePermHelper.checkFuncPerm((FuncPermItemEnum)FuncPermItemEnum.view, (String)targetFormId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u8868\u5355\u6743\u9650", (String)"NoCodeRefBillEdit_0", (String)"bos-nocode-ext", (Object[])new Object[0]));
            return;
        }
        int pageSize = args.get(0) == null ? 20 : Integer.parseInt(args.get(0).toString());
        int pageNo = args.get(0) == null ? 1 : Integer.parseInt(args.get(1).toString());
        String keyword = args.get(2) == null ? "" : args.get(2).toString();
        String filter = "";
        if (args.get(3) != null) {
            if (args.get(3) instanceof String) {
                filter = args.get(3).toString();
            } else if (args.get(3) instanceof List) {
                filter = this.parseFilterString(appId, targetFormId, (List)args.get(3));
            }
        }
        String orderBy = Objects.isNull(args.get(4)) ? "" : args.get(4).toString();
        String queryStr = String.format("?page_size=%s&page_no=%s&order_by=%s", pageSize, pageNo, orderBy);
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            queryStr = queryStr + "&search=" + keyword;
        }
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            queryStr = queryStr + "&filter=" + filter;
        }
        HashMap reqData = new HashMap(10);
        reqData.put("data", new HashMap(10));
        String rootUrl = UrlService.getDomainContextUrl();
        String apiUrl = String.format("nocode/v2/%s/%s/%s", appId, targetFormId, queryStr);
        String fullRequestUrl = String.format("%s%s", rootUrl, apiUrl);
        HashMap<String, String> queryStringMap = new HashMap<String, String>(0);
        queryStringMap.put("search", keyword);
        HashMap reqHeaders = new HashMap(16);
        RestApiRequest request = new RestApiRequest(fullRequestUrl, apiUrl, queryStringMap, OperationType.QUERY, HttpMethod.GET, ApiVersion.TWO, appId, targetFormId, reqData, reqHeaders, filter);
        RestApiQueryParam param = new RestApiQueryParam(request);
        param.setFormId(targetFormId);
        param.setAppNumber(appId);
        param.setPage_size(pageSize);
        param.setPage_no(pageNo);
        param.setOrder_by(orderBy);
        HashMap<String, Object> result = new HashMap<String, Object>();
        RestApiQueryResult data = (RestApiQueryResult)this.invokeRestApiQuery(param).getResponse().getData();
        if (data != null) {
            if (!data.getRows().isEmpty()) {
                this.fixupRowTitle(data, false);
            }
            data.setPageNo(pageNo);
            data.setPageSize(pageSize);
            result.put("data", JsonUtil.parseJson2Map((String)JsonUtil.format((Object)data)));
        }
        result.put("k", this.key);
        result.put("args", args);
        this.invokeSetListQuery(result);
    }

    public void getSelectedDisp(List<Object> args) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String appId = formShowParameter.getAppId();
        String formId = formShowParameter.getFormId();
        String targetFormId = this.getBillEntityNumber();
        String shareId = this.getView().getParentView().getPageCache().get("noCodeShareId");
        boolean share = NoCodePermHelper.isShare((String)appId, (String)formId, (String)shareId);
        if (!share && FormMetadataUtils.isNoCodeBill(targetFormId) && !NoCodePermHelper.checkFuncPerm((FuncPermItemEnum)FuncPermItemEnum.view, (String)targetFormId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u8868\u5355\u6743\u9650", (String)"NoCodeRefBillEdit_0", (String)"bos-nocode-ext", (Object[])new Object[0]));
            return;
        }
        if (share && !NoCodePermHelper.checkPublishEnt((String)appId, (String)targetFormId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u8868\u5355\u6743\u9650", (String)"NoCodeRefBillEdit_0", (String)"bos-nocode-ext", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)targetFormId)) {
            int pageSize = args.get(0) == null ? 20 : Integer.parseInt(args.get(0).toString());
            int pageNo = args.get(0) == null ? 1 : Integer.parseInt(args.get(1).toString());
            String filter = args.get(2) == null ? "" : args.get(2).toString();
            String queryStr = String.format("?page_size=%s&page_no=%s", pageSize, pageNo);
            if (StringUtils.isNotBlank((CharSequence)filter)) {
                queryStr = queryStr + "&filter=" + filter;
            }
            HashMap reqData = new HashMap(10);
            reqData.put("data", new HashMap(10));
            String rootUrl = UrlService.getDomainContextUrl();
            String apiUrl = String.format("nocode/v2/%s/%s/%s", appId, targetFormId, queryStr);
            String fullRequestUrl = String.format("%s%s", rootUrl, apiUrl);
            HashMap<String, String> queryStringMap = new HashMap<String, String>(0);
            queryStringMap.put(FROM_REF_BILL, "true");
            queryStringMap.put("showType", "list");
            HashMap reqHeaders = new HashMap(16);
            RestApiRequest request = new RestApiRequest(fullRequestUrl, apiUrl, queryStringMap, OperationType.QUERY, HttpMethod.GET, ApiVersion.TWO, appId, targetFormId, reqData, reqHeaders, filter);
            RestApiQueryParam param = new RestApiQueryParam(request);
            param.setFormId(targetFormId);
            param.setAppNumber(appId);
            param.setPage_size(pageSize);
            param.setPage_no(pageNo);
            param.setShareId(shareId);
            HashMap<String, Object> result = new HashMap<String, Object>();
            RestApiQueryResult data = (RestApiQueryResult)this.invokeRestApiQuery(param).getResponse().getData();
            if (data != null) {
                if (!data.getRows().isEmpty()) {
                    this.fixupRowTitle(data, true);
                }
                data.setPageNo(pageNo);
                data.setPageSize(pageSize);
                result.put("data", JsonUtil.parseJson2Map((String)JsonUtil.format((Object)data)));
            }
            result.put("k", this.key);
            result.put("args", args);
            this.invokeSetSelectedDisp(result);
        }
    }

    protected void invokeSetSelectedDisp(Map<String, Object> data) {
        if (this.getProperty().getParent() instanceof EntryType) {
            int rowIndex = this.getCurrentRowIndex();
            data.put("r", rowIndex);
            String ctlKey = StringUtils.isBlank((CharSequence)this.getEntryControlKey()) ? this.getEntryKey() : this.getEntryControlKey();
            this.clientViewProxy.invokeControlMethod(ctlKey, SET_SELECTED_DISP, new Object[]{data});
        } else {
            data.put("r", 0);
            this.clientViewProxy.invokeControlMethod(this.key, SET_SELECTED_DISP, new Object[]{data});
        }
    }

    private List<Map<String, Object>> showUserInfo(Object pkValue) {
        if (pkValue == null) {
            return null;
        }
        String filter = "id EQ " + pkValue;
        RestApiQueryResult data = this.queryUser(filter);
        return data.getRows();
    }

    private List<Map<String, Object>> showOrgInfo(Object pkValue) {
        if (pkValue == null) {
            return null;
        }
        Map map = OrgUnitServiceHelper.getOrgProperty((long)Long.parseLong(pkValue.toString()), Arrays.asList("number", "name"));
        Map directSuperiorOrg = OrgUnitServiceHelper.getDirectSuperiorOrg((String)"01", Collections.singletonList(Long.parseLong(pkValue.toString())));
        Long parentId = (Long)directSuperiorOrg.get(Long.parseLong(pkValue.toString()));
        if (Objects.isNull(parentId) || parentId == 0L) {
            map.put("parentid", "");
            map.put("parentname", "");
        } else {
            Map parentProperties = OrgUnitServiceHelper.getOrgProperty((long)parentId, (List)Lists.newArrayList((Object[])new String[]{"name"}));
            String name = "";
            name = MapUtils.isEmpty((Map)parentProperties) ? "" : ((ILocaleString)parentProperties.get("name")).getLocaleValue();
            map.put("parentid", parentId.toString());
            map.put("parentname", name);
        }
        if (map.get("name") != null) {
            map.put("name", ((ILocaleString)map.get("name")).getLocaleValue());
        }
        map.put("id", map.get("id").toString());
        String filter = "entryentity.dpt.number EQ " + map.get("number");
        RestApiQueryResult data = this.queryUser(filter);
        map.put("users", data);
        return Collections.singletonList(map);
    }

    private RestApiQueryResult queryUser(String filter) {
        String rootUrl = UrlService.getDomainContextUrl();
        String apiUrl = "nocode/v2/nocode_sys/common/user";
        String fullRequestUrl = String.format("%s%s", rootUrl, apiUrl);
        HashMap queryStringMap = new HashMap(0);
        fullRequestUrl = fullRequestUrl + "&filter=" + filter;
        HashMap reqData = new HashMap(10);
        reqData.put("data", new HashMap(10));
        HashMap reqHeaders = new HashMap(16);
        RestApiRequest request = new RestApiRequest(fullRequestUrl, apiUrl, queryStringMap, OperationType.QUERY, HttpMethod.GET, ApiVersion.TWO, "", "common", reqData, reqHeaders, filter);
        RestApiQueryParam param = new RestApiQueryParam(request);
        param.setFormId("common");
        param.setAppNumber("nocode_sys");
        return (RestApiQueryResult)this.invokeRestApiQuery(param).getResponse().getData();
    }

    public void showInfo(List<Object> args) {
        List<Map<String, Object>> list = this.getInfo(args);
        if (list == null) {
            return;
        }
        String target = NcEntityTypeUtil.getRealBillEntityNumber((String)this.getBillEntityId());
        if ("bos_user".equals(target)) {
            this.invokeUserInfo(list);
        } else if ("bos_adminorg".equals(target)) {
            this.invokeOrgInfo(list);
        }
    }

    private void invokeUserInfo(List<Map<String, Object>> list) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.addAction("InvokeControlMethod", (Object)Maps.of((Object)"key", (Object)this.key, (Object)"methodname", (Object)"showUserInfo", (Object)"args", list));
    }

    private void invokeOrgInfo(List<Map<String, Object>> list) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.addAction("InvokeControlMethod", (Object)Maps.of((Object)"key", (Object)this.key, (Object)"methodname", (Object)"showOrgInfo", (Object)"args", list));
    }

    public List<Map<String, Object>> getInfo(List<Object> args) {
        boolean check;
        boolean nocodeApp;
        Object pkId = args.get(0);
        if (pkId == null) {
            return null;
        }
        String target = NcEntityTypeUtil.getRealBillEntityNumber((String)this.getBillEntityId());
        boolean share = NoCodePermHelper.isShare(null, null, (String)this.getView().getParentView().getPageCache().get("noCodeShareId"));
        if ("bos_user".equals(target)) {
            if (!share) {
                return this.showUserInfo(pkId);
            }
        } else if ("bos_adminorg".equals(target) && !share) {
            return this.showOrgInfo(pkId);
        }
        if (!(nocodeApp = NoCodeRefBillEdit.isNocodeApp(target))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u8868\u5355\u6682\u4e0d\u652f\u6301\u67e5\u770b\u8be6\u60c5", (String)"NoCodeRefBillEdit_1", (String)"bos-nocode-ext", (Object[])new Object[0]));
            return null;
        }
        boolean bl = check = NoCodePermHelper.checkFuncPermInNoCode((FuncPermItemEnum)FuncPermItemEnum.view, (String)target) && NoCodePermHelper.checkDataPermInNoCode((String)target, (Object)pkId);
        if (!check) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6743\u9650\u4e0d\u8db3", (String)"NoCodeRefBillEdit_2", (String)"bos-nocode-ext", (Object[])new Object[0]));
            return null;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_nocode_bill_nested2");
        String appId = this.getModel().getDataEntityType().getAppId();
        parameter.setCustomParam("ServiceAppId", (Object)("bos." + appId));
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setParentPageId(this.getView().getPageId());
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("targetFormId", (Object)target);
        parameter.setCustomParam("pkId", (Object)pkId.toString());
        parameter.setCustomParam("nested", (Object)true);
        if (share) {
            parameter.setCustomParam("skip", (Object)true);
            parameter.setCustomParam("share", (Object)true);
        }
        parameter.setCustomParam("nestedType", (Object)"showInfo");
        parameter.setCustomParam("Status", (Object)OperationStatus.VIEW);
        parameter.setCaption(ResManager.loadKDString((String)"\u8be6\u60c5", (String)"NoCodeRefBillEdit_3", (String)"bos-nocode-ext", (Object[])new Object[0]));
        this.getView().showForm(parameter);
        return null;
    }

    public void addNewRef(List<Object> args) {
        String billEntityId = this.getBillEntityId();
        if (StringUtils.isEmpty((CharSequence)billEntityId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5b57\u6bb5\u5173\u8054\u8868\u5355\u5c5e\u6027\u5df2\u88ab\u6e05\u7a7a\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e", (String)"NoCodeRefBillEdit_4", (String)"bos-nocode-ext", (Object[])new Object[0]));
            return;
        }
        if (!NcEntityTypeUtil.isFormExist((String)billEntityId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664", (String)"NoCodeRefBillEdit_5", (String)"bos-nocode-ext", (Object[])new Object[0]));
            return;
        }
        String target = NcEntityTypeUtil.getRealBillEntityNumber((String)billEntityId);
        boolean isNocodeApp = NoCodeRefBillEdit.isNocodeApp(target);
        if (isNocodeApp) {
            boolean check;
            String callbackProps = "";
            if (args != null && args.size() > 0) {
                callbackProps = args.get(0).toString();
            }
            if (!(check = NoCodePermHelper.checkFuncPermInNoCode((FuncPermItemEnum)FuncPermItemEnum.input, (String)target))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6743\u9650\u4e0d\u8db3", (String)"NoCodeRefBillEdit_2", (String)"bos-nocode-ext", (Object[])new Object[0]));
                return;
            }
            boolean share = NoCodePermHelper.isShare(null, null, (String)this.getView().getParentView().getPageCache().get("noCodeShareId"));
            if (share) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u4eab\u65f6\u4e0d\u53ef\u65b0\u589e", (String)"NoCodeRefBillEdit_6", (String)"bos-nocode-ext", (Object[])new Object[0]));
                return;
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bos_nocode_bill_nested2");
            String appId = this.getModel().getDataEntityType().getAppId();
            parameter.setCustomParam("ServiceAppId", (Object)("bos." + appId));
            parameter.setStatus(OperationStatus.ADDNEW);
            parameter.setParentPageId(this.getView().getPageId());
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("isAddRef", (Object)true);
            parameter.setCustomParam("targetFormId", (Object)target);
            parameter.setCustomParam("saveCallbackProps", (Object)callbackProps);
            parameter.setCustomParam("controlKey", (Object)this.key);
            parameter.setCustomParam("nested", (Object)true);
            parameter.setCustomParam("nestedType", (Object)"addRef");
            parameter.setCustomParam("Status", (Object)OperationStatus.ADDNEW);
            parameter.setCaption(ResManager.loadKDString((String)"\u5f55\u5165", (String)"NoCodeRefBillEdit_7", (String)"bos-nocode-ext", (Object[])new Object[0]));
            this.getView().showForm(parameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8868\u5355\u6682\u65f6\u65e0\u6cd5\u65b0\u589e", (String)"NoCodeRefBillEdit_8", (String)"bos-nocode-ext", (Object[])new Object[0]));
        }
    }

    public void editInfo(List<Object> args) {
        String callbackProps = "";
        Object pkId = null;
        if (args != null && args.size() > 1) {
            pkId = args.get(0);
            callbackProps = args.get(1).toString();
        }
        if (pkId == null) {
            return;
        }
        String target = NcEntityTypeUtil.getRealBillEntityNumber((String)this.getBillEntityId());
        boolean nocodeApp = NoCodeRefBillEdit.isNocodeApp(target);
        if (!nocodeApp) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u8868\u5355\u6682\u4e0d\u652f\u6301\u7f16\u8f91", (String)"NoCodeRefBillEdit_9", (String)"bos-nocode-ext", (Object[])new Object[0]));
            return;
        }
        boolean check = NoCodePermHelper.checkFuncPermInNoCode((FuncPermItemEnum)FuncPermItemEnum.edit, (String)target);
        if (!check) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6743\u9650\u4e0d\u8db3", (String)"NoCodeRefBillEdit_2", (String)"bos-nocode-ext", (Object[])new Object[0]));
            return;
        }
        boolean share = NoCodePermHelper.isShare(null, null, (String)this.getView().getParentView().getPageCache().get("noCodeShareId"));
        if (share) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u4eab\u65f6\u4e0d\u53ef\u7f16\u8f91", (String)"NoCodeRefBillEdit_10", (String)"bos-nocode-ext", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_nocode_bill_nested2");
        String appId = this.getModel().getDataEntityType().getAppId();
        parameter.setCustomParam("ServiceAppId", (Object)("bos." + appId));
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setParentPageId(this.getView().getPageId());
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("targetFormId", (Object)target);
        parameter.setCustomParam("pkId", (Object)pkId.toString());
        parameter.setCustomParam("nested", (Object)true);
        parameter.setCustomParam("nestedType", (Object)"editF7");
        parameter.setCustomParam("Status", (Object)OperationStatus.EDIT);
        parameter.setCustomParam("saveCallbackProps", (Object)callbackProps);
        parameter.setCustomParam("controlKey", (Object)this.key);
        parameter.setCaption(ResManager.loadKDString((String)"\u7f16\u8f91", (String)"NoCodeRefBillEdit_11", (String)"bos-nocode-ext", (Object[])new Object[0]));
        this.getView().showForm(parameter);
    }

    private static boolean isNocodeApp(String target) {
        String pkid = FormMetaUtil.getAppIdByFormNumber((String)target);
        boolean isNocodeApp = false;
        DynamicObject app = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)"bos_devportal_bizapp");
        if (app != null && "nocode".equals(app.getDynamicObject("bizcloud").getString("number"))) {
            isNocodeApp = true;
        }
        return isNocodeApp;
    }

    private List<Object> parsePks(RestApiQueryResult data, BillEntityType dt) {
        ArrayList<Object> pks = new ArrayList<Object>(10);
        String pkName = dt.getPrimaryKey().getName();
        for (Map row : data.getRows()) {
            pks.add(row.get(pkName));
        }
        return pks;
    }

    public String getSelectFields() {
        BillEntityType dt = this.getMainEntityType();
        ISimpleProperty primaryKey = dt.getPrimaryKey();
        ArrayList<String> props = new ArrayList<String>(10);
        props.add(primaryKey.getName());
        if (StringUtils.isNotBlank((CharSequence)this.getDisplayProperty())) {
            String[] split;
            for (String f : split = this.getDisplayProperty().split(",")) {
                IDataEntityProperty property = dt.findProperty(f);
                if (property == null || NoCodeRefBillEdit.defaultIgnoreProp(property)) continue;
                props.add(f);
            }
        }
        return String.join((CharSequence)",", props);
    }

    private static boolean defaultIgnoreProp(IDataEntityProperty fieldProp) {
        return fieldProp instanceof GeoPointProp || fieldProp.getParent() instanceof EntryType || fieldProp instanceof INoCodeRichTextProp || fieldProp instanceof NameVersionEntryProp || fieldProp instanceof INoCodeGraphicDisplayProp || fieldProp instanceof EntryProp || fieldProp instanceof AttachmentProp || fieldProp instanceof PictureProp;
    }

    protected BillEntityType getMainEntityType() {
        String formId = this.getBillEntityId();
        if (StringUtils.isBlank((CharSequence)formId) || !NcEntityTypeUtil.isFormExist((String)formId)) {
            return null;
        }
        return super.getMainEntityType();
    }

    private void fixupRowTitle(RestApiQueryResult data, boolean onlyTitle) {
        BillEntityType dt = this.getMainEntityType();
        List<Object> pks = this.parsePks(data, dt);
        String pkName = dt.getPrimaryKey().getName();
        QFilter[] filters = new QFilter[]{new QFilter(dt.getPrimaryKey().getName(), "in", pks)};
        List<Map<String, Object>> lookupData = this.queryData(this.getMainEntityType(), filters, null, pks.size(), null);
        String[] fields = this.getSelectFields().split(",");
        for (Map row : data.getRows()) {
            Long pkValue = (Long)row.get(pkName);
            Optional<Map> first = lookupData.stream().filter(d -> Long.parseLong(d.get(pkName).toString()) == pkValue).findFirst();
            if (!first.isPresent()) continue;
            StringBuilder sb = new StringBuilder();
            Map stringObjectMap = first.get();
            for (String field : fields) {
                if (field.equalsIgnoreCase(pkName) || !stringObjectMap.containsKey(field) || stringObjectMap.get(field) == null || StringUtils.isBlank((CharSequence)stringObjectMap.get(field).toString())) continue;
                Object o = stringObjectMap.get(field);
                if (sb.length() > 0) {
                    sb.append("|");
                }
                sb.append(o.toString());
            }
            if (onlyTitle) {
                row.clear();
            }
            row.put("_title_", sb.toString());
        }
    }

    private List<Map<String, Object>> queryData(BillEntityType dt, QFilter[] filters, String orderBys, int top, Object[] selectedPks) {
        String selectFields = this.getSelectFields();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)dt.getName(), (String)selectFields, (QFilter[])filters, (String)orderBys, (int)top);
        if (selectedPks != null && selectedPks.length > 0) {
            dynamicObjects = this.sureSelectedData(selectedPks, dynamicObjects, dt);
        }
        return PropertyHandleUtilProxy.toMapListRoot(dt.getName(), "$", dynamicObjects, Sets.newHashSet((Object[])selectFields.split(",")));
    }

    private DynamicObject[] sureSelectedData(Object[] selectedPks, DynamicObject[] dynamicObjects, BillEntityType dt) {
        Object[] selectedObjs;
        if (selectedPks.length <= 0) {
            return dynamicObjects;
        }
        Object[] pks = ArrayUtils.clone((Object[])selectedPks);
        for (DynamicObject dynamicObject : dynamicObjects) {
            long id = (Long)dynamicObject.get("id");
            boolean exit = false;
            Object lastPk = null;
            for (Object pk : pks) {
                if (id != Long.parseLong(pk.toString())) continue;
                exit = true;
                lastPk = pk;
                break;
            }
            if (!exit) continue;
            pks = ArrayUtils.removeElement((Object[])pks, lastPk);
        }
        if (pks.length > 0 && (selectedObjs = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)dt)) != null && selectedObjs.length > 0) {
            return (DynamicObject[])ArrayUtils.addAll((Object[])dynamicObjects, (Object[])selectedObjs);
        }
        return dynamicObjects;
    }

    protected void invokeSetListQuery(Map<String, Object> data) {
        if (this.getProperty().getParent() instanceof EntryType) {
            int rowIndex = this.getCurrentRowIndex();
            data.put("r", rowIndex);
            String ctlKey = StringUtils.isBlank((CharSequence)this.getEntryControlKey()) ? this.getEntryKey() : this.getEntryControlKey();
            this.clientViewProxy.invokeControlMethod(ctlKey, SET_LIST_QUERY, new Object[]{data});
        } else {
            data.put("r", 0);
            this.clientViewProxy.invokeControlMethod(this.key, SET_LIST_QUERY, new Object[]{data});
        }
    }

    private RestApiServiceData<RestApiQueryResult> invokeRestApiQuery(RestApiQueryParam param) {
        RestApiServiceData queryResult = (RestApiServiceData)DispatchApiServiceHelper.invokeApiService((String)QueryRestApiService.class.getSimpleName(), (Object[])new Object[]{param});
        if (param.isDyObjResult()) {
            return queryResult;
        }
        try {
            ((RestApiQueryResult)queryResult.getResponse().getData()).setRows(((RestApiQueryResult)queryResult.getResponse().getData()).getRows());
        }
        catch (Exception e) {
            logger.debug("set rows failed", (Object)e);
        }
        return queryResult;
    }

    private RestApiServiceData<RestApiQueryResult> invokeRestApiPost(RestApiSaveParam param) {
        return (RestApiServiceData)DispatchApiServiceHelper.invokeApiService((String)SaveRestApiService.class.getSimpleName(), (Object[])new Object[]{param});
    }

    public void getListConfig(List<Object> args) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String appId = formShowParameter.getAppId();
        String targetFormId = this.getBillEntityId();
        if (!NcEntityTypeUtil.isFormExist((String)targetFormId)) {
            return;
        }
        String queryStr = String.format("?appid=%s&formid=%s&env=1", appId, targetFormId);
        HashMap reqData = new HashMap(10);
        reqData.put("data", new HashMap(10));
        String rootUrl = UrlService.getDomainContextUrl();
        String apiUrl = String.format("/nocode/v2/nocode_sys/common/list_config/query%s", queryStr);
        String fullRequestUrl = String.format("%s%s", rootUrl, apiUrl);
        HashMap<String, String> queryStringMap = new HashMap<String, String>(0);
        queryStringMap.put(APPID, appId);
        queryStringMap.put("formid", targetFormId);
        queryStringMap.put("env", "1");
        queryStringMap.put(FROM_REF_BILL, "true");
        HashMap reqHeaders = new HashMap(16);
        RestApiRequest request = new RestApiRequest(fullRequestUrl, apiUrl, queryStringMap, OperationType.QUERY, HttpMethod.GET, ApiVersion.TWO, appId, SysServiceFormId.COMMON.getName(), reqData, reqHeaders, "");
        RestApiQueryParam param = new RestApiQueryParam(request);
        param.setFormId(SysServiceFormId.COMMON.getName());
        param.setAppNumber(appId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        RestApiServiceData<RestApiQueryResult> data = this.invokeRestApiQuery(param);
        result.put("data", data.getResponse().getData());
        Object selectedData = this.getSelectedData();
        if (selectedData != null) {
            result.put("selected", selectedData);
        }
        result.put("k", this.key);
        result.put("args", args);
        this.invokeSetListConfig(result);
    }

    protected void invokeSetListConfig(Map<String, Object> data) {
        if (this.getProperty().getParent() instanceof EntryType) {
            int rowIndex = this.getCurrentRowIndex();
            data.put("r", rowIndex);
            String ctlKey = StringUtils.isBlank((CharSequence)this.getEntryControlKey()) ? this.getEntryKey() : this.getEntryControlKey();
            this.clientViewProxy.invokeControlMethod(ctlKey, SET_LIST_CONFIG, new Object[]{data});
        } else {
            data.put("r", 0);
            this.clientViewProxy.invokeControlMethod(this.key, SET_LIST_CONFIG, new Object[]{data});
        }
    }

    private Object getSelectedData() {
        Object currValue = this.getModel().getValue(this.getProperty().getName(), this.getCurrentRowIndex());
        NoCodeRefBillProp prop = (NoCodeRefBillProp)this.getProperty();
        Object[] data = (Object[])prop.getBindingRefBillValue(currValue, prop.getDisplayProp());
        if (data != null && data.length > 1000) {
            data = ArrayUtils.subarray((Object[])data, (int)0, (int)1000);
        }
        return data;
    }

    public void getFilterItemLook(List<Object> args) {
        String fieldKey = (String)args.get(0);
        ArrayList filterRows = (ArrayList)args.get(1);
        String targetFormId = this.getBillEntityNumber();
        if (StringUtils.isBlank((CharSequence)fieldKey)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f3a\u5c11FieldKey\u4f20\u53c2", (String)"NoCodeRefBillEdit_12", (String)"bos-nocode-ext", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty((Collection)filterRows)) {
            filterRows = new ArrayList(0);
        }
        HashMap<String, Object> filterParam = new HashMap<String, Object>(3);
        filterParam.put("getEnumData", "true");
        filterParam.put("enumField", fieldKey);
        filterParam.put("filterrows", filterRows);
        Map result = (Map)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.nocode.servicehelper", (String)"nocode_sys", (String)RestApiWrap.class.getSimpleName(), (String)"getFilterItemLook", (Object[])new Object[]{targetFormId, filterParam});
        result.put("k", this.key);
        result.put("args", args);
        this.invokeSetFilterItemLook(result);
    }

    protected void invokeSetFilterItemLook(Map<String, Object> data) {
        if (this.getProperty().getParent() instanceof EntryType) {
            int rowIndex = this.getCurrentRowIndex();
            data.put("r", rowIndex);
            String ctlKey = StringUtils.isBlank((CharSequence)this.getEntryControlKey()) ? this.getEntryKey() : this.getEntryControlKey();
            this.clientViewProxy.invokeControlMethod(ctlKey, SET_FILTER_ITEM_LOOK, new Object[]{data});
        } else {
            data.put("r", 0);
            this.clientViewProxy.invokeControlMethod(this.key, SET_FILTER_ITEM_LOOK, new Object[]{data});
        }
    }

    public void getHeadFieldFilterItem(List<Object> args) {
        String fieldKey = (String)args.get(0);
        ArrayList filterRows = (ArrayList)args.get(1);
        String targetFormId = this.getBillEntityNumber();
        if (StringUtils.isBlank((CharSequence)fieldKey)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f3a\u5c11FieldKey\u4f20\u53c2", (String)"NoCodeRefBillEdit_12", (String)"bos-nocode-ext", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty((Collection)filterRows)) {
            filterRows = new ArrayList(0);
        }
        HashMap<String, Object> filterParam = new HashMap<String, Object>(3);
        filterParam.put("headField", fieldKey);
        filterParam.put("filterRows", filterRows);
        Map result = (Map)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.nocode.servicehelper", (String)"nocode_sys", (String)RestApiWrap.class.getSimpleName(), (String)"getHeadFieldFilterItem", (Object[])new Object[]{targetFormId, filterParam});
        result.put("k", this.key);
        result.put("args", args);
        this.invokeSetHeadFieldFilterItem(result);
    }

    protected void invokeSetHeadFieldFilterItem(Map<String, Object> data) {
        if (this.getProperty().getParent() instanceof EntryType) {
            int rowIndex = this.getCurrentRowIndex();
            data.put("r", rowIndex);
            String ctlKey = StringUtils.isBlank((CharSequence)this.getEntryControlKey()) ? this.getEntryKey() : this.getEntryControlKey();
            this.clientViewProxy.invokeControlMethod(ctlKey, SET_HEAD_FIELD_FILTER_ITEM, new Object[]{data});
        } else {
            data.put("r", 0);
            this.clientViewProxy.invokeControlMethod(this.key, SET_HEAD_FIELD_FILTER_ITEM, new Object[]{data});
        }
    }

    protected String getBillEntityNumber() {
        return ((NoCodeRefBillProp)this.getProperty()).getBillEntityNumber();
    }

    private String parseFilterString(String appId, String formId, List<?> filterrows) {
        if (filterrows == null || filterrows.isEmpty()) {
            return "";
        }
        HashMap reqData = new HashMap(10);
        HashMap payload = new HashMap(10);
        ArrayList dataItem = new ArrayList(1);
        HashMap<String, Object> plObj = new HashMap<String, Object>(10);
        plObj.put(APPID, appId);
        plObj.put("formid", formId);
        plObj.put("filterrows", filterrows);
        dataItem.add(plObj);
        payload.put("data", dataItem);
        reqData.put("data", payload);
        String rootUrl = UrlService.getDomainContextUrl();
        String apiUrl = "/nocode/v2/nocode_sys/bos_nocode_filterconfig?getFilter=true";
        String fullRequestUrl = String.format("%s%s", rootUrl, apiUrl);
        HashMap<String, String> queryStringMap = new HashMap<String, String>(0);
        queryStringMap.put(APPID, appId);
        queryStringMap.put("getFilter", "true");
        HashMap reqHeaders = new HashMap(16);
        RestApiRequest request = new RestApiRequest(fullRequestUrl, apiUrl, queryStringMap, OperationType.QUERY, HttpMethod.POST, ApiVersion.TWO, appId, "bos_nocode_filterconfig", reqData, reqHeaders, "");
        RestApiSaveParam param = new RestApiSaveParam(request);
        param.setAppNumber(appId);
        param.setFormId("bos_nocode_filterconfig");
        param.setApiVersion(ApiVersion.TWO);
        param.setUrl(apiUrl);
        param.setDataList(dataItem);
        RestApiServiceData<RestApiQueryResult> restServiceData = this.invokeRestApiPost(param);
        RestApiQueryResult queryResult = (RestApiQueryResult)restServiceData.getResponse().getData();
        Map filterMap = (Map)queryResult.getRows().get(0);
        if (filterMap != null) {
            String filter = (String)filterMap.get("filter");
            if (StringUtils.isEmpty((CharSequence)filter)) {
                return "";
            }
            return filter;
        }
        return "";
    }

    public void postBack(Object value, int rowIndex, int parentRowIndex) {
        this.beforePostBack(this.getModel(), this.getKey());
        String newValue = null;
        if (value instanceof List) {
            List valList = (List)value;
            newValue = String.join((CharSequence)",", valList);
        } else {
            newValue = (String)value;
        }
        super.postBack((Object)newValue, rowIndex, parentRowIndex);
    }
}

