/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.metadata.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.GeoPointProp;
import kd.bos.entity.property.NameVersionEntryProp;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.converter.FormMetadataConverter;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.businessfield.BillNoField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.mservice.svc.attach.IAttachmentProp;
import kd.bos.mservice.svc.picture.IPictureProp;
import kd.bos.nocode.ext.metadata.NoCodeBillEntityType;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeMulRefBillField;
import kd.bos.nocode.property.INoCodeGraphicDisplayProp;
import kd.bos.nocode.property.INoCodeRichTextProp;
import kd.bos.nocode.utils.NcEntityTypeUtil;

public class NoCodeBillEntity
extends BillEntity {
    private static final long serialVersionUID = -8150668557852523899L;

    protected MainEntityType createDataEntityType() {
        return new NoCodeBillEntityType();
    }

    public void addRefPropTypes(Map<String, Set<String>> refObjectProps) {
        super.addRefPropTypes(refObjectProps);
        this.attatchRefPropTypes2MulRefBill(refObjectProps);
    }

    private void attatchRefPropTypes2MulRefBill(Map<String, Set<String>> refObjectProps) {
        for (EntityItem item : this.entityMetadata.getItems()) {
            NoCodeMulRefBillField mulRefBillField;
            String billEntityId;
            if (!(item instanceof NoCodeMulRefBillField) || !StringUtils.isNotBlank((CharSequence)(billEntityId = NcEntityTypeUtil.getRealBillEntityId((String)(mulRefBillField = (NoCodeMulRefBillField)item).getBillEntityId())))) continue;
            boolean isRefBillOfUser = NcEntityTypeUtil.isRefBillOfUser((String)billEntityId);
            boolean isRefBillOfOrg = NcEntityTypeUtil.isRefBillOfOrg((String)billEntityId);
            ArrayList<String> allProps = new ArrayList<String>(10);
            if (!isRefBillOfUser && !isRefBillOfOrg) {
                Map content = MetadataDao.loadDesignerMetadata((String)billEntityId, (String)RequestContext.get().getLang().toString());
                if (StringUtils.isBlank((Object)content)) continue;
                FormMetadataConverter converter = new FormMetadataConverter();
                FormMetadata formMeta = (FormMetadata)converter.convertTo(content);
                for (EntityItem entityItem : formMeta.getEntityMetadata().getItems()) {
                    if (!(entityItem instanceof Field)) continue;
                    allProps.add(entityItem.getKey());
                }
            }
            Set refProps = refObjectProps.computeIfAbsent(billEntityId, k -> new HashSet(allProps.size()));
            String displayProp = mulRefBillField.getPropsDisplay();
            String[] array = displayProp.split(",");
            allProps.addAll(Arrays.asList(array));
            refProps.addAll(allProps);
        }
    }

    private boolean isValidColumn(IDataEntityProperty property) {
        return !(property instanceof BillNoField) && !(property instanceof IAttachmentProp) && !(property instanceof IPictureProp) && !(property instanceof GeoPointProp) && !(property.getParent() instanceof EntryType) && !(property instanceof INoCodeRichTextProp) && !(property instanceof NameVersionEntryProp) && !(property instanceof INoCodeGraphicDisplayProp);
    }
}

