/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.metadata.entity.field;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.DecimalProp;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.nocode.ext.form.field.NoCodeDecimalEdit;
import kd.bos.nocode.ext.metadata.entity.field.IFieldTypeChangeSupport;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeDataRangeField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeDecimalField;
import kd.bos.nocode.ext.metadata.entity.helper.FieldCreateEditorHelper;
import kd.bos.nocode.ext.property.NoCodeDecimalProp;

@DataEntityTypeAttribute(name="NoCodeAmountField")
public class NoCodeAmountField
extends DecimalField
implements IFieldTypeChangeSupport {
    private static final long serialVersionUID = 9029017915746852863L;
    private NoCodeDataRangeField dataRange;
    private String decimalDataType = "digit";
    private int decimalSlideMin;
    private int markCount;
    private double decimalStep = 1.0;
    private boolean thousandsSeparator;
    private boolean stepper = false;
    private int scale = 2;
    private boolean isFieldTypeChanged;
    private String modifyFlag;
    private String noCodeDefValue;

    @SimplePropertyAttribute(name="DecimalDataType")
    @DefaultValueAttribute(value="digit")
    public String getDecimalDataType() {
        return this.decimalDataType;
    }

    public void setDecimalDataType(String decimalDataType) {
        this.decimalDataType = decimalDataType;
    }

    @SimplePropertyAttribute
    public int getDecimalSlideMin() {
        return this.decimalSlideMin;
    }

    public void setDecimalSlideMin(int decimalSlideMin) {
        this.decimalSlideMin = decimalSlideMin;
    }

    @SimplePropertyAttribute
    public int getMarkCount() {
        return this.markCount;
    }

    public void setMarkCount(int markCount) {
        this.markCount = markCount;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="1")
    public double getDecimalStep() {
        return this.decimalStep;
    }

    public void setDecimalStep(double decimalStep) {
        this.decimalStep = decimalStep;
    }

    @SimplePropertyAttribute(name="ThousandsSeparator")
    public boolean getThousandsSeparator() {
        return this.thousandsSeparator;
    }

    public void setThousandsSeparator(boolean thousandsSeparator) {
        this.thousandsSeparator = thousandsSeparator;
    }

    @SimplePropertyAttribute(name="Stepper")
    @DefaultValueAttribute(value="false")
    public boolean getStepper() {
        return this.stepper;
    }

    public void setStepper(boolean stepper) {
        this.stepper = stepper;
    }

    @ComplexPropertyAttribute(name="DataRange")
    public NoCodeDataRangeField getDataRange() {
        return this.dataRange;
    }

    public void setDataRange(NoCodeDataRangeField dataRange) {
        this.dataRange = dataRange;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="2")
    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    protected FieldEdit createServerEditor() {
        return new NoCodeDecimalEdit();
    }

    protected DecimalProp createDynamicProperty() {
        NoCodeDecimalProp prop = new NoCodeDecimalProp();
        prop.setDecimalDataType(this.getDecimalDataType());
        prop.setThousandsSeparator(this.getThousandsSeparator());
        prop.setEnableNull(true);
        prop.setZeroShow(true);
        prop.setNoCodeDefValue(this.getNoCodeDefValue());
        prop.setCustomProperty("_FieldType_", NoCodeDecimalField.class.getSimpleName());
        prop.setDataRange(this.getDataRange());
        prop.setScale(this.getScale());
        if (Objects.nonNull(this.getDataRange())) {
            if (StringUtils.isNotEmpty((CharSequence)this.getDataRange().getMin())) {
                prop.setMin(new BigDecimal(this.getDataRange().getMin()));
                prop.setInclMin(true);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.getDataRange().getMax())) {
                prop.setMax(new BigDecimal(this.getDataRange().getMax()));
                prop.setInclMax(true);
            }
        }
        return prop;
    }

    protected void setDynamicProperty(DecimalProp prop) {
        super.setDynamicProperty(prop);
        NoCodeDecimalProp decimalProp = (NoCodeDecimalProp)prop;
        NoCodeDataRangeField dataRange = decimalProp.getDataRange();
        if (Objects.isNull(dataRange)) {
            prop.setDataScope("");
        } else {
            prop.setDataScope("[" + dataRange.getMin() + "," + dataRange.getMax() + "]");
        }
    }

    public Map<String, Object> createEditor() {
        Map editor = super.createEditor();
        editor.put("dataRange", this.getDataRange());
        editor.put("thousandsSeparator", this.getThousandsSeparator());
        editor.put("decimalStep", this.getDecimalStep());
        editor.put("stepper", this.getStepper());
        editor.put("markCount", this.getMarkCount());
        editor.put("decimalDataType", this.getDecimalDataType());
        editor.put("sc", this.getScale());
        editor.put("decimalSlideMin", this.getDecimalSlideMin());
        FieldCreateEditorHelper.setupEditor(this, editor);
        return editor;
    }

    public boolean isEnableNull() {
        return true;
    }

    public boolean isZeroShow() {
        return true;
    }

    @Override
    public boolean isFieldTypeChanged() {
        return this.isFieldTypeChanged;
    }

    @Override
    public void setFieldTypeChanged(boolean isChanged) {
        this.isFieldTypeChanged = isChanged;
    }

    @Override
    public String getModifyFlag() {
        return this.modifyFlag;
    }

    @Override
    public void setModifyFlag(String flag) {
        this.modifyFlag = flag;
    }

    @SimplePropertyAttribute
    public String getNoCodeDefValue() {
        return this.noCodeDefValue;
    }

    public void setNoCodeDefValue(String noCodeDefValue) {
        this.noCodeDefValue = noCodeDefValue;
    }
}

