/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.metadata.entity.field;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.entity.commonfield.AttachmentField;
import kd.bos.nocode.ext.form.field.NoCodeAttachmentEdit;
import kd.bos.nocode.ext.metadata.entity.field.IFieldTypeChangeSupport;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeDataRangeField;
import kd.bos.nocode.ext.metadata.entity.helper.FieldCreateEditorHelper;
import kd.bos.nocode.ext.property.NoCodeAttachmentProp;
import kd.bos.nocode.metadata.ICustomOption4FieldTree;
import kd.bos.nocode.metadata.INoCodeAttachmentUploadField;

@DataEntityTypeAttribute(name="NoCodeAttachmentUploadField")
public class NoCodeAttachmentUploadField
extends AttachmentField
implements INoCodeAttachmentUploadField,
IFieldTypeChangeSupport,
ICustomOption4FieldTree {
    private static final long serialVersionUID = -8699061836696135103L;
    private String attachmentFileType = ".doc, .docx, .xls, .xlsx, .pdf, .rar, .zip, .txt, .jpg, .jpeg, .png, .gif, .msg";
    private String attachmentDefValue = "";
    private NoCodeDataRangeField dataRange = new NoCodeDataRangeField("0", "9");
    private boolean isFieldTypeChanged;
    private String modifyFlag;

    @SimplePropertyAttribute(name="AttachmentFileType")
    @DefaultValueAttribute(value=".doc, .docx, .xls, .xlsx, .pdf, .rar, .zip, .txt, .jpg, .jpeg, .png, .gif, .msg")
    public String getAttachmentFileType() {
        return this.attachmentFileType;
    }

    public void setAttachmentFileType(String attachmentFileType) {
        this.attachmentFileType = attachmentFileType;
    }

    @ComplexPropertyAttribute(name="UploadNum")
    public NoCodeDataRangeField getDataRange() {
        return this.dataRange;
    }

    public void setDataRange(NoCodeDataRangeField dataRange) {
        this.dataRange = dataRange;
    }

    @SimplePropertyAttribute(name="UploadDefValue")
    public String getAttachmentDefValue() {
        return this.attachmentDefValue;
    }

    public void setAttachmentDefValue(String attachmentDefValue) {
        this.attachmentDefValue = attachmentDefValue;
    }

    public Map<String, Object> createEditor() {
        Map editor = super.createEditor();
        editor.put("attachmentFileType", this.getAttachmentFileType());
        editor.put("uploadNum", this.getDataRange());
        editor.put("uploadDefValue", this.getAttachmentDefValue());
        FieldCreateEditorHelper.setupEditor(this, editor);
        return editor;
    }

    protected AttachmentProp createDynamicProperty() {
        DynamicObjectType type = new DynamicObjectType(this.getKey());
        type.setAlias(this.getTableName());
        type.setDbIgnore(StringUtils.isBlank((CharSequence)this.getTableName()));
        type.setDBRouteKey(StringUtils.isNotBlank((CharSequence)this.getTableName()) ? this.entityMetadata.getDBRouteKey() : "");
        this.registerProperties(type);
        NoCodeAttachmentProp prop = new NoCodeAttachmentProp(this.getKey(), type);
        prop.setAttachmentDefValue(this.getAttachmentDefValue());
        prop.setDataRange(this.getDataRange());
        prop.setCustomProperty("_FieldType_", NoCodeAttachmentUploadField.class.getSimpleName());
        prop.setAttachmentFileType(this.getAttachmentFileType());
        return prop;
    }

    protected void setDynamicProperty(MulBasedataProp prop) {
        super.setDynamicProperty(prop);
        prop.setCompareGroupID("5");
    }

    public int getFieldDBType() {
        return -5;
    }

    @Override
    public boolean isFieldTypeChanged() {
        return this.isFieldTypeChanged;
    }

    @Override
    public void setFieldTypeChanged(boolean isChanged) {
        this.isFieldTypeChanged = isChanged;
    }

    @Override
    public String getModifyFlag() {
        return this.modifyFlag;
    }

    @Override
    public void setModifyFlag(String flag) {
        this.modifyFlag = flag;
    }

    protected FieldEdit createServerEditor() {
        NoCodeAttachmentEdit attEdit = new NoCodeAttachmentEdit();
        attEdit.setTableName(this.getTableName());
        return attEdit;
    }

    public List<ValueMapItem> getAttachmentTypeComboItems() {
        boolean FIRST_INDEX = true;
        String attachmentFileType = this.getAttachmentFileType();
        if (kd.bos.util.StringUtils.isBlank((String)attachmentFileType)) {
            return new ArrayList<ValueMapItem>(0);
        }
        return Arrays.stream(attachmentFileType.split(",")).map(e -> e.trim().substring(1)).map(e -> new ValueMapItem(kd.bos.util.StringUtils.getEmpty(), e, new LocaleString(e))).collect(Collectors.toList());
    }

    public Map<String, Object> getCustomOption() {
        HashMap<String, Object> result = new HashMap<String, Object>(10);
        result.put("AttachmentFileType", this.getAttachmentFileType());
        result.put("UploadNum", this.getDataRange());
        return result;
    }
}

