/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.metadata.entity.field;

import java.util.Map;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.nocode.ext.constant.DateFormatEnum;
import kd.bos.nocode.ext.form.field.NoCodeDateEdit;
import kd.bos.nocode.ext.form.field.NoCodeDateTimeEdit;
import kd.bos.nocode.ext.form.field.NoCodeEdit;
import kd.bos.nocode.ext.form.field.NoCodeYearEdit;
import kd.bos.nocode.ext.form.field.NoCodeYearMonthEdit;
import kd.bos.nocode.ext.metadata.entity.field.IFieldTypeChangeSupport;
import kd.bos.nocode.ext.metadata.entity.helper.FieldCreateEditorHelper;
import kd.bos.nocode.ext.property.NoCodeDateTimeProp;
import kd.bos.nocode.metadata.IDateFormatSupport;

@DataEntityTypeAttribute(name="NoCodeDateField")
public class NoCodeDateField
extends DateTimeField
implements IFieldTypeChangeSupport,
IDateFormatSupport {
    private static final long serialVersionUID = -8856105242162389L;
    private String formatType = "1";
    private boolean isFieldTypeChanged;
    private String modifyFlag;
    private String noCodeDefValue;

    public Map<String, Object> createEditor() {
        Map editor = super.createEditor();
        FieldCreateEditorHelper.setupEditor(this, editor);
        switch (this.formatType) {
            case "1": {
                editor.put("type", "date");
                break;
            }
            case "2": {
                editor.put("type", "month");
                break;
            }
            case "3": {
                editor.put("type", "year");
                break;
            }
            default: {
                editor.put("type", "datetime");
            }
        }
        return editor;
    }

    protected FieldEdit createServerEditor() {
        NoCodeEdit serverEditor;
        switch (this.formatType) {
            case "1": {
                serverEditor = new NoCodeDateEdit();
                break;
            }
            case "2": {
                serverEditor = new NoCodeYearMonthEdit();
                break;
            }
            case "3": {
                serverEditor = new NoCodeYearEdit();
                break;
            }
            default: {
                serverEditor = new NoCodeDateTimeEdit();
            }
        }
        return serverEditor;
    }

    public DateTimeProp createDynamicProperty() {
        NoCodeDateTimeProp dateTimeProp = new NoCodeDateTimeProp();
        dateTimeProp.setFormatType(this.formatType);
        dateTimeProp.setNoCodeDefValue(this.getNoCodeDefValue());
        dateTimeProp.setCustomProperty("_FieldType_", NoCodeDateField.class.getSimpleName());
        return dateTimeProp;
    }

    protected void setDynamicProperty(DateTimeProp prop) {
        super.setDynamicProperty(prop);
        if (this.isDate()) {
            prop.setRegionType(FormatTypes.Date.getValue());
        }
    }

    public String getFilterControlType() {
        String filterControlType = super.getFilterControlType();
        if (this.isDate()) {
            filterControlType = "date";
        }
        return filterControlType;
    }

    private boolean isDate() {
        return DateFormatEnum.DATE.getCode().equals(this.getFormatType());
    }

    @SimplePropertyAttribute(name="FormatType")
    @DefaultValueAttribute(value="1")
    public String getFormatType() {
        return this.formatType;
    }

    public void setFormatType(String formatType) {
        this.formatType = formatType;
    }

    @Override
    public boolean isFieldTypeChanged() {
        return this.isFieldTypeChanged;
    }

    @Override
    public void setFieldTypeChanged(boolean isChanged) {
        this.isFieldTypeChanged = isChanged;
    }

    @Override
    public String getModifyFlag() {
        return this.modifyFlag;
    }

    @Override
    public void setModifyFlag(String flag) {
        this.modifyFlag = flag;
    }

    @SimplePropertyAttribute
    public String getNoCodeDefValue() {
        return this.noCodeDefValue;
    }

    public void setNoCodeDefValue(String noCodeDefValue) {
        this.noCodeDefValue = noCodeDefValue;
    }
}

