/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.metadata.entity.field;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.cache.PromptWordCacheNew;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.form.field.FieldEdit;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.lang.Lang;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.nocode.ext.constant.DateFormatEnum;
import kd.bos.nocode.ext.form.field.NoCodeDateRangeEdit;
import kd.bos.nocode.ext.metadata.entity.field.IFieldTypeChangeSupport;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeRangeInputTextField;
import kd.bos.nocode.ext.metadata.entity.helper.FieldCreateEditorHelper;
import kd.bos.nocode.ext.property.NoCodeDateTimeProp;
import kd.bos.nocode.metadata.IDateFormatSupport;
import kd.bos.service.InteTimeZone;
import kd.bos.service.ServiceFactory;

@DataEntityTypeAttribute(name="NoCodeDateRangeField")
public class NoCodeDateRangeField
extends DateRangeField
implements IFieldTypeChangeSupport,
IDateFormatSupport {
    private static final long serialVersionUID = 4195015604879077542L;
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    private String formatType = "1";
    private NoCodeRangeInputTextField dateRangeDefValue = new NoCodeRangeInputTextField();
    private NoCodeRangeInputTextField rangeEmptyText = new NoCodeRangeInputTextField(ResManager.loadKDString((String)"\u8d77\u59cb\u65e5\u671f", (String)"NoCodeDateRangeField_0", (String)"bos-nocode-ext", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f", (String)"NoCodeDateRangeField_1", (String)"bos-nocode-ext", (Object[])new Object[0]));
    private boolean isFieldTypeChanged;
    private String modifyFlag;

    public Map<String, Object> createEditor() {
        Map editor = super.createEditor();
        if (this.isDate()) {
            editor.put("regiontype", FormatTypes.Date.getValue());
            editor.put("type", "daterange");
        } else {
            editor.put("regiontype", FormatTypes.Time.getValue());
            editor.put("type", "timerange");
        }
        editor.put("DateRangeDefValue", this.getDateRangeDefValue());
        editor.put("DateRangeEmptyText", this.getRangeEmptyText());
        FieldCreateEditorHelper.setupEditor(this, editor);
        return editor;
    }

    protected FieldEdit createServerEditor() {
        return new NoCodeDateRangeEdit();
    }

    protected DateTimeProp createDynamicProperty() {
        NoCodeDateTimeProp dateTimeProp = new NoCodeDateTimeProp();
        dateTimeProp.setFormatType(this.getFormatType());
        if (this.isDate()) {
            dateTimeProp.setFormatType(DateFormatEnum.DATE.getCode());
            dateTimeProp.setRegionType(FormatTypes.Date.getValue());
            dateTimeProp.setDisplayFormatString(YYYY_MM_DD);
        }
        return dateTimeProp;
    }

    protected void setDynamicProperty(DateTimeProp prop) {
        super.setDynamicProperty(prop);
        prop.setName(this.getStartDateFieldKey());
        prop.setAlias(this.getStartDateFieldName());
        prop.setDisplayName(NoCodeDateRangeField.joinLocaleString(this.getName(), this.getDisplayName(ResManager.loadKDString((String)".\u5f00\u59cb", (String)"NoCodeDateRangeField_0", (String)"bos-nocode-ext", (Object[])new Object[0]), "NoCodeDateRangeField_0", "bos-nocode-ext")));
        prop.setDbIgnore(StringUtils.isBlank((CharSequence)this.getStartDateFieldName()));
        prop.setRegionType(this.getRegionType());
    }

    public DynamicProperty registerProperty(DynamicObjectType dt) {
        NoCodeRangeInputTextField defValue;
        DynamicProperty property = (DynamicProperty)this.callBuilderFunc(() -> this.fieldBuilder.createDynamicProperty(), this::createDynamicProperty);
        this.setDynamicProperty((NoCodeDateTimeProp)property);
        dt.addProperty(property);
        NoCodeDateTimeProp beginDateProp = (NoCodeDateTimeProp)property;
        if (beginDateProp == null) {
            throw new NullPointerException("registerproperty error,beginDateProp is null");
        }
        beginDateProp.setRelateDateTimeRange(this.getEndDateFieldKey());
        beginDateProp.setStartDateTimeRange(true);
        this.setDynamicProperty(beginDateProp);
        beginDateProp.setCustomProperty("_FieldType_", NoCodeDateRangeField.class.getSimpleName());
        NoCodeDateTimeProp endDateProp = new NoCodeDateTimeProp();
        endDateProp.setFormatType(this.getFormatType());
        if (this.isDate()) {
            endDateProp.setFormatType(DateFormatEnum.DATE.getCode());
            endDateProp.setRegionType(FormatTypes.Date.getValue());
            endDateProp.setDisplayFormatString(YYYY_MM_DD);
        }
        endDateProp.setRelateDateTimeRange(this.getStartDateFieldKey());
        endDateProp.setName(this.getEndDateFieldKey());
        endDateProp.setAlias(this.getEndDateFieldName());
        endDateProp.setTableGroup(beginDateProp.getTableGroup());
        endDateProp.setDisplayName(NoCodeDateRangeField.joinLocaleString(this.getName(), this.getDisplayName(ResManager.loadKDString((String)".\u7ed3\u675f", (String)"NoCodeDateRangeField_1", (String)"bos-nocode-ext", (Object[])new Object[0]), "NoCodeDateRangeField_1", "bos-nocode-ext")));
        endDateProp.setDbIgnore(StringUtils.isBlank((CharSequence)this.getEndDateFieldName()));
        endDateProp.setCustomProperty("_FieldType_", NoCodeDateRangeField.class.getSimpleName());
        endDateProp.setFeatures(this.getFeatures().getValue());
        dt.registerSimpleProperty((DynamicSimpleProperty)endDateProp);
        if (this.isMustInput()) {
            endDateProp.setMustInput(this.isMustInput());
        }
        if ((defValue = this.getDateRangeDefValue()) != null) {
            beginDateProp.setNoCodeDefValue(this.getCorrectFmtDefValue(defValue.getStart()));
            endDateProp.setNoCodeDefValue(this.getCorrectFmtDefValue(defValue.getEnd()));
        }
        return beginDateProp;
    }

    private String getCorrectFmtDefValue(String defValue) {
        if (StringUtils.isBlank((CharSequence)defValue)) {
            return defValue;
        }
        if (!this.isDate()) {
            try {
                InteTimeZone.getSysTimeZone().parse(defValue, (DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
                return defValue;
            }
            catch (ParseException e) {
                try {
                    Date date = InteTimeZone.getSysTimeZone().parse(defValue, (DateFormat)new SimpleDateFormat(YYYY_MM_DD));
                    return InteTimeZone.getSysTimeZone().format(date, (DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
                }
                catch (ParseException e1) {
                    return defValue;
                }
            }
        }
        return defValue;
    }

    private static LocaleString joinLocaleString(LocaleString str1, LocaleString str2) {
        LocaleString str = new LocaleString();
        for (Map.Entry entry : str1.entrySet()) {
            String localeId = (String)entry.getKey();
            String val1 = (String)entry.getValue();
            String val2 = (String)str2.get((Object)localeId);
            val2 = StringUtils.isBlank((CharSequence)val2) ? str2.toString() : val2;
            String val = val1 + val2;
            str.put(localeId, (Object)val);
        }
        return str;
    }

    private LocaleString getDisplayName(String desc, String resId, String projectName) {
        IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
        List langs = inteService.getEnabledLang();
        LocaleString localeString = new LocaleString(ResManager.loadKDString((String)desc, (String)resId, (String)projectName, (Object[])new Object[0]));
        for (EnabledLang enabledLang : langs) {
            Lang lang = Lang.from((String)enabledLang.getNumber());
            localeString.setItem(lang.toString(), (Object)PromptWordCacheNew.getPromptWord((String)desc, (String)resId, (Lang)lang, (String)projectName, (Object[])new Object[0]));
        }
        return localeString;
    }

    @SimplePropertyAttribute(name="FormatType")
    @DefaultValueAttribute(value="NoCodeDateRangeField_3")
    public String getFormatType() {
        return this.formatType;
    }

    public void setFormatType(String formatType) {
        this.formatType = formatType;
    }

    @ComplexPropertyAttribute(name="DateRangeEmptyText")
    public NoCodeRangeInputTextField getRangeEmptyText() {
        return this.rangeEmptyText;
    }

    public void setRangeEmptyText(NoCodeRangeInputTextField rangeEmptyText) {
        this.rangeEmptyText = rangeEmptyText;
    }

    @ComplexPropertyAttribute(name="DateRangeDefValue")
    public NoCodeRangeInputTextField getDateRangeDefValue() {
        return this.dateRangeDefValue;
    }

    public void setDateRangeDefValue(NoCodeRangeInputTextField dateRangeDefValue) {
        this.dateRangeDefValue = dateRangeDefValue;
    }

    private boolean isDate() {
        return DateFormatEnum.DATE.getCode().equals(this.getFormatType());
    }

    @Override
    public boolean isFieldTypeChanged() {
        return this.isFieldTypeChanged;
    }

    @Override
    public void setFieldTypeChanged(boolean isChanged) {
        this.isFieldTypeChanged = isChanged;
    }

    @Override
    public String getModifyFlag() {
        return this.modifyFlag;
    }

    @Override
    public void setModifyFlag(String flag) {
        this.modifyFlag = flag;
    }

    @SimplePropertyAttribute
    public String getStartDateFieldKey() {
        return this.getKey() + "_startdate";
    }

    @SimplePropertyAttribute
    public String getEndDateFieldKey() {
        return this.getKey() + "_enddate";
    }
}

