/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.metadata.entity.field;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.BasedataTypeEnum;
import kd.bos.entity.property.EntityTreeNode;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.property.RefProp;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.businessfield.RefBillField;
import kd.bos.nocode.ext.form.field.NoCodeRefBillEdit;
import kd.bos.nocode.ext.metadata.entity.field.IFieldTypeChangeSupport;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeDataRangeField;
import kd.bos.nocode.ext.metadata.entity.helper.FieldCreateEditorHelper;
import kd.bos.nocode.ext.property.NoCodeRefBillProp;
import kd.bos.nocode.metadata.DataFillMap;
import kd.bos.nocode.metadata.INoCodeRefBillField;
import kd.bos.nocode.utils.NcEntityTypeUtil;

@DataEntityTypeAttribute(name="NoCodeRefBillField")
public class NoCodeRefBillField
extends RefBillField
implements IFieldTypeChangeSupport,
INoCodeRefBillField {
    private static final long serialVersionUID = 1L;
    private static final int NUMBER_OF_PER_COUNT = 20;
    private static final int NUMBER_OF_MAP = 10;
    private static final String BOS_NOCODE_EXT = "bos-nocode-ext";
    protected String billEntityName = null;
    protected String billEntityIdEx = null;
    private int multi = 0;
    protected String propsDisplay = null;
    private String defaultDisplay = ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e", (String)"NoCodeRefBillField_0", (String)"bos-nocode-ext", (Object[])new Object[0]);
    private NoCodeDataRangeField dataRange = new NoCodeDataRangeField("0", "3");
    private List<DataFillMap> dataFill = new ArrayList<DataFillMap>(10);
    private int displaySelectedForm = 1;
    private boolean isFieldTypeChanged;
    private String modifyFlag;
    private String noCodeDefValue;

    protected void setRefBillProp(RefBillProp prop) {
        if (this.getBillEntityId() == null) {
            String name = prop.getDisplayName() != null ? (String)prop.getDisplayName().getDefaultItem() : prop.getName();
            this.addBuildError(1, "BillEntityId", ResManager.loadKDString((String)"\u201c%s\u201d\u5173\u8054\u7684\u201c\u5173\u8054\u5176\u4ed6\u8868\u5355\u201d\u4e0d\u80fd\u4e3a\u7a7a", (String)"NoCodeRefBillField_1", (String)BOS_NOCODE_EXT, (Object[])new Object[]{name}));
            return;
        }
        super.setRefBillProp(prop);
    }

    public Map<String, Object> createEditor() {
        Map editor = super.createEditor();
        FieldCreateEditorHelper.setupEditor(this, editor);
        editor.put("dataRange", this.getDataRange());
        editor.put("propsDisplay", this.getPropsDisplay());
        return editor;
    }

    @SimplePropertyAttribute
    public String getBillEntityName() {
        return this.billEntityName;
    }

    public void setBillEntityName(String billEntityName) {
        this.billEntityName = billEntityName;
    }

    @JsonProperty(value="PropsDisplay")
    @SimplePropertyAttribute(name="PropsDisplay")
    public String getPropsDisplay() {
        return this.propsDisplay;
    }

    public void setPropsDisplay(String displayProperty) {
        this.propsDisplay = displayProperty;
    }

    protected FieldEdit createServerEditor() {
        return new NoCodeRefBillEdit();
    }

    protected RefBillProp createDynamicProperty() {
        NoCodeRefBillProp prop = new NoCodeRefBillProp();
        prop.setPropsDisplay(this.getPropsDisplay());
        prop.setNoCodeDefValue(this.getNoCodeDefValue());
        prop.setCustomProperty("_FieldType_", NoCodeRefBillField.class.getSimpleName());
        return prop;
    }

    protected void setClientRefBillEditor(Map<String, Object> ctlRet) {
        super.setClientRefBillEditor(ctlRet);
        ctlRet.put("type", "refbill");
        ctlRet.put("refbilltype", NcEntityTypeUtil.getRealBillEntityNumber((String)this.getBillEntityId()));
        ctlRet.put("multi", this.getMulti());
        ctlRet.put("dispSelected", this.getDisplaySelectedForm());
    }

    public String getDisplayProp() {
        if (StringUtils.isNotBlank((CharSequence)this.getPropsDisplay())) {
            return this.getPropsDisplay().split(",")[0];
        }
        return super.getDisplayProp();
    }

    protected List<Map<String, Object>> createRefBillTreeNodes(boolean isAllNode, int level) {
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>();
        if (this.getBillEntityId() == null || !isAllNode && StringUtils.isBlank((CharSequence)this.getFieldName())) {
            return cols;
        }
        MetadataReader reader = new MetadataReader();
        String number = reader.getEntityNumberById(this.getBillEntityId());
        if (StringUtils.isBlank((CharSequence)number)) {
            return cols;
        }
        List subRefProps = this.getRuntimeRefProps();
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getSubDataEntityType((String)number, (Collection)subRefProps);
        EntityItem entityItem = this.entityMetadata.getItemById(this.getParentId());
        EntityTreeNode entityTreeNode = new EntityTreeNode(this.getKey(), this.getName().toString(), entityItem instanceof EntryEntity, true, BasedataTypeEnum.BaseData, level, this.getBillEntityId());
        entityTreeNode.setFieldPropAliasEmpty(StringUtils.isBlank((CharSequence)this.getFieldName()));
        return dt.createEntityTreeNodes(entityTreeNode, false, isAllNode);
    }

    public String getEditSearchProp() {
        return this.getPropsDisplay();
    }

    public String getNumberProp() {
        if (StringUtils.isNotBlank((CharSequence)this.getPropsDisplay())) {
            return this.getPropsDisplay().split(",")[0];
        }
        return super.getNumberProp();
    }

    @SimplePropertyAttribute
    public String getBillEntityIdEx() {
        return this.billEntityIdEx;
    }

    public void setBillEntityIdEx(String billEntityIdEx) {
        this.billEntityIdEx = billEntityIdEx;
        if (StringUtils.isNotBlank((CharSequence)billEntityIdEx)) {
            String[] split = billEntityIdEx.split(",");
            this.setBillEntityId(split[split.length - 1]);
        } else {
            this.setBillEntityId(billEntityIdEx);
        }
    }

    @SimplePropertyAttribute(name="Multi")
    @DefaultValueAttribute(value="0")
    public int getMulti() {
        return this.multi;
    }

    public void setMulti(int multi) {
        this.multi = multi;
    }

    @SimplePropertyAttribute(name="DefaultDisplay")
    @DefaultValueAttribute(value="\u6682\u65e0\u6570\u636e")
    public String getDefaultDisplay() {
        return this.defaultDisplay;
    }

    @ComplexPropertyAttribute(name="DataRange")
    public NoCodeDataRangeField getDataRange() {
        return this.dataRange;
    }

    public void setDataRange(NoCodeDataRangeField dataRange) {
        this.dataRange = dataRange;
    }

    public void setDefaultDisplay(String defaultDisplay) {
        this.defaultDisplay = defaultDisplay;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=DataFillMap.class, name="DataFill")
    public List<DataFillMap> getDataFill() {
        return this.dataFill;
    }

    public boolean isMultiSelect() {
        return false;
    }

    public void setDataFill(List<DataFillMap> dataFill) {
        this.dataFill = dataFill;
    }

    public List<RefProp> getRefProps() {
        List refProps = super.getRefProps();
        if (StringUtils.isNotBlank((CharSequence)this.getPropsDisplay())) {
            for (String disProp : this.getPropsDisplay().split(",")) {
                if (refProps.stream().anyMatch(r -> r.getName().equalsIgnoreCase(disProp))) continue;
                RefProp refProp = new RefProp();
                refProp.setName(disProp);
                refProps.add(refProp);
            }
        }
        if (!this.getDataFill().isEmpty()) {
            for (DataFillMap dataFillMap : this.getDataFill()) {
                if (refProps.stream().anyMatch(r -> r.getName().equalsIgnoreCase(dataFillMap.getRefBillFieldKey()))) continue;
                RefProp refProp = new RefProp();
                refProp.setName(dataFillMap.getRefBillFieldKey());
                refProps.add(refProp);
            }
        }
        return refProps;
    }

    public String getDBDefValue() {
        return " ";
    }

    public int getFieldDBType() {
        if (this.getMulti() > 0) {
            if (this.needFieldLen() > 2000) {
                return 2011;
            }
            return -9;
        }
        return -5;
    }

    public int getFieldLen() {
        return this.needFieldLen();
    }

    protected int needFieldLen() {
        if (this.getMulti() > 0) {
            int len;
            int max = 100;
            if (this.getDataRange() != null) {
                max = Integer.parseInt(this.getDataRange().getMax());
            }
            if ((len = max * 20) < 20) {
                len = 20;
            }
            return len;
        }
        return 20;
    }

    @Override
    public boolean isFieldTypeChanged() {
        return this.isFieldTypeChanged;
    }

    @Override
    public void setFieldTypeChanged(boolean isChanged) {
        this.isFieldTypeChanged = isChanged;
    }

    @Override
    public String getModifyFlag() {
        return this.modifyFlag;
    }

    @Override
    public void setModifyFlag(String flag) {
        this.modifyFlag = flag;
    }

    @SimplePropertyAttribute(name="DisplaySelectedForm")
    @DefaultValueAttribute(value="1")
    public int getDisplaySelectedForm() {
        return this.displaySelectedForm;
    }

    public void setDisplaySelectedForm(int displaySelected) {
        this.displaySelectedForm = displaySelected;
    }

    @SimplePropertyAttribute
    public String getNoCodeDefValue() {
        return this.noCodeDefValue;
    }

    public void setNoCodeDefValue(String noCodeDefValue) {
        this.noCodeDefValue = noCodeDefValue;
    }
}

