/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.metadata.entity.field;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.nocode.ext.form.field.NoCodeComboEdit;
import kd.bos.nocode.ext.form.field.NoCodeMulComboEdit;
import kd.bos.nocode.ext.metadata.entity.field.CustomSelectContent;
import kd.bos.nocode.ext.metadata.entity.field.IFieldTypeChangeSupport;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeDataRangeField;
import kd.bos.nocode.ext.metadata.entity.field.SelectItem;
import kd.bos.nocode.ext.metadata.entity.helper.FieldCreateEditorHelper;
import kd.bos.nocode.ext.property.NoCodeComboProp;
import kd.bos.nocode.ext.property.NoCodeMulComboProp;
import kd.bos.nocode.metadata.INoCodeComboField;

@DataEntityTypeAttribute(name="NoCodeSelectItemField")
public class NoCodeSelectItemField
extends ComboField
implements IFieldTypeChangeSupport,
INoCodeComboField {
    private static final long serialVersionUID = -8366019436817595591L;
    private int selectItemType = 0;
    private CustomSelectContent customContent = new CustomSelectContent();
    private String defaultDisplay = ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e", (String)"NoCodeSelectItemField_0", (String)"bos-nocode-ext", (Object[])new Object[0]);
    private boolean searchable = true;
    private NoCodeDataRangeField dataRange = new NoCodeDataRangeField("0", "100");
    private String delimiter = "";
    private boolean isFieldTypeChanged = false;
    private String modifyFlag;
    private String noCodeDefValue;

    public boolean isMulti() {
        return 1 == this.selectItemType;
    }

    @SimplePropertyAttribute(name="SelectItemType")
    @DefaultValueAttribute(value="0")
    public int getSelectItemType() {
        return this.selectItemType;
    }

    public void setSelectItemType(int selectItemType) {
        this.selectItemType = selectItemType;
    }

    @SimplePropertyAttribute(name="Searchable")
    @DefaultValueAttribute(value="true")
    public boolean getSearchable() {
        return this.searchable;
    }

    public void setSearchable(boolean searchable) {
        this.searchable = searchable;
    }

    @SimplePropertyAttribute(name="DefaultDisplay")
    @DefaultValueAttribute(value="\u6682\u65e0\u6570\u636e")
    public String getDefaultDisplay() {
        return this.defaultDisplay;
    }

    public void setDefaultDisplay(String defaultDisplay) {
        this.defaultDisplay = defaultDisplay;
    }

    @ComplexPropertyAttribute(name="DataRange")
    public NoCodeDataRangeField getDataRange() {
        return this.dataRange;
    }

    public void setDataRange(NoCodeDataRangeField dataRange) {
        this.dataRange = dataRange;
    }

    @ComplexPropertyAttribute(name="CustomContent")
    public CustomSelectContent getCustomContent() {
        return this.customContent;
    }

    public void setCustomContent(CustomSelectContent customContent) {
        this.customContent = customContent;
    }

    protected ComboProp createDynamicProperty() {
        if (this.selectItemType == 1) {
            NoCodeMulComboProp noCodeMulComboProp = new NoCodeMulComboProp();
            noCodeMulComboProp.setMinCount(Integer.parseInt(this.dataRange.getMin()));
            noCodeMulComboProp.setMaxCount(Integer.parseInt(this.dataRange.getMax()));
            noCodeMulComboProp.setNoCodeDefValue(this.getNoCodeDefValue());
            noCodeMulComboProp.setCustomProperty("_FieldType_", NoCodeSelectItemField.class.getSimpleName());
            return noCodeMulComboProp;
        }
        NoCodeComboProp comboProp = new NoCodeComboProp();
        comboProp.setNoCodeDefValue(this.getNoCodeDefValue());
        comboProp.setCustomProperty("_FieldType_", NoCodeSelectItemField.class.getSimpleName());
        return comboProp;
    }

    protected void setDynamicProperty(ComboProp prop) {
        super.setDynamicProperty(prop);
        prop.setComboItems(this.buildComboItems(this.customContent.getOps()));
    }

    public Map<String, Object> createEditor() {
        Map editor = super.createEditor();
        FieldCreateEditorHelper.setupEditor(this, editor);
        editor.put("customContent", this.getCustomContent());
        editor.put("searchable", this.getSearchable());
        editor.put("defaultDisplay", this.getDefaultDisplay());
        editor.put("dataRange", this.getDataRange());
        if (this.selectItemType == 1) {
            editor.put("type", "mulcombo");
        }
        return editor;
    }

    public int getFieldDBType() {
        return 2011;
    }

    private List<ValueMapItem> buildComboItems(List<SelectItem> customContent) {
        return customContent.stream().map(selectItem -> new ValueMapItem(selectItem.getBgc(), selectItem.getValue(), selectItem.getLabel())).collect(Collectors.toList());
    }

    @Override
    public boolean isFieldTypeChanged() {
        return this.isFieldTypeChanged;
    }

    @Override
    public void setFieldTypeChanged(boolean isChanged) {
        this.isFieldTypeChanged = isChanged;
    }

    @Override
    public String getModifyFlag() {
        return this.modifyFlag;
    }

    @Override
    public void setModifyFlag(String flag) {
        this.modifyFlag = flag;
    }

    protected FieldEdit createServerEditor() {
        if (this.getSelectItemType() == 0) {
            return new NoCodeComboEdit();
        }
        return new NoCodeMulComboEdit();
    }

    public List<ComboItem> getItems() {
        List<SelectItem> selectItems = this.getCustomContent().getOps();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(selectItems.size());
        for (int i = 0; i < selectItems.size(); ++i) {
            SelectItem selectItem = selectItems.get(i);
            ComboItem comboItem = new ComboItem(i, selectItem.getLabel(), selectItem.getValue(), selectItem.getBgc());
            comboItems.add(comboItem);
        }
        return comboItems;
    }

    @SimplePropertyAttribute
    public String getNoCodeDefValue() {
        return this.noCodeDefValue;
    }

    public void setNoCodeDefValue(String noCodeDefValue) {
        this.noCodeDefValue = noCodeDefValue;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public List<ValueMapItem> getComboItems() {
        return this.buildComboItems(this.customContent.getOps());
    }
}

