/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.metadata.entity.field;

import java.util.Map;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.entity.property.TextProp;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.nocode.ext.form.field.NoCodeEmailEdit;
import kd.bos.nocode.ext.form.field.NoCodeTelephoneEdit;
import kd.bos.nocode.ext.form.field.NoCodeTextEdit;
import kd.bos.nocode.ext.metadata.entity.field.IFieldTypeChangeSupport;
import kd.bos.nocode.ext.metadata.entity.helper.FieldCreateEditorHelper;
import kd.bos.nocode.ext.property.NoCodeTextProp;

@DataEntityTypeAttribute(name="NoCodeTextField")
public class NoCodeTextField
extends TextField
implements IFieldTypeChangeSupport {
    private static final long serialVersionUID = -3148987663239981039L;
    public static final String TEXT_VALID_TYPE_PWD = "pwd";
    protected static final String TEXT_VALID_TYPE_PHONE = "phone";
    protected static final String TEXT_VALID_TYPE_EMAIL = "email";
    protected static final String TEXT_VALID_TYPE_URL = "url";
    protected static final String TEXT_VALID_TYPE_IDCARD = "idcard";
    private String textValidType = "none";
    private String scanMob = "all";
    private boolean allowChange = false;
    private int maxLength = 400;
    private String dataMasking;
    private boolean isFieldTypeChanged = false;
    private String modifyFlag;
    private String noCodeDefValue;

    @SimplePropertyAttribute(name="AllowChange")
    @DefaultValueAttribute(value="false")
    public boolean getAllowChange() {
        return this.allowChange;
    }

    public void setAllowChange(boolean allowChange) {
        this.allowChange = allowChange;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="none")
    public String getTextValidType() {
        return this.textValidType;
    }

    public void setTextValidType(String textValidType) {
        this.textValidType = textValidType;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="all")
    public String getScanMob() {
        return this.scanMob;
    }

    public void setScanMob(String scanMob) {
        this.scanMob = scanMob;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="400")
    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int value) {
        this.maxLength = value;
    }

    public boolean isPhone() {
        return TEXT_VALID_TYPE_PHONE.equalsIgnoreCase(this.getTextValidType());
    }

    public boolean isEMail() {
        return TEXT_VALID_TYPE_EMAIL.equalsIgnoreCase(this.getTextValidType());
    }

    public boolean isUrl() {
        return TEXT_VALID_TYPE_URL.equalsIgnoreCase(this.getTextValidType());
    }

    public boolean isIdCard() {
        return TEXT_VALID_TYPE_IDCARD.equalsIgnoreCase(this.getTextValidType());
    }

    public boolean isPassword() {
        return TEXT_VALID_TYPE_PWD.equalsIgnoreCase(this.getTextValidType());
    }

    @SimplePropertyAttribute(name="DataMasking")
    public String getDataMasking() {
        return this.dataMasking;
    }

    public void setDataMasking(String dataMasking) {
        this.dataMasking = dataMasking;
    }

    public Map<String, Object> createEditor() {
        Map editor = super.createEditor();
        if (this.isPhone()) {
            editor.put("type", "telephone");
        } else if (this.isEMail()) {
            editor.put("type", TEXT_VALID_TYPE_EMAIL);
        } else if (this.isIdCard()) {
            editor.put("type", TEXT_VALID_TYPE_IDCARD);
        } else if (this.isUrl()) {
            editor.put("type", TEXT_VALID_TYPE_URL);
        }
        FieldCreateEditorHelper.setupEditor(this, editor);
        return editor;
    }

    protected FieldEdit createServerEditor() {
        if (this.isPhone()) {
            return new NoCodeTelephoneEdit();
        }
        if (this.isEMail()) {
            return new NoCodeEmailEdit();
        }
        NoCodeTextEdit edit = new NoCodeTextEdit();
        edit.setSensitiveInfo(this.isSensitiveInfo());
        return edit;
    }

    public TextProp createDynamicProperty() {
        NoCodeTextProp noCodeTextProp = new NoCodeTextProp();
        noCodeTextProp.setTextValidType(this.textValidType);
        noCodeTextProp.setPassword(this.isPassword());
        noCodeTextProp.setDataMasking(this.getDataMasking());
        noCodeTextProp.setNoCodeDefValue(this.getNoCodeDefValue());
        noCodeTextProp.setCustomProperty("_FieldType_", NoCodeTextField.class.getSimpleName());
        return noCodeTextProp;
    }

    @Override
    public boolean isFieldTypeChanged() {
        return this.isFieldTypeChanged;
    }

    @Override
    public void setFieldTypeChanged(boolean isChanged) {
        this.isFieldTypeChanged = isChanged;
    }

    @Override
    public String getModifyFlag() {
        return this.modifyFlag;
    }

    @Override
    public void setModifyFlag(String flag) {
        this.modifyFlag = flag;
    }

    @SimplePropertyAttribute
    public String getNoCodeDefValue() {
        return this.noCodeDefValue;
    }

    public void setNoCodeDefValue(String noCodeDefValue) {
        this.noCodeDefValue = noCodeDefValue;
    }
}

