/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.metadata.entity.filter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.privacy.PrivacyCenterUtils;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.property.TextProp;
import kd.bos.lang.Lang;
import kd.bos.metadata.entity.businessfield.OrgField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.EmailField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeAttachmentUploadField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeBillNoField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeCreateDateField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeCreatorField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeDateField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeDateRangeField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeDecimalField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeGraphicDisplayField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeImageUploadField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeModifierField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeModifyDateField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeMulRefBillField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeRefBillField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeRichTextField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeSelectItemField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeTextAreaField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeTextField;
import kd.bos.nocode.ext.metadata.entity.filter.CompareType;
import kd.bos.nocode.ext.metadata.entity.filter.NoCodeFilterMetadata;
import kd.bos.nocode.ext.property.NoCodeAttachmentProp;
import kd.bos.nocode.ext.property.NoCodeCreatorProp;
import kd.bos.nocode.ext.property.NoCodeGraphicDisplayProp;
import kd.bos.nocode.ext.property.NoCodeModifierProp;
import kd.bos.nocode.ext.property.NoCodeMulRefBillProp;
import kd.bos.nocode.ext.property.NoCodeRefBillProp;
import kd.bos.nocode.ext.property.NoCodeRichTextProp;
import kd.bos.nocode.ext.property.NoCodeTextAreaProp;
import kd.bos.nocode.property.INoCodeRefBillProp;

public class CompareGroupMapper {
    private static final Map<Class<? extends IFieldHandle>, String> MAPPER = new HashMap<Class<? extends IFieldHandle>, String>(16);
    private static final Map<Class<? extends Field<?>>, String> FIELD_MAPPER = new HashMap(16);

    private CompareGroupMapper() {
    }

    public static String getCompareGroupId(IDataEntityProperty property) {
        if (PrivacyCenterUtils.isDesensitizeField((IDataEntityProperty)property, (String)Lang.get().toString(), (String)"LIST")) {
            return "";
        }
        if (PrivacyCenterUtils.isEncryptField((IDataEntityProperty)property)) {
            return "13";
        }
        Class<?> propClass = property.getClass();
        if (property instanceof NoCodeCreatorProp || property instanceof NoCodeModifierProp || CompareGroupMapper.isUserProp(property)) {
            return "0,12,15,5,7";
        }
        if (CompareGroupMapper.isOrgProp(property)) {
            return "0,12,15,5,17";
        }
        if (MAPPER.containsKey(propClass)) {
            return MAPPER.get(propClass);
        }
        for (Map.Entry<Class<? extends IFieldHandle>, String> entry : MAPPER.entrySet()) {
            Class<? extends IFieldHandle> key = entry.getKey();
            String value = entry.getValue();
            if (!key.isAssignableFrom(propClass)) continue;
            return value;
        }
        return "";
    }

    public static Map<String, List<CompareType>> getCompareTypes() {
        HashMap<String, List<CompareType>> resultMap = new HashMap<String, List<CompareType>>(16);
        FIELD_MAPPER.forEach((key, value) -> resultMap.put(key.getSimpleName().toLowerCase(), NoCodeFilterMetadata.get().getCompareTypes((String)value)));
        return resultMap;
    }

    public static Map<String, Object> getCompareTypesForQueryResult() {
        Map<String, List<CompareType>> compareTypes = CompareGroupMapper.getCompareTypes();
        return compareTypes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> NoCodeFilterMetadata.get().getCompareTypeDTOList((List)e.getValue())));
    }

    private static boolean isUserProp(IDataEntityProperty property) {
        return property instanceof INoCodeRefBillProp && "bos_user".equalsIgnoreCase(((INoCodeRefBillProp)property).getBillEntityNumber());
    }

    private static boolean isOrgProp(IDataEntityProperty property) {
        return property instanceof INoCodeRefBillProp && "bos_adminorg".equalsIgnoreCase(((INoCodeRefBillProp)property).getBillEntityNumber());
    }

    static {
        MAPPER.put(TextProp.class, "0,13,1,5");
        MAPPER.put(DecimalProp.class, "0,2,5,8");
        MAPPER.put(BigIntProp.class, "0,2,5,8");
        MAPPER.put(ComboProp.class, "0,10,3,5");
        MAPPER.put(DateTimeProp.class, "0,11,4,5,6");
        MAPPER.put(PictureProp.class, "0,14,1,5");
        MAPPER.put(NoCodeMulRefBillProp.class, "0,12,15,5");
        MAPPER.put(NoCodeRefBillProp.class, "0,12,15,5");
        MAPPER.put(NoCodeRichTextProp.class, "5");
        MAPPER.put(NoCodeGraphicDisplayProp.class, "5");
        MAPPER.put(NoCodeAttachmentProp.class, "5");
        MAPPER.put(NoCodeTextAreaProp.class, "0,16,5");
        FIELD_MAPPER.put(NoCodeTextField.class, "0,13,1,5");
        FIELD_MAPPER.put(NoCodeTextAreaField.class, "0,16,5");
        FIELD_MAPPER.put(NoCodeDecimalField.class, "0,2,5,8");
        FIELD_MAPPER.put(NoCodeSelectItemField.class, "0,10,3,5");
        FIELD_MAPPER.put(NoCodeMulRefBillField.class, "0,12,15,5");
        FIELD_MAPPER.put(NoCodeRefBillField.class, "0,12,15,5");
        FIELD_MAPPER.put(NoCodeDateField.class, "0,11,4,5,6");
        FIELD_MAPPER.put(NoCodeDateRangeField.class, "0,11,4,5,6");
        FIELD_MAPPER.put(NoCodeImageUploadField.class, "0,14,1,5");
        FIELD_MAPPER.put(NoCodeAttachmentUploadField.class, "5");
        FIELD_MAPPER.put(TextField.class, "0,13,1,5");
        FIELD_MAPPER.put(MuliLangTextField.class, "0,13,1,5");
        FIELD_MAPPER.put(EmailField.class, "0,13,1,5");
        FIELD_MAPPER.put(OrgField.class, "0,12,15,5,17");
        FIELD_MAPPER.put(ComboField.class, "0,10,3,5");
        FIELD_MAPPER.put(NoCodeRichTextField.class, "5");
        FIELD_MAPPER.put(NoCodeGraphicDisplayField.class, "5");
        FIELD_MAPPER.put(NoCodeBillNoField.class, "0,13,1,5");
        FIELD_MAPPER.put(NoCodeCreateDateField.class, "0,11,4,5,6");
        FIELD_MAPPER.put(NoCodeModifyDateField.class, "0,11,4,5,6");
        FIELD_MAPPER.put(NoCodeCreatorField.class, "0,12,15,5,7");
        FIELD_MAPPER.put(NoCodeModifierField.class, "0,12,15,5,7");
    }
}

