/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.metadata.entity.filter;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextAreaProp;
import kd.bos.nocode.ext.metadata.entity.filter.pojo.FilterItem;
import kd.bos.nocode.ext.metadata.entity.filter.pojo.FilterValue;
import kd.bos.nocode.ext.property.NoCodeComboProp;
import kd.bos.nocode.ext.property.NoCodeMulComboProp;
import kd.bos.nocode.ext.property.NoCodeProp;
import kd.bos.nocode.ext.property.NoCodeTextProp;
import kd.bos.nocode.metadata.IDateFormatSupport;
import kd.bos.nocode.metadata.IDecimalFormatSupport;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.URLCodecUtils;
import kd.bos.orm.util.CollectionUtils;

public abstract class FilterBuilderUtils {
    public static final String FIELD_NAME = "fieldName";
    public static final String FIELD_TYPE = "fieldType";
    public static final String COMPARE_TYPE = "compareType";
    public static final String VALUE = "value";
    public static final String FIELD_VALUE = "fieldValue";
    private static final String LABEL = "label";
    private static final String TYPE = "type";

    public static String valueList2String(List<FilterValue> valueList) {
        if (CollectionUtils.isEmpty(valueList)) {
            return "";
        }
        return valueList.stream().map(FilterValue::getFieldValue).filter(e -> Objects.nonNull(e) && StringUtils.isNotBlank((CharSequence)e.toString())).map(Object::toString).collect(Collectors.joining(","));
    }

    public static String valueList2String(String fieldType, List<FilterValue> valueList) {
        if (CollectionUtils.isEmpty(valueList)) {
            return "";
        }
        return valueList.stream().map(e -> {
            Object fieldValue = e.getFieldValue();
            String label = e.getLabel();
            if (fieldValue == null) {
                return null;
            }
            if ("text".equals(fieldType)) {
                fieldValue = fieldValue.toString().replace("\r\n", "").replace("\n", "");
            } else if (!"textarea".equals(fieldType)) {
                fieldValue = fieldValue.toString().replace("\r\n", ",").replace("\n", ",");
            }
            if ("combo".equals(fieldType) && label != null) {
                fieldValue = Arrays.stream(fieldValue.toString().split(",")).filter(StringUtils::isNotBlank).map(URLCodecUtils::decode).map(URLCodecUtils::encode).sorted().map(URLCodecUtils::decode).collect(Collectors.joining(","));
            }
            return fieldValue;
        }).filter(e -> Objects.nonNull(e) && StringUtils.isNotBlank((CharSequence)e.toString())).map(Object::toString).collect(Collectors.joining(","));
    }

    public static String valueList2String(IDataEntityProperty fieldProp, List<FilterValue> valueList) {
        if (CollectionUtils.isEmpty(valueList)) {
            return "";
        }
        String valueStr = valueList.stream().map(e -> {
            Object fieldValue = e.getFieldValue();
            String label = e.getLabel();
            if (label != null && label.startsWith(NcEntityTypeUtil.getDataTypeComboCap()) && !(fieldProp instanceof NoCodeComboProp) && fieldValue != null) {
                fieldValue = URLCodecUtils.decode((String)((String)fieldValue));
            } else if (fieldProp instanceof NoCodeComboProp && label != null && label.startsWith("[") && !label.startsWith(NcEntityTypeUtil.getDataTypeComboCap()) && fieldValue != null) {
                String fieldValueStr = fieldValue.toString().replace("\r\n", ",").replace("\n", ",");
                if (fieldProp instanceof NoCodeMulComboProp) {
                    fieldValue = Arrays.stream(fieldValueStr.split(",")).filter(StringUtils::isNotBlank).map(URLCodecUtils::decode).map(URLCodecUtils::encode).sorted().collect(Collectors.joining(","));
                } else {
                    fieldValueStr = URLCodecUtils.decode((String)fieldValueStr);
                    fieldValue = URLCodecUtils.encode((String)fieldValueStr);
                }
            } else if (fieldProp instanceof IDecimalFormatSupport && label != null && label.startsWith(NcEntityTypeUtil.getDataTypeNumberCap())) {
                fieldValue = ((IDecimalFormatSupport)fieldProp).getOriginalValue(fieldValue);
            }
            return fieldValue;
        }).filter(e -> Objects.nonNull(e) && StringUtils.isNotBlank((CharSequence)e.toString())).map(Object::toString).collect(Collectors.joining(","));
        if (fieldProp instanceof NoCodeTextProp || fieldProp instanceof MuliLangTextProp) {
            valueStr = valueStr.replace("\r\n", "").replace("\n", "");
        } else if (!(fieldProp instanceof TextAreaProp)) {
            valueStr = valueStr.replace("\r\n", ",").replace("\n", ",");
        }
        if (fieldProp instanceof NoCodeProp) {
            if (fieldProp instanceof IDateFormatSupport) {
                return ((IDateFormatSupport)fieldProp).getFormattedValue((Object)valueStr);
            }
            Object value = ((NoCodeProp)fieldProp).tryConvertValue(valueStr);
            return value == null ? "" : value.toString();
        }
        if (fieldProp instanceof BigIntProp) {
            try {
                return new BigDecimal(valueStr).toPlainString();
            }
            catch (Exception e2) {
                return "";
            }
        }
        return valueStr;
    }

    public static List<FilterItem> convert(List<Map<String, Object>> sources) {
        return sources.stream().map(FilterBuilderUtils::convert).collect(Collectors.toList());
    }

    public static FilterItem convert(Map<String, Object> source) {
        FilterItem filterItem = new FilterItem();
        filterItem.setFieldName((String)source.get(FIELD_NAME));
        filterItem.setFieldType((String)source.get(FIELD_TYPE));
        filterItem.setCompareType((String)source.get(COMPARE_TYPE));
        List<Map<String, Object>> filterValues = FilterBuilderUtils.getValueList(source.get(VALUE));
        filterItem.setValue(FilterBuilderUtils.convertFilterValues(filterValues));
        return filterItem;
    }

    public static List<FilterValue> convertFilterValues(List<Map<String, Object>> sources) {
        return sources.stream().map(FilterBuilderUtils::convertFilterValue).collect(Collectors.toList());
    }

    public static FilterValue convertFilterValue(Map<String, Object> source) {
        FilterValue filterValue = new FilterValue();
        filterValue.setLabel((String)source.get(LABEL));
        filterValue.setType((String)source.get(TYPE));
        filterValue.setFieldValue(source.get(FIELD_VALUE));
        return filterValue;
    }

    public static List<Map<String, Object>> getValueList(Object value) {
        List valueList;
        if (value instanceof String) {
            value = ((String)value).replace("\n", "\\n");
            valueList = SerializationUtils.fromJsonStringToList((String)((String)value), Object.class);
        } else {
            valueList = (List)value;
        }
        return valueList;
    }
}

