/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.metadata.entity.filter;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.nocode.ext.metadata.entity.filter.CompareCategory;
import kd.bos.nocode.ext.metadata.entity.filter.CompareType;
import kd.bos.nocode.ext.metadata.entity.filter.CompareTypeDto;

public class NoCodeFilterMetadata {
    private static final String CLONE_NOT_SUPPORTED_EXCEPTION_S = "CloneNotSupportedException:%s";
    private static NoCodeFilterMetadata filterMetadataF;
    private final List<CompareCategory> compareCategories = new ArrayList<CompareCategory>(10);

    public static synchronized NoCodeFilterMetadata getFromXml() {
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(NoCodeFilterMetadata.class));
        dts.add(OrmUtils.getDataEntityType(CompareCategory.class));
        dts.add(OrmUtils.getDataEntityType(CompareType.class));
        DcxmlSerializer ser = new DcxmlSerializer(dts);
        ser.getBinder().setLCId(Lang.zh_CN.toString());
        URL url = NoCodeFilterMetadata.class.getResource("/filter/NoCodeFilterMetadata.xml");
        return (NoCodeFilterMetadata)ser.deserialize(url, null);
    }

    public static synchronized NoCodeFilterMetadata get() {
        NoCodeFilterMetadata localFilterMetadata = filterMetadataF;
        if (localFilterMetadata == null) {
            filterMetadataF = localFilterMetadata = NoCodeFilterMetadata.getFromXml();
        }
        return localFilterMetadata;
    }

    public List<CompareType> getCompareTypes(String compareGroupId) {
        String[] groupIds;
        ArrayList<CompareType> list = new ArrayList<CompareType>();
        block2: for (String groupId : groupIds = compareGroupId.split(",")) {
            if (StringUtils.isBlank((CharSequence)groupId)) continue;
            int intGroupId = Integer.parseInt(groupId);
            for (CompareCategory cc : this.compareCategories) {
                if (!groupId.equalsIgnoreCase(cc.getId())) continue;
                try {
                    CompareCategory compareCategory = (CompareCategory)cc.clone();
                    for (CompareType compareType : compareCategory.getCompareTypes()) {
                        compareType.setGroupId(intGroupId);
                    }
                    list.addAll(compareCategory.getCompareTypes());
                    continue block2;
                }
                catch (CloneNotSupportedException e) {
                    throw new KDException((Throwable)e, new ErrorCode(CLONE_NOT_SUPPORTED_EXCEPTION_S, "CompareCategory not support clone!"), new Object[0]);
                }
            }
        }
        return list;
    }

    public List<CompareTypeDto> getCompareTypeDTOList(List<CompareType> compareTypes) {
        ArrayList<CompareTypeDto> compareTypeDtos = new ArrayList<CompareTypeDto>(10);
        for (CompareType compareType : compareTypes) {
            CompareTypeDto compareTypeDto = new CompareTypeDto(compareType.getId(), compareType.getName(), compareType.getInputCtlType());
            compareTypeDtos.add(compareTypeDto);
        }
        return compareTypeDtos;
    }

    public CompareType getCompareTypeById(String compareTypeId) {
        for (CompareCategory cc : this.compareCategories) {
            try {
                CompareCategory compareCategory = (CompareCategory)cc.clone();
                for (CompareType type : compareCategory.getCompareTypes()) {
                    if (!type.getId().equals(compareTypeId)) continue;
                    return type;
                }
            }
            catch (CloneNotSupportedException e) {
                throw new KDException((Throwable)e, new ErrorCode(CLONE_NOT_SUPPORTED_EXCEPTION_S, "CompareCategory not support clone!"), new Object[0]);
            }
        }
        return null;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=CompareCategory.class)
    public List<CompareCategory> getCompareCategories() {
        return this.compareCategories;
    }
}

