/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.metadata.entity.filter.formula.processor;

import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterField;
import kd.bos.exception.KDBizException;
import kd.bos.nocode.ext.metadata.entity.filter.CompareType;
import kd.bos.nocode.ext.metadata.entity.filter.NoCodeFilterMetadataProcessor;
import kd.bos.nocode.ext.metadata.entity.filter.pojo.FilterValue;
import kd.bos.nocode.ext.property.NoCodeDateTimeProp;
import kd.bos.nocode.utils.DateTimeUtils;
import kd.bos.orm.util.CollectionUtils;

public class DateRangeProcessor
implements NoCodeFilterMetadataProcessor {
    public static final int VALUE_LIST_LENGTH = 2;
    public static final String BETWEEN_FORMAT = "(%s >= '%s' AND %s <= '%s')";
    public static final String NOT_BETWEEN_FORMAT = "(%s < '%s' OR %s > '%s')";
    private static final String BETWEEN = "BETWEEN";

    @Override
    public String process(String fieldName, FilterField filterField, CompareType compareType, List<FilterValue> valueList) {
        String endDateStr;
        if (CollectionUtils.isEmpty(valueList) || valueList.size() < 2) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\u5fc5\u987b\u63d0\u4f9b\u4e24\u4e2a\u503c", (String)"DateRangeProcessor_0", (String)"bos-nocode-ext", (Object[])new Object[0]));
        }
        String startDateStr = (String)valueList.get(0).getFieldValue();
        if (StringUtils.isBlank((CharSequence)startDateStr)) {
            startDateStr = "1970-01-01";
        }
        if (StringUtils.isBlank((CharSequence)(endDateStr = (String)valueList.get(1).getFieldValue()))) {
            endDateStr = "9999-12-31";
        }
        NoCodeDateTimeProp dateTimeProp = (NoCodeDateTimeProp)filterField.getFieldProp();
        Date endDate = this.toDate(dateTimeProp, endDateStr);
        LocalDateTime maxLocalDateTime = DateTimeUtils.getMaxLocalDateTime((Date)endDate, (String)endDateStr);
        String endDayMaxTimeStr = maxLocalDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        return String.format(this.getFormatStr(compareType), fieldName, startDateStr, fieldName, endDayMaxTimeStr);
    }

    private Date toDate(NoCodeDateTimeProp dateTimeProp, String dateStr) {
        try {
            return dateTimeProp.getDateFormat().parse(dateStr);
        }
        catch (ParseException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u9519\u8bef", (String)"DateRangeProcessor_1", (String)"bos-nocode-ext", (Object[])new Object[0]));
        }
    }

    private String getFormatStr(CompareType compareType) {
        if (BETWEEN.equalsIgnoreCase(compareType.getOperate())) {
            return BETWEEN_FORMAT;
        }
        return NOT_BETWEEN_FORMAT;
    }
}

