/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.metadata.entity.filter.formula.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.nocode.ext.metadata.entity.filter.CompareType;
import kd.bos.nocode.ext.metadata.entity.filter.EnumOpValueType;
import kd.bos.nocode.ext.metadata.entity.filter.NoCodeFilterMetadataProcessor;
import kd.bos.nocode.ext.metadata.entity.filter.pojo.FilterValue;
import kd.bos.nocode.ext.property.NoCodeAttachmentProp;
import kd.bos.nocode.ext.property.NoCodeDecimalProp;
import kd.bos.nocode.ext.property.NoCodeMulRefBillProp;
import kd.bos.nocode.ext.property.NoCodeRefBillProp;
import org.apache.commons.collections4.CollectionUtils;

public class EnumEqProcessor
implements NoCodeFilterMetadataProcessor {
    @Override
    public String process(String fieldName, FilterField filterField, CompareType compareType, List<FilterValue> valueList) {
        boolean isNumber = filterField.getFieldProp() instanceof DecimalProp;
        if (CollectionUtils.isEmpty(valueList) && !isNumber) {
            return String.format("(%s = null OR %s = '' OR %s = ' ')", fieldName, fieldName, fieldName);
        }
        if (CollectionUtils.isEmpty(valueList) && isNumber) {
            return String.format("(%s = null)", fieldName);
        }
        Map type2List = valueList.stream().collect(Collectors.groupingBy(FilterValue::getType, Collectors.toList()));
        List normalValueList = type2List.getOrDefault(EnumOpValueType.normal.toString(), new ArrayList(0));
        List realValueList = normalValueList.stream().map(FilterValue::getFieldValue).map(String.class::cast).collect(Collectors.toList());
        boolean hasAllKey = type2List.containsKey(EnumOpValueType.all.toString());
        boolean hasEmptyKey = type2List.containsKey(EnumOpValueType.empty.toString());
        if (hasAllKey) {
            return "";
        }
        StringJoiner joiner = new StringJoiner(" OR ", "(", ")");
        if (hasEmptyKey) {
            joiner.add(String.format("(%s = null OR %s = '' OR %s = ' ')", fieldName, fieldName, fieldName));
        }
        if (CollectionUtils.isEmpty(realValueList)) {
            return joiner.toString();
        }
        if (filterField.getSrcFieldProp() instanceof NoCodeAttachmentProp && !(filterField.getFieldProp() instanceof NoCodeAttachmentProp)) {
            joiner.add(String.format("(attachmentFieldEnumEqFunc(%s, \"%s\"))", fieldName, String.join((CharSequence)",", realValueList)));
        } else if (filterField.getFieldProp() instanceof PictureProp) {
            for (String name : realValueList) {
                joiner.add(String.format("(%s like '%s')", fieldName, name));
            }
        } else if (filterField.getFieldProp() instanceof NoCodeDecimalProp) {
            for (String name : realValueList) {
                joiner.add(String.format("(%s = %s)", fieldName, name));
            }
        } else if (filterField.getFieldProp() instanceof NoCodeRefBillProp) {
            for (String name : realValueList) {
                joiner.add(String.format("(%s = '%s')", fieldName + ".id", name));
            }
        } else if (filterField.getFieldProp() instanceof NoCodeMulRefBillProp) {
            for (String name : realValueList) {
                joiner.add(String.format("(%s = '%s')", fieldName + ".id", name));
            }
        } else {
            for (String name : realValueList) {
                joiner.add(String.format("(%s = '%s')", fieldName, name));
            }
        }
        return joiner.toString();
    }
}

