/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.metadata.entity.filter.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.PictureProp;
import kd.bos.nocode.ext.metadata.entity.filter.CompareType;
import kd.bos.nocode.ext.metadata.entity.filter.EnumOpValueType;
import kd.bos.nocode.ext.metadata.entity.filter.NoCodeFilterMetadataProcessor;
import kd.bos.nocode.ext.metadata.entity.filter.pojo.FilterValue;
import org.apache.commons.collections4.CollectionUtils;

public class EnumEqProcessor
implements NoCodeFilterMetadataProcessor {
    @Override
    public String process(String fieldName, FilterField filterField, CompareType compareType, List<FilterValue> valueList) {
        if (CollectionUtils.isEmpty(valueList)) {
            return String.format("(%s EQ )", fieldName);
        }
        Map type2List = valueList.stream().collect(Collectors.groupingBy(FilterValue::getType, Collectors.toList()));
        List normalValueList = type2List.getOrDefault(EnumOpValueType.normal.toString(), new ArrayList(0));
        List fieldValueList = normalValueList.stream().map(FilterValue::getFieldValue).map(String.class::cast).collect(Collectors.toList());
        boolean hasAllKey = type2List.containsKey(EnumOpValueType.all.toString());
        boolean hasEmptyKey = type2List.containsKey(EnumOpValueType.empty.toString());
        if (hasAllKey) {
            return "";
        }
        StringJoiner joiner = new StringJoiner(" OR ", "(", ")");
        if (hasEmptyKey) {
            joiner.add(String.format("%s EQ ", fieldName));
        }
        if (CollectionUtils.isEmpty(fieldValueList)) {
            return joiner.toString();
        }
        if (filterField.getFieldProp() instanceof PictureProp) {
            for (String name : fieldValueList) {
                joiner.add(String.format("(%s CS '%s')", fieldName, name));
            }
        } else {
            for (String name : fieldValueList) {
                joiner.add(String.format("%s EQ '%s'", fieldName, name));
            }
        }
        return joiner.toString();
    }
}

