/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.metadata.entity.filter.wf.processor;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterField;
import kd.bos.exception.KDBizException;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.ext.metadata.entity.filter.CompareType;
import kd.bos.nocode.ext.metadata.entity.filter.NoCodeFilterMetadataProcessor;
import kd.bos.nocode.ext.metadata.entity.filter.pojo.FilterValue;
import kd.bos.nocode.utils.DateTimeUtils;
import kd.bos.orm.util.CollectionUtils;

public class DateRangeProcessor
implements NoCodeFilterMetadataProcessor {
    public static final int VALUE_LIST_LENGTH = 2;
    public static final String BETWEEN_FORMAT = "('%s' >= '%s' AND '%s' <= '%s')";
    public static final String NOT_BETWEEN_FORMAT = "('%s' < '%s' OR '%s' > '%s')";
    private static final String BETWEEN = "BETWEEN";

    @Override
    public String process(String fieldName, FilterField filterField, CompareType compareType, List<FilterValue> valueList) {
        String endDateStr;
        String startDateStr;
        if (CollectionUtils.isEmpty(valueList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"DateRangeProcessor_2", (String)"bos-nocode-ext", (Object[])new Object[0]));
        }
        if (valueList.size() == 1) {
            valueList.add(valueList.get(0));
        }
        if (StringUtils.isBlank((CharSequence)(startDateStr = (String)valueList.get(0).getFieldValue()))) {
            startDateStr = "1970-01-01";
        }
        if (StringUtils.isBlank((CharSequence)(endDateStr = (String)valueList.get(1).getFieldValue()))) {
            endDateStr = "9999-12-31";
        }
        Matcher matcher = WfConsts.varPattern.matcher(endDateStr);
        String endDayMaxTimeStr = endDateStr;
        if (!matcher.find()) {
            Date endDate = this.toDate(endDateStr);
            LocalDateTime maxLocalDateTime = DateTimeUtils.getMaxLocalDateTime((Date)endDate, (String)endDateStr);
            endDayMaxTimeStr = maxLocalDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        return String.format(this.getFormatStr(compareType), fieldName, startDateStr, fieldName, endDayMaxTimeStr);
    }

    private Date toDate(String dateStr) {
        try {
            return DateTimeUtils.loopParse((String)dateStr);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u9519\u8bef", (String)"DateRangeProcessor_1", (String)"bos-nocode-ext", (Object[])new Object[0]));
        }
    }

    private String getFormatStr(CompareType compareType) {
        if (BETWEEN.equalsIgnoreCase(compareType.getOperate())) {
            return BETWEEN_FORMAT;
        }
        return NOT_BETWEEN_FORMAT;
    }
}

