/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.metadata.entity.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.nocode.ext.constant.RegExpEnum;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeMulRefBillField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeSelectItemField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeTextField;

public class ValidteRulesBuilder {
    private static final String RULES = "rules";
    private static final String TYPE = "type";
    private static final String MESSAGE = "message";
    private static final String REQUIRED = "required";
    private static final String PATTERN = "pattern";

    private ValidteRulesBuilder() {
    }

    public static void build(Field<?> field, Map<String, Object> editor) {
        ValidteRulesBuilder.buildPattern(field, editor);
    }

    private static JSONArray getOrCreateRules(Map<String, Object> editor) {
        return (JSONArray)editor.computeIfAbsent(RULES, k -> new JSONArray());
    }

    private static String getRuleType(Field<?> field) {
        if (field instanceof DateTimeField) {
            return "date";
        }
        if (field instanceof DateRangeField || field instanceof NoCodeMulRefBillField && ((NoCodeMulRefBillField)field).getMulti() > 0) {
            return "array";
        }
        if (field instanceof IntegerField) {
            return "integer";
        }
        if (field instanceof NoCodeSelectItemField && ((NoCodeSelectItemField)field).isMulti()) {
            return "array";
        }
        return "string";
    }

    private static void buildRequired(Field<?> field, Map<String, Object> editor) {
        JSONArray rules = ValidteRulesBuilder.getOrCreateRules(editor);
        JSONObject rule = new JSONObject();
        rule.put(REQUIRED, (Object)true);
        rule.put(TYPE, (Object)ValidteRulesBuilder.getRuleType(field));
        rule.put(MESSAGE, (Object)ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"ValidteRulesBuilder_0", (String)"bos-nocode-ext", (Object[])new Object[0]));
        rules.add((Object)rule);
    }

    private static void buildPattern(Field<?> field, Map<String, Object> editor) {
        if (field instanceof NoCodeTextField) {
            if (((NoCodeTextField)field).isUrl()) {
                JSONArray rules = ValidteRulesBuilder.getOrCreateRules(editor);
                JSONObject rule = new JSONObject();
                rule.put(TYPE, (Object)ValidteRulesBuilder.getRuleType(field));
                rule.put(PATTERN, (Object)RegExpEnum.URL.getClientRegex());
                rule.put(MESSAGE, (Object)RegExpEnum.URL.getMessage());
                rules.add((Object)rule);
            } else if (((NoCodeTextField)field).isEMail()) {
                JSONArray rules = ValidteRulesBuilder.getOrCreateRules(editor);
                JSONObject rule = new JSONObject();
                rule.put(TYPE, (Object)ValidteRulesBuilder.getRuleType(field));
                rule.put(PATTERN, (Object)RegExpEnum.EMAIL.getClientRegex());
                rule.put(MESSAGE, (Object)RegExpEnum.EMAIL.getMessage());
                rules.add((Object)rule);
            } else if (((NoCodeTextField)field).isPhone()) {
                JSONArray rules = ValidteRulesBuilder.getOrCreateRules(editor);
                JSONObject rule = new JSONObject();
                rule.put(TYPE, (Object)ValidteRulesBuilder.getRuleType(field));
                rule.put(PATTERN, (Object)RegExpEnum.PHONE.getClientRegex());
                rule.put(MESSAGE, (Object)RegExpEnum.PHONE.getMessage());
                rules.add((Object)rule);
            } else if (((NoCodeTextField)field).isIdCard()) {
                JSONArray rules = ValidteRulesBuilder.getOrCreateRules(editor);
                JSONObject rule = new JSONObject();
                rule.put(TYPE, (Object)ValidteRulesBuilder.getRuleType(field));
                rule.put(PATTERN, (Object)RegExpEnum.ID_CARD.getClientRegex());
                rule.put(MESSAGE, (Object)RegExpEnum.ID_CARD.getMessage());
                rules.add((Object)rule);
            }
        }
    }
}

