/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.metadata.wf.info;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.URLCodecUtils;
import kd.bos.util.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CustomJsonRow {
    private String leftQuote = "";
    private String name = "";
    private String rightQuote = "";
    private String separator = "";
    private String startSymbol = "";
    private String valueLeftQuote = "";
    private ParamValue value;
    private String valueRightQuote = "";
    private String valueSeparator = "";
    private String endSymbol = "";
    private boolean hideName;
    private String id;
    private boolean lastOne;
    private List<CustomJsonRow> children = new ArrayList<CustomJsonRow>();

    public String getLeftQuote() {
        return this.leftQuote;
    }

    public void setLeftQuote(String leftQuote) {
        this.leftQuote = leftQuote;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRightQuote() {
        return this.rightQuote;
    }

    public void setRightQuote(String rightQuote) {
        this.rightQuote = rightQuote;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getStartSymbol() {
        return this.startSymbol;
    }

    public void setStartSymbol(String startSymbol) {
        this.startSymbol = startSymbol;
    }

    public String getValueLeftQuote() {
        return this.valueLeftQuote;
    }

    public void setValueLeftQuote(String valueLeftQuote) {
        this.valueLeftQuote = valueLeftQuote;
    }

    public ParamValue getValue() {
        return this.value;
    }

    public void setValue(ParamValue value) {
        this.value = value;
    }

    public String getValueRightQuote() {
        return this.valueRightQuote;
    }

    public void setValueRightQuote(String valueRightQuote) {
        this.valueRightQuote = valueRightQuote;
    }

    public String getValueSeparator() {
        return this.valueSeparator;
    }

    public void setValueSeparator(String valueSeparator) {
        this.valueSeparator = valueSeparator;
    }

    public String getEndSymbol() {
        return this.endSymbol;
    }

    public void setEndSymbol(String endSymbol) {
        this.endSymbol = endSymbol;
    }

    public boolean isHideName() {
        return this.hideName;
    }

    public void setHideName(boolean hideName) {
        this.hideName = hideName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<CustomJsonRow> getChildren() {
        return this.children;
    }

    public void setChildren(List<CustomJsonRow> children) {
        this.children = children;
    }

    public boolean isLastOne() {
        return this.lastOne;
    }

    public void setLastOne(boolean lastOne) {
        this.lastOne = lastOne;
    }

    public String buildJsonString(CustomJsonRow parent) {
        String parentValueLeftQuote = "";
        String parentValueRightQuote = "";
        String parentValueSeparator = "";
        if (parent != null) {
            parentValueLeftQuote = parent.valueLeftQuote;
            parentValueRightQuote = parent.valueRightQuote;
            parentValueSeparator = parent.valueSeparator;
        }
        return parentValueLeftQuote + this.getCurrentRowJson() + parentValueRightQuote + (this.isLastOne() ? "" : parentValueSeparator);
    }

    private String getCurrentRowJson() {
        if (this.hideName) {
            return this.startSymbol + this.getChildJsonStr() + this.getCurrentRowValue() + this.endSymbol;
        }
        return this.leftQuote + this.name + this.rightQuote + this.separator + this.startSymbol + this.getChildJsonStr() + this.getCurrentRowValue() + this.endSymbol;
    }

    private String getCurrentRowValue() {
        if (ValueTypeEnum.var.toString().equals(this.value.getType()) && "combo".equals(this.value.getConfig().getFieldType()) && this.value.getConfig().isMulti() && StringUtils.isNotBlank((CharSequence)this.getCurrentRowSeparator())) {
            String comboValue = this.value.getValue();
            if (StringUtils.isBlank((CharSequence)comboValue)) {
                return this.getCurrentRowValueLeftQuote() + this.getCurrentRowValueRightQuote();
            }
            return Arrays.stream(comboValue.split(",")).sorted().map(URLCodecUtils::decode).map(e -> this.getCurrentRowValueLeftQuote() + e + this.getCurrentRowValueRightQuote()).collect(Collectors.joining(this.getCurrentRowSeparator()));
        }
        return this.getCurrentRowValueLeftQuote() + this.getRealValue() + this.getCurrentRowValueRightQuote() + this.getCurrentRowSeparator();
    }

    private String getChildJsonStr() {
        return this.children.stream().map(customJsonRow -> customJsonRow.buildJsonString(this)).collect(Collectors.joining());
    }

    private String getCurrentRowSeparator() {
        boolean existChildren = CollectionUtils.isNotEmpty(this.getChildren());
        if (!existChildren) {
            return this.valueSeparator;
        }
        return "";
    }

    private String getCurrentRowValueLeftQuote() {
        boolean existChildren = CollectionUtils.isNotEmpty(this.getChildren());
        if (!existChildren) {
            return this.valueLeftQuote;
        }
        return "";
    }

    private String getCurrentRowValueRightQuote() {
        boolean existChildren = CollectionUtils.isNotEmpty(this.getChildren());
        if (!existChildren) {
            return this.valueRightQuote;
        }
        return "";
    }

    private String getRealValue() {
        if (ValueTypeEnum.var.toString().equals(this.value.getType()) && NcEntityTypeUtil.isRefBill((String)this.value.getConfig().getFieldType())) {
            return "";
        }
        if (ValueTypeEnum.var.toString().equals(this.value.getType()) && "combo".equals(this.value.getConfig().getFieldType())) {
            String comboValue = this.value.getValue();
            return StringUtils.isBlank((CharSequence)comboValue) ? "" : URLCodecUtils.decode((String)comboValue);
        }
        return this.getValue().getValue() == null ? "" : this.getValue().getValue();
    }

    public static enum ValueTypeEnum {
        value,
        var,
        expression;

    }

    public static class ParamValueConfig {
        private String fieldType = "";
        private boolean multi;
        private String valueVarKey = "";
        private String parentKey = "";

        public String getFieldType() {
            return this.fieldType;
        }

        public void setFieldType(String fieldType) {
            this.fieldType = fieldType;
        }

        public boolean isMulti() {
            return this.multi;
        }

        public void setMulti(boolean multi) {
            this.multi = multi;
        }

        public String getValueVarKey() {
            return this.valueVarKey;
        }

        public void setValueVarKey(String valueVarKey) {
            this.valueVarKey = valueVarKey;
        }

        public String getParentKey() {
            return this.parentKey;
        }

        public void setParentKey(String parentKey) {
            this.parentKey = parentKey;
        }
    }

    public static class ParamValue {
        private String type = "";
        private String value = "";
        private ParamValueConfig config;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public ParamValueConfig getConfig() {
            return this.config;
        }

        public void setConfig(ParamValueConfig config) {
            this.config = config;
        }
    }
}

