/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.metadata.wf.info;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.nocode.utils.NcEntityTypeUtil;

public class MultiRefBillInfo
implements Serializable {
    private static final long serialVersionUID = -462048449896704175L;
    private String formId = null;
    private String propertyName = null;
    private String value = null;
    private static final String INFO_PATTERN = "disp\\('(.+?)','(.+?)','(.*)'\\)";
    private static final Pattern InfoPattern = Pattern.compile("disp\\('(.+?)','(.+?)','(.*)'\\)");

    public MultiRefBillInfo() {
    }

    public MultiRefBillInfo(String formId, String propertyName, String value) {
        this.formId = formId;
        this.propertyName = propertyName;
        this.value = value;
    }

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static String encodeMultiRefBillInfo(MultiRefBillInfo info) {
        return String.format("%s('%s','%s','%s')", "disp", info.getFormId(), info.getPropertyName(), info.getValue());
    }

    public static MultiRefBillInfo decodeMultiRefBillInfo(String encodeInfo) {
        if (StringUtils.isBlank((CharSequence)encodeInfo)) {
            return null;
        }
        String v = NcEntityTypeUtil.getRuntimeExpression((String)encodeInfo);
        Matcher matcher = InfoPattern.matcher(v);
        if (matcher.matches()) {
            String formId = matcher.group(1);
            String propName = matcher.group(2);
            String value = matcher.group(3);
            if (StringUtils.isNotBlank((CharSequence)value) && value.indexOf("#useStrFormat") != -1) {
                value = value.replace(",'#useStrFormat", "");
            }
            return new MultiRefBillInfo(formId, propName, value);
        }
        return null;
    }

    public static boolean isInfo(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        String v = NcEntityTypeUtil.getRuntimeExpression((String)value);
        Matcher matcher = InfoPattern.matcher(v);
        return matcher.matches();
    }
}

