/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.metadata.wf.nodes;

import com.cronutils.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.nocode.ext.metadata.wf.info.ApiRequestMethod;
import kd.bos.nocode.ext.metadata.wf.info.ParameterSetting;
import kd.bos.nocode.ext.metadata.wf.info.RequestBody;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.NoCodeWfNodeAutoMicroSrv;
import kd.bos.nocode.restapi.common.util.Base36;

@DataEntityTypeAttribute(name="ApiInvokeAutoTask")
public class NoCodeWfNodeApiInvoke
extends NoCodeWfNodeAutoMicroSrv {
    private String method = ApiRequestMethod.GET.toString();
    private String url;
    private boolean sslAuth = true;
    private List<ParameterSetting> requestHeader = new ArrayList<ParameterSetting>(16);
    private RequestBody requestBody = new RequestBody();
    private String whiteList;
    private String queryNumber = "single";
    private int topNumber;
    private String multiArgName;
    private List<ParameterSetting> responseParams = new ArrayList<ParameterSetting>(16);
    private int timeout = 10;
    private int tokenTimeout = 7200;
    private boolean terminateFlow;
    private String testApi = null;
    private String apiMode;
    private String authMode;
    private String username;
    private String password;
    private String accessTokenUrl;

    @SimplePropertyAttribute(name="method")
    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    @SimplePropertyAttribute(name="url")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @SimplePropertyAttribute(name="sslAuth")
    @DefaultValueAttribute(value="true")
    public boolean isSslAuth() {
        return this.sslAuth;
    }

    public void setSslAuth(boolean sslAuth) {
        this.sslAuth = sslAuth;
    }

    @CollectionPropertyAttribute(name="requestHeader", collectionItemPropertyType=ParameterSetting.class)
    public List<ParameterSetting> getRequestHeader() {
        return this.requestHeader;
    }

    public void setRequestHeader(List<ParameterSetting> requestHeader) {
        this.requestHeader = requestHeader;
    }

    @ComplexPropertyAttribute(name="requestBody")
    public RequestBody getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(RequestBody requestBody) {
        this.requestBody = requestBody;
    }

    @SimplePropertyAttribute(name="whiteList")
    public String getWhiteList() {
        return this.whiteList;
    }

    public void setWhiteList(String whiteList) {
        this.whiteList = whiteList;
    }

    @SimplePropertyAttribute(name="queryNumber")
    @DefaultValueAttribute(value="single")
    public String getQueryNumber() {
        return this.queryNumber;
    }

    public void setQueryNumber(String queryNumber) {
        this.queryNumber = queryNumber;
    }

    @SimplePropertyAttribute(name="topNumber")
    public int getTopNumber() {
        return this.topNumber;
    }

    public void setTopNumber(int topNumber) {
        this.topNumber = topNumber;
    }

    @SimplePropertyAttribute(name="multiArgName")
    public String getMultiArgName() {
        return this.multiArgName;
    }

    public void setMultiArgName(String multiArgName) {
        this.multiArgName = multiArgName;
    }

    @CollectionPropertyAttribute(name="responseParams", collectionItemPropertyType=ParameterSetting.class)
    public List<ParameterSetting> getResponseParams() {
        return this.responseParams;
    }

    public List<ParameterSetting> getResponseParamsBase62() {
        return this.responseParams.stream().map(e -> {
            ParameterSetting parameterSetting = new ParameterSetting();
            String name = e.getName();
            if (StringUtils.isEmpty((CharSequence)name)) {
                parameterSetting.setName(name);
            } else {
                parameterSetting.setName("base36__" + Base36.createInstance().encode(name));
            }
            parameterSetting.setValue(e.getValue());
            parameterSetting.setFieldName(e.getFieldName());
            parameterSetting.setFieldType(e.getFieldType());
            parameterSetting.setResponseType(e.getResponseType());
            return parameterSetting;
        }).collect(Collectors.toList());
    }

    public void setResponseParams(List<ParameterSetting> responseParams) {
        this.responseParams = responseParams;
    }

    @SimplePropertyAttribute(name="timeout")
    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @SimplePropertyAttribute(name="terminateFlow")
    public boolean isTerminateFlow() {
        return this.terminateFlow;
    }

    public void setTerminateFlow(boolean terminateFlow) {
        this.terminateFlow = terminateFlow;
    }

    @SimplePropertyAttribute(name="testApi")
    public String getTestApi() {
        return this.testApi;
    }

    public void setTestApi(String testApi) {
        this.testApi = testApi;
    }

    @SimplePropertyAttribute(name="apiMode")
    public String getApiMode() {
        return this.apiMode;
    }

    public void setApiMode(String apiMode) {
        this.apiMode = apiMode;
    }

    @SimplePropertyAttribute(name="authMode")
    public String getAuthMode() {
        return this.authMode;
    }

    public void setAuthMode(String authMode) {
        this.authMode = authMode;
    }

    @SimplePropertyAttribute(name="username")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @SimplePropertyAttribute(name="password")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @SimplePropertyAttribute(name="accessTokenUrl")
    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    public void setAccessTokenUrl(String accessTokenUrl) {
        this.accessTokenUrl = accessTokenUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NoCodeWfNodeApiInvoke that = (NoCodeWfNodeApiInvoke)o;
        if (this.sslAuth != that.sslAuth) {
            return false;
        }
        if (this.topNumber != that.topNumber) {
            return false;
        }
        if (this.timeout != that.timeout) {
            return false;
        }
        if (this.tokenTimeout != that.tokenTimeout) {
            return false;
        }
        if (this.terminateFlow != that.terminateFlow) {
            return false;
        }
        if (!Objects.equals(this.method, that.method)) {
            return false;
        }
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        if (!Objects.equals(this.requestHeader, that.requestHeader)) {
            return false;
        }
        if (!Objects.equals(this.requestBody, that.requestBody)) {
            return false;
        }
        if (!Objects.equals(this.whiteList, that.whiteList)) {
            return false;
        }
        if (!Objects.equals(this.queryNumber, that.queryNumber)) {
            return false;
        }
        if (!Objects.equals(this.multiArgName, that.multiArgName)) {
            return false;
        }
        if (!Objects.equals(this.responseParams, that.responseParams)) {
            return false;
        }
        if (!Objects.equals(this.testApi, that.testApi)) {
            return false;
        }
        if (!Objects.equals(this.apiMode, that.apiMode)) {
            return false;
        }
        if (!Objects.equals(this.authMode, that.authMode)) {
            return false;
        }
        if (!Objects.equals(this.username, that.username)) {
            return false;
        }
        if (!Objects.equals(this.password, that.password)) {
            return false;
        }
        return Objects.equals(this.accessTokenUrl, that.accessTokenUrl);
    }

    public int hashCode() {
        int result = this.method != null ? this.method.hashCode() : 0;
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.sslAuth ? 1 : 0);
        result = 31 * result + (this.requestHeader != null ? this.requestHeader.hashCode() : 0);
        result = 31 * result + (this.requestBody != null ? this.requestBody.hashCode() : 0);
        result = 31 * result + (this.whiteList != null ? this.whiteList.hashCode() : 0);
        result = 31 * result + (this.queryNumber != null ? this.queryNumber.hashCode() : 0);
        result = 31 * result + this.topNumber;
        result = 31 * result + (this.multiArgName != null ? this.multiArgName.hashCode() : 0);
        result = 31 * result + (this.responseParams != null ? this.responseParams.hashCode() : 0);
        result = 31 * result + this.timeout;
        result = 31 * result + this.tokenTimeout;
        result = 31 * result + (this.terminateFlow ? 1 : 0);
        result = 31 * result + (this.testApi != null ? this.testApi.hashCode() : 0);
        result = 31 * result + (this.apiMode != null ? this.apiMode.hashCode() : 0);
        result = 31 * result + (this.authMode != null ? this.authMode.hashCode() : 0);
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.accessTokenUrl != null ? this.accessTokenUrl.hashCode() : 0);
        return result;
    }

    @SimplePropertyAttribute(name="tokenTimeout")
    public int getTokenTimeout() {
        return this.tokenTimeout;
    }

    public void setTokenTimeout(int tokenTimeout) {
        this.tokenTimeout = tokenTimeout;
    }
}

