/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.operation.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;

class FieldChecker {
    private MainEntityType mainType;
    private List<IDataEntityProperty> fieldProps = new ArrayList<IDataEntityProperty>();
    private Set<String> notExistsFields = new HashSet<String>();
    private Set<EntryType> entrys = new HashSet<EntryType>();
    private Set<SubEntryType> subEntrys = new HashSet<SubEntryType>();

    public FieldChecker(MainEntityType mainType) {
        this.mainType = mainType;
    }

    public void check(Collection<String> fieldKeys) {
        this.check(fieldKeys.toArray(new String[fieldKeys.size()]));
    }

    public void check(String[] fieldKeys) {
        for (String fieldKey : fieldKeys) {
            String[] arr = fieldKey.split("\\.");
            IDataEntityProperty prop = this.mainType.findProperty(arr[0]);
            if (prop == null) {
                this.notExistsFields.add(fieldKey);
                continue;
            }
            this.fieldProps.add(prop);
            if (prop.getParent() instanceof SubEntryType) {
                this.entrys.add((EntryType)prop.getParent().getParent());
                this.subEntrys.add((SubEntryType)prop.getParent());
                continue;
            }
            if (!(prop.getParent() instanceof EntryType)) continue;
            this.entrys.add((EntryType)prop.getParent());
        }
    }

    public boolean isNotExistsFields() {
        return !this.notExistsFields.isEmpty();
    }

    public boolean isOverEntry() {
        return this.entrys.size() > 1 || this.subEntrys.size() > 1;
    }

    public String getOverEntryNames(String separator) {
        ArrayList<String> names;
        block3: {
            block2: {
                names = new ArrayList<String>();
                if (this.entrys.size() <= 1) break block2;
                for (EntryType entry : this.entrys) {
                    names.add(entry.getDisplayName().toString());
                }
                break block3;
            }
            if (this.subEntrys.size() <= 1) break block3;
            for (SubEntryType subEntry : this.subEntrys) {
                names.add(subEntry.getDisplayName().toString());
            }
        }
        return StringUtils.join((Object[])names.toArray(), (String)separator);
    }

    public List<IDataEntityProperty> getFieldProps() {
        return this.fieldProps;
    }

    public Set<String> getNotExistsFields() {
        return this.notExistsFields;
    }

    public Set<EntryType> getEntrys() {
        return this.entrys;
    }

    public Set<SubEntryType> getSubEntrys() {
        return this.subEntrys;
    }

    public String getEntityKey() {
        if (!this.subEntrys.isEmpty()) {
            return this.subEntrys.iterator().next().getName();
        }
        if (!this.entrys.isEmpty()) {
            return this.entrys.iterator().next().getName();
        }
        return this.mainType.getName();
    }
}

