/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.operation.validate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeDataRangeField;
import kd.bos.nocode.ext.property.NoCodeAttachmentProp;
import kd.bos.nocode.ext.property.NoCodeDecimalProp;
import kd.bos.nocode.ext.property.NoCodeImageProp;
import kd.bos.nocode.ext.property.NoCodeMulComboProp;
import kd.bos.nocode.ext.property.NoCodeMulRefBillProp;
import kd.bos.nocode.ext.property.NoCodeProp;

public class MinMaxCountValidator
extends AbstractValidator {
    protected DynamicProperty vProperty;
    protected String fieldKey;
    protected String fieldName;

    public MinMaxCountValidator(DynamicProperty vProperty, String fieldKey, String fieldName) {
        this.vProperty = vProperty;
        this.fieldName = fieldName;
        this.fieldKey = fieldKey;
    }

    public void initializeConfiguration() {
        super.initializeConfiguration();
    }

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String content;
            int count;
            String val;
            int maxCount;
            int minCount;
            Object value = this.vProperty.getValue((Object)dataEntity.getDataEntity());
            if (this.vProperty instanceof NoCodeMulComboProp) {
                NoCodeMulComboProp mulComboProp = (NoCodeMulComboProp)this.vProperty;
                minCount = mulComboProp.getMinCount();
                maxCount = mulComboProp.getMaxCount();
                val = (String)value;
                int n = count = StringUtils.isEmpty((CharSequence)val) ? 0 : val.split(",").length;
                if (count >= minCount && count <= maxCount) continue;
                content = this.buildErrMessage(dataEntity, minCount, maxCount);
                this.addMessage(dataEntity, content, this.getErrorLevl());
                continue;
            }
            if (this.vProperty instanceof NoCodeAttachmentProp || this.vProperty instanceof NoCodeImageProp) {
                NoCodeDataRangeField range;
                NoCodeProp prop;
                int size = 0;
                if (this.vProperty instanceof NoCodeAttachmentProp) {
                    prop = (NoCodeAttachmentProp)this.vProperty;
                    range = ((NoCodeAttachmentProp)prop).getDataRange();
                    DynamicObjectCollection collection = (DynamicObjectCollection)value;
                    size = collection.size();
                } else {
                    prop = (NoCodeImageProp)this.vProperty;
                    range = ((NoCodeImageProp)prop).getDataRange();
                    String str = (String)value;
                    if (StringUtils.isNotEmpty((CharSequence)str)) {
                        JSONArray array = JSON.parseArray((String)str);
                        size = array.size();
                    }
                }
                int min = Integer.parseInt(range.getMin());
                int max = Integer.parseInt(range.getMax());
                if (size >= min && size <= max) continue;
                String content2 = min == 0 ? (this.vProperty instanceof NoCodeAttachmentProp ? ResManager.loadKDString((String)"\u4e0a\u4f20\u9644\u4ef6\u6570\u91cf\u4e0d\u80fd\u591a\u4e8e%s\u4e2a", (String)"MinMaxCountValidator_0", (String)"BOS_NOCODE", (Object[])new Object[]{max}) : ResManager.loadKDString((String)"\u4e0a\u4f20\u56fe\u7247\u6570\u91cf\u4e0d\u80fd\u591a\u4e8e%s\u5f20", (String)"MinMaxCountValidator_1", (String)"BOS_NOCODE", (Object[])new Object[]{max})) : (this.vProperty instanceof NoCodeAttachmentProp ? ResManager.loadKDString((String)"\u4e0a\u4f20\u9644\u4ef6\u6570\u91cf\u4e0d\u80fd\u591a\u4e8e%1$s\u4e2a,\u5c11\u4e8e%2$s\u4e2a", (String)"MinMaxCountValidator_6", (String)"BOS_NOCODE", (Object[])new Object[]{max, min}) : ResManager.loadKDString((String)"\u4e0a\u4f20\u56fe\u7247\u6570\u91cf\u4e0d\u80fd\u591a\u4e8e%1$s\u5f20,\u5c11\u4e8e%2$s\u5f20", (String)"MinMaxCountValidator_7", (String)"BOS_NOCODE", (Object[])new Object[]{max, min}));
                this.addMessage(dataEntity, content2, this.getErrorLevl());
                continue;
            }
            if (this.vProperty instanceof NoCodeMulRefBillProp && ((NoCodeMulRefBillProp)this.vProperty).getMulti() > 0) {
                NoCodeMulRefBillProp mulRefProp = (NoCodeMulRefBillProp)this.vProperty;
                minCount = Integer.parseInt(mulRefProp.getDataRange().getMin());
                maxCount = Integer.parseInt(mulRefProp.getDataRange().getMax());
                val = (String)value;
                int n = count = StringUtils.isEmpty((CharSequence)val) ? 0 : val.split(",").length;
                if (count >= minCount && count <= maxCount) continue;
                content = this.buildErrMessage(dataEntity, minCount, maxCount);
                this.addMessage(dataEntity, content, this.getErrorLevl());
                continue;
            }
            if (!(this.vProperty instanceof NoCodeDecimalProp)) continue;
        }
    }

    protected String buildErrMessage(ExtendedDataEntity extDataEntity, int minCount, int maxCount) {
        if (this.vProperty.getParent() instanceof EntryType) {
            return ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\uff0c\u201c%3$s\u201d\u9009\u62e9\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e%4$s\uff0c\u4e0d\u80fd\u5927\u4e8e%5$s\u3002", (String)"MinMaxCountValidator_4", (String)"BOS_NOCODE", (Object[])new Object[]{this.vProperty.getParent().getDisplayName().toString(), extDataEntity.getRowIndex() + 1, this.fieldName, minCount, maxCount});
        }
        return ResManager.loadKDString((String)"\u201c%1$s\u201d\u9009\u62e9\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e%2$s\uff0c\u4e0d\u80fd\u5927\u4e8e%3$s", (String)"MinMaxCountValidator_5", (String)"BOS_NOCODE", (Object[])new Object[]{this.fieldName, minCount, maxCount});
    }
}

