/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.operation.validate;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.LayoutControlInfo;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.function.FunctionManage;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.IValidatorHanlder;
import kd.bos.entity.validate.ValidateContext;
import kd.bos.entity.validate.ValidateExpressionContext;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.ext.property.NoCodeProp;
import kd.bos.nocode.ext.property.NoCodeRefBillTableProp;
import kd.bos.service.operation.validate.BillLayoutRequiredValidator;
import kd.bos.service.operation.validate.BillTypeRequiredValidator;

public class NoCodeFieldValidator
extends AbstractValidator {
    private static final Log LOG = LogFactory.getLog(NoCodeFieldValidator.class);

    public void validate() {
        MainEntityType subMainType = this.validateContext.getSubEntityType();
        List<AbstractValidator> requiredValidators = this.buildFieldDefaultValidators((IDataEntityType)subMainType);
        if (LayoutControlInfo.isBillTypeLayout()) {
            BillTypeRequiredValidator billTypeRequiredValidator = new BillTypeRequiredValidator();
            requiredValidators.add((AbstractValidator)billTypeRequiredValidator);
        } else {
            BillLayoutRequiredValidator layoutValidator = new BillLayoutRequiredValidator();
            requiredValidators.add((AbstractValidator)layoutValidator);
        }
        this.executeAllValidators(requiredValidators);
    }

    private void executeAllValidators(List<AbstractValidator> requiredValidators) {
        for (AbstractValidator v : requiredValidators) {
            this.setValidateContext(this.validateContext, v);
            if (v.getDataEntities() == null || v.getDataEntities().length == 0) continue;
            v.setAddBillNoForContent(false);
            v.validate();
            ValidateResult res = v.getValidateResult();
            if (res.isSuccess()) continue;
            for (OperateErrorInfo operateInfo : res.getAllErrorInfo()) {
                this.validateResult.addErrorInfo(operateInfo);
            }
        }
    }

    public void validateFieldRequired(IFormView formView) {
        MainEntityType subMainType = this.validateContext.getSubEntityType();
        List<AbstractValidator> requiredValidators = this.buildFieldRequiredValidators((IDataEntityType)subMainType, formView);
        this.executeAllValidators(requiredValidators);
    }

    private void fillValidatorProperties(AbstractValidator validator, String entityKey) {
        validator.setEntityKey(entityKey);
        validator.setOperateKey(this.validateContext.getOperateKey());
        validator.setOperateType(this.validateContext.getOperateType());
        validator.setOperationName(this.validateContext.getOperateName());
        validator.setErrorLevel(this.getErrorLevl());
    }

    private List<AbstractValidator> buildFieldRequiredValidators(IDataEntityType entityType, IFormView formView) {
        ArrayList<AbstractValidator> requiredValidators = new ArrayList<AbstractValidator>(16);
        for (IDataEntityProperty prop : entityType.getProperties()) {
            List<AbstractValidator> validators;
            if (prop instanceof NoCodeProp) {
                NoCodeProp noCodeProp = (NoCodeProp)prop;
                validators = noCodeProp.getFieldRequiredValidators(formView);
                for (AbstractValidator validator : validators) {
                    this.fillValidatorProperties(validator, entityType.getName());
                    requiredValidators.add(validator);
                }
            }
            if (prop instanceof EntryProp) {
                IDataEntityType refItemType = ((ICollectionProperty)prop).getItemType();
                requiredValidators.addAll(this.buildFieldRequiredValidators(refItemType, formView));
            }
            if (!(prop instanceof NoCodeRefBillTableProp)) continue;
            NoCodeRefBillTableProp tableProp = (NoCodeRefBillTableProp)prop;
            validators = tableProp.getFieldRequiredValidators(formView);
            for (AbstractValidator validator : validators) {
                this.fillValidatorProperties(validator, entityType.getName());
                requiredValidators.add(validator);
            }
        }
        return requiredValidators;
    }

    private List<AbstractValidator> buildFieldDefaultValidators(IDataEntityType entityType) {
        ArrayList<AbstractValidator> defaultValidators = new ArrayList<AbstractValidator>(16);
        for (IDataEntityProperty prop : entityType.getProperties()) {
            if (prop instanceof IValidatorHanlder) {
                IValidatorHanlder validatorHandler = (IValidatorHanlder)prop;
                List validators = validatorHandler.getValidators();
                for (AbstractValidator validator : validators) {
                    this.fillValidatorProperties(validator, entityType.getName());
                    defaultValidators.add(validator);
                }
            }
            if (!(prop instanceof EntryProp)) continue;
            IDataEntityType refItemType = ((ICollectionProperty)prop).getItemType();
            defaultValidators.addAll(this.buildFieldDefaultValidators(refItemType));
        }
        return defaultValidators;
    }

    private void setValidateContext(ValidateContext validateContext, AbstractValidator validator) {
        ExtendedDataEntitySet entitySet = validateContext.getExtendedDataEntitySet();
        validator.setValidateContext(validateContext);
        validator.setExtendedDataEntitySet(entitySet);
        validator.initializeConfiguration();
        if (StringUtils.isBlank((CharSequence)validator.getEntityKey())) {
            return;
        }
        ExtendedDataEntity[] array = entitySet.FindByEntityKey(validator.getEntityKey());
        BOSExpression preConditin = validator.getPreConditionExpr();
        if (array != null && preConditin != null && preConditin.getExpr() != null) {
            RowDataModel rowModel = new RowDataModel(validator.getEntityKey(), validateContext.getSubEntityType());
            ValidateExpressionContext expContext = new ValidateExpressionContext(rowModel, validateContext);
            ArrayList<ExtendedDataEntity> passRows = new ArrayList<ExtendedDataEntity>();
            for (ExtendedDataEntity row : array) {
                expContext.getRowDataModel().setRowContext((Object)row.getDataEntity(), row.getRowIndex());
                Object pass = CalcExprParser.getExpressionValue((BOSExpression)preConditin, (ExpressionContext)expContext, (FunctionManage)validateContext.getFuncLib());
                if (pass == null || !((Boolean)pass).booleanValue()) continue;
                passRows.add(row);
            }
            array = passRows.toArray(new ExtendedDataEntity[passRows.size()]);
        }
        if (array == null || array.length == 0) {
            return;
        }
        validator.setDataEntities(array);
        validator.initialize();
    }
}

