/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.operation.validate;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.nocode.ext.operation.validate.FieldChecker;

public class RegexValidator
extends AbstractValidator {
    private static final String BOS_MSERVICE_OPERATION = "bos-mservice-operation";
    private List<IDataEntityProperty> props = null;
    private boolean ignoreBlank = false;
    private String regex;
    private LocaleString message;
    private LocaleString desc;

    private List<String> getFieldKeys() {
        List fieldsMap = (List)this.getValidation().get("fields");
        ArrayList<String> fields = new ArrayList<String>();
        if (fieldsMap != null && !fieldsMap.isEmpty()) {
            for (Map fMap : fieldsMap) {
                fields.add((String)fMap.get("id"));
            }
        }
        return fields;
    }

    public Set<String> preparePropertys() {
        Set set = super.preparePropertys();
        List<String> fields = this.getFieldKeys();
        for (String key : fields) {
            set.add(key);
        }
        return set;
    }

    public void initializeConfiguration() {
        super.initializeConfiguration();
        this.desc = LocaleString.fromMap((Map)((Map)this.getValidationValueByKey("description")));
        List<String> fieldKeys = this.getFieldKeys();
        FieldChecker fieldChecker = new FieldChecker(this.getValidateContext().getSubEntityType());
        fieldChecker.check(fieldKeys);
        if (fieldKeys.size() > 1 && fieldChecker.isOverEntry()) {
            throw new KDBizException(ResManager.loadKDString((String)"%1$s-%2$s\uff0c%3$s\uff1a\u914d\u7f6e\u9519\u8bef\uff0c\u4e0d\u5141\u8bb8\u5728\u4e00\u4e2a\u6821\u9a8c\u5668\u4e2d\u68c0\u67e5\u591a\u4e2a\u5355\u636e\u4f53\u7684\u5b57\u6bb5\uff0c\u8bf7\u62c6\u5206\u4e3a\u591a\u4e2a\u6821\u9a8c\u5668", (String)"RegexValidator_0", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[]{this.getValidateContext().getBillEntityType().getDisplayName().toString(), this.getOperationName(), this.desc.toString()}));
        }
        this.props = fieldChecker.getFieldProps();
        this.setEntityKey(fieldChecker.getEntityKey());
        this.ignoreBlank = (Boolean)this.getValidationValueByKey("ignoreBlank");
        this.regex = (String)this.getValidationValueByKey("regex");
        Object msg = this.getValidationValueByKey("message");
        if (msg != null) {
            this.message = LocaleString.fromMap((Map)((Map)msg));
        }
        if (this.message == null || StringUtils.isBlank((CharSequence)this.message.toString())) {
            this.message = new LocaleString(ResManager.loadKDString((String)"%s\u5931\u8d25", (String)"RegexValidator_1", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[]{this.desc.toString()}));
        }
    }

    public void validate() {
        List<IDataEntityProperty> fieldProps = this.props;
        if (fieldProps.isEmpty()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.regex)) {
            return;
        }
        Pattern pattern = Pattern.compile(this.regex);
        RowDataModel rowDataModel = new RowDataModel(this.getEntityKey(), this.validateContext.getSubEntityType());
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            rowDataModel.setRowContext(dataEntity.getDataEntity());
            for (IDataEntityProperty fieldProp : fieldProps) {
                Matcher matcher;
                boolean rs;
                Object fieldProObj = rowDataModel.getValue(fieldProp.getName());
                String fieldValue = String.valueOf(fieldProObj);
                if (this.ignoreBlank && StringUtils.isBlank((CharSequence)fieldValue) || this.ignoreBlank && fieldProp instanceof MuliLangTextProp && (StringUtils.isEmpty((CharSequence)fieldValue) || fieldProObj == null) || (rs = (matcher = pattern.matcher(fieldValue)).matches())) continue;
                String errMsg = this.buildMessage(dataEntity, (DynamicProperty)fieldProp);
                this.addMessage(dataEntity, errMsg);
            }
        }
    }

    private String buildMessage(ExtendedDataEntity dataEntity, DynamicProperty fieldProp) {
        String fieldCaption = String.format("\u201c%s\u201d", fieldProp.getDisplayName().toString());
        EntityType entityType = (EntityType)fieldProp.getParent();
        if (entityType instanceof SubEntryType) {
            EntityType parentType = (EntityType)entityType.getParent();
            return ResManager.loadKDString((String)"\u201c%1$s\u201d\u7b2c\u201c%2$s\u201d\u884c, \u201c%3$s\u201d\u7b2c\u201c%4$s\u201d\u884c, %5$s%6$s", (String)"RegexValidator_2", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[]{parentType.getDisplayName().toString(), dataEntity.getRowIndex() + 1, entityType.getDisplayName().toString(), dataEntity.getSubRowIndex() + 1, fieldCaption, this.message.toString()});
        }
        if (entityType instanceof EntryType) {
            return ResManager.loadKDString((String)"\u201c%1$s\u201d\u7b2c\u201c%2$s\u201d\u884c\uff0c%3$s%4$s", (String)"RegexValidator_3", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[]{entityType.getDisplayName(), dataEntity.getRowIndex() + 1, fieldCaption, this.message.toString()});
        }
        return String.format("%s%s", fieldCaption, this.message.toString());
    }
}

