/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.property;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.RequiredValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeDataRangeField;
import kd.bos.nocode.ext.operation.validate.MinMaxCountValidator;
import kd.bos.nocode.ext.property.NoCodeProp;
import kd.bos.nocode.ext.property.annotations.PropInfo;
import kd.bos.nocode.ext.validate.NoCodeRequiredValidator;
import kd.bos.nocode.property.INoCodeAttachmentProp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;

@PropInfo(name="\u9644\u4ef6")
public class NoCodeAttachmentProp
extends AttachmentProp
implements NoCodeProp,
INoCodeAttachmentProp {
    private static final long serialVersionUID = 8606440000659767412L;
    public static final String ATT_ID = "id";
    private static final String ATT_PKID = "attPkId";
    private static final String BILL_NUMBER = "number";
    public static final String ATT_NAME = "name";
    private static final String ATT_SIZE = "size";
    public static final String ATT_UID = "uid";
    private static final String ATT_URL = "url";
    private static final String ATT_TYPE = "type";
    private static final String ATT_CREATOR = "creator";
    private static final String ATT_CREATETIME = "createtime";
    private static final String ATT_MODIFYTIME = "modifytime";
    private static final String ATT_DECRIPTION = "description";
    private static final String ATT_STATUS = "status";
    private static final String ATT_TEMPFILE = "tempfile";
    private static final String ATT_SORT = "sort";
    private static final String FILESOURCE = "filesource";
    private static final String ATT_SUCCESS_STATUS = "B";
    public static final String ATT_ENTITYID = "bd_attachment";
    private static final int ATT_OFFICIAL = 1;
    private String attachmentDefValue = "";
    private NoCodeDataRangeField dataRange = new NoCodeDataRangeField("0", "9");
    private String attachmentFileType;
    private static final Log log = LogFactory.getLog(NoCodeAttachmentProp.class);

    @ComplexPropertyAttribute(name="UploadNum")
    public NoCodeDataRangeField getDataRange() {
        return this.dataRange;
    }

    public void setDataRange(NoCodeDataRangeField dataRange) {
        this.dataRange = dataRange;
    }

    @SimplePropertyAttribute(name="UploadDefValue")
    public String getAttachmentDefValue() {
        return this.attachmentDefValue;
    }

    public void setAttachmentDefValue(String attachmentDefValue) {
        this.attachmentDefValue = attachmentDefValue;
    }

    public NoCodeAttachmentProp(String name, DynamicObjectType dynamicItemPropertyType) {
        super(name, dynamicItemPropertyType);
    }

    public NoCodeAttachmentProp() {
    }

    @Override
    public String getNoCodeDefValue() {
        return this.attachmentDefValue;
    }

    public void applyDefaultValue(IDataModel model, DynamicObject dataEntity, int rowIndex) {
        this.calcDefaultValue(model, dataEntity, rowIndex, (IFieldHandle)this);
    }

    @Override
    public Object formatDefValue(Object value) {
        if (value == null) {
            return null;
        }
        try {
            if (value instanceof String && StringUtils.isNotEmpty((String)((String)value))) {
                JSONArray attaches = JSON.parseArray((String)((String)value));
                HashSet<String> uids = new HashSet<String>();
                for (int i = 0; i < attaches.size(); ++i) {
                    JSONObject attach = attaches.getJSONObject(i);
                    uids.add(attach.getString(ATT_UID));
                }
                QFilter filter = new QFilter(ATT_UID, "in", uids);
                String selects = String.join((CharSequence)",", ATT_ID, ATT_UID);
                DynamicObject[] dys = BusinessDataServiceHelper.load((String)ATT_ENTITYID, (String)selects, (QFilter[])filter.toArray());
                HashMap<String, Long> data = new HashMap<String, Long>();
                ArrayList values = new ArrayList(data.values());
                for (DynamicObject dy : dys) {
                    data.put(dy.getString(ATT_UID), dy.getLong(ATT_ID));
                    values.add(dy.getLong(ATT_ID));
                }
                uids.removeAll(data.keySet());
                if (!uids.isEmpty()) {
                    JSONArray array = new JSONArray();
                    for (int i = 0; i < attaches.size(); ++i) {
                        JSONObject attach = attaches.getJSONObject(i);
                        String uid = attach.getString(ATT_UID);
                        if (!uids.contains(uid)) continue;
                        array.add((Object)attach);
                    }
                    long[] newAttachments = this.createNewAttachments(array);
                    values.addAll(Arrays.stream(newAttachments).boxed().collect(Collectors.toSet()));
                }
                return values.toArray();
            }
            if (value instanceof DynamicObjectCollection) {
                DynamicObjectCollection vas = (DynamicObjectCollection)value;
                return vas.stream().map(d -> d.get("fbasedataid_id")).toArray();
            }
            if (value instanceof List) {
                List vas = (List)value;
                return vas.stream().map(d -> d.get(ATT_PKID)).toArray();
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
        return null;
    }

    private long[] createNewAttachments(JSONArray defAttaches) {
        ArrayList<DynamicObject> allAttObjs = new ArrayList<DynamicObject>();
        Date now = new Date();
        long[] ids = ORM.create().genLongIds(ATT_ENTITYID, defAttaches.size());
        for (int i = 0; i < defAttaches.size(); ++i) {
            Object modifyTime;
            JSONObject attachment = defAttaches.getJSONObject(i);
            DynamicObject attObj = BusinessDataServiceHelper.newDynamicObject((String)ATT_ENTITYID);
            attObj.set(ATT_ID, (Object)ids[i]);
            String fileName = (String)attachment.get((Object)ATT_NAME);
            String type = fileName != null ? fileName.substring(fileName.lastIndexOf(46) + 1) : "";
            long size = attachment.get((Object)ATT_SIZE) == null ? 0L : Long.parseLong(attachment.get((Object)ATT_SIZE).toString());
            attObj.set(ATT_NAME, (Object)fileName);
            attObj.set(ATT_SIZE, (Object)size);
            attObj.set(ATT_UID, attachment.get((Object)ATT_UID));
            attObj.set(ATT_URL, attachment.get((Object)ATT_URL));
            attObj.set(ATT_TYPE, (Object)type);
            attObj.set(ATT_DECRIPTION, attachment.get((Object)ATT_DECRIPTION));
            attObj.set(FILESOURCE, attachment.get((Object)FILESOURCE));
            Object attSortObj = attachment.get((Object)ATT_SORT);
            if (attSortObj != null) {
                attObj.set(ATT_SORT, attSortObj);
            }
            attObj.set(ATT_TEMPFILE, (Object)1);
            attObj.set(BILL_NUMBER, (Object)UUID.randomUUID().toString());
            attObj.set(ATT_STATUS, (Object)ATT_SUCCESS_STATUS);
            attObj.set(ATT_CREATETIME, (Object)now.getTime());
            if (attachment.containsKey((Object)"uploadTime")) {
                attObj.set(ATT_CREATETIME, (Object)new Date((Long)attachment.get((Object)"uploadTime")));
            }
            if ((modifyTime = attachment.get((Object)"lastModified")) == null) {
                attObj.set(ATT_MODIFYTIME, (Object)now.getTime());
            } else {
                attObj.set(ATT_MODIFYTIME, (Object)new Date((Long)modifyTime));
            }
            attObj.set(ATT_CREATOR, (Object)RequestContext.get().getUserId());
            allAttObjs.add(attObj);
        }
        DynamicObject[] attArrays = allAttObjs.toArray(new DynamicObject[0]);
        SaveServiceHelper.save((DynamicObject[])attArrays);
        return ids;
    }

    public List<FilterField> createFilterFields(MainEntityType mainType) {
        ArrayList<FilterField> filterFields = new ArrayList<FilterField>(64);
        String refEntityId = this.getBaseEntityId();
        IDataEntityProperty refProp1 = null;
        IDataEntityProperty refProp2 = null;
        String srcKey = this.getName();
        ArrayList<String> keyList = new ArrayList<String>(3);
        String attachmentSizeKey = srcKey + ".fbasedataid.size";
        String attachmentNameKey = srcKey + ".fbasedataid.name";
        String attachmentTypeKey = srcKey + ".fbasedataid.type";
        keyList.add(attachmentSizeKey);
        keyList.add(attachmentNameKey);
        keyList.add(attachmentTypeKey);
        String srcPropName = this.getDisplayName().toString();
        HashMap<String, String> subPropNames = new HashMap<String, String>(4);
        subPropNames.put(attachmentSizeKey, srcPropName + ResManager.loadKDString((String)".\u5927\u5c0f", (String)"NoCodeAttachmentProp_1", (String)"bos-nocode-ext", (Object[])new Object[0]));
        subPropNames.put(attachmentNameKey, srcPropName + ResManager.loadKDString((String)".\u540d\u79f0", (String)"NoCodeAttachmentProp_2", (String)"bos-nocode-ext", (Object[])new Object[0]));
        subPropNames.put(attachmentTypeKey, srcPropName + ResManager.loadKDString((String)".\u7c7b\u578b", (String)"NoCodeAttachmentProp_3", (String)"bos-nocode-ext", (Object[])new Object[0]));
        for (String key : keyList) {
            String[] keys = key.split("\\.");
            if (keys.length > 2) {
                BasedataEntityType bdType2;
                BasedataEntityType bdType1 = (BasedataEntityType)((BasedataProp)this.getDynamicCollectionItemPropertyType().getProperty(keys[1])).getComplexType();
                refProp1 = bdType1.findProperty(keys[2]);
                refEntityId = bdType1.getName();
                if (refProp1 instanceof BasedataProp && keys.length > 3) {
                    bdType2 = (BasedataEntityType)((BasedataProp)refProp1).getComplexType();
                    refProp2 = bdType2.findProperty(keys[3]);
                    refEntityId = bdType2.getName();
                } else if (refProp1 instanceof MulBasedataProp && keys.length > 4) {
                    bdType2 = (BasedataEntityType)((BasedataProp)this.getDynamicCollectionItemPropertyType().getProperty(keys[3])).getComplexType();
                    refProp2 = bdType2.findProperty(keys[4]);
                    refEntityId = bdType2.getName();
                }
            }
            FilterField filterField = new FilterField(mainType, (IDataEntityProperty)this, refProp1, refProp2, refEntityId);
            if (attachmentTypeKey.equalsIgnoreCase(key) && StringUtils.isNotEmpty((String)this.getAttachmentFileType())) {
                FilterField proxyFilterField = this.getProxyFilterField(attachmentTypeKey, filterField);
                filterFields.add(proxyFilterField);
            } else {
                filterFields.add(filterField);
            }
            filterField.setCaption(new LocaleString((String)subPropNames.get(key)));
        }
        return filterFields;
    }

    private FilterField getProxyFilterField(String attachmentTypeKey, FilterField filterField) {
        ComboProp comboProp = this.createComboProp(attachmentTypeKey);
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(FilterField.class);
        enhancer.setCallback((Callback)((MethodInterceptor)(obj, method, args, proxy) -> {
            Object result;
            String name;
            switch (name = proxy.getSignature().getName()) {
                case "getFieldProp": {
                    result = comboProp;
                    break;
                }
                case "getFilterControlType": {
                    result = "enum";
                    break;
                }
                case "getComboItems": {
                    result = comboProp.getComboItems();
                    break;
                }
                default: {
                    result = proxy.invoke((Object)filterField, args);
                }
            }
            return result;
        }));
        return (FilterField)enhancer.create();
    }

    private ComboProp createComboProp(String attachmentTypeKey) {
        ComboProp comboProp = new ComboProp();
        comboProp.setName(attachmentTypeKey);
        comboProp.setComboItems(this.getAttachmentTypeComboItems());
        return comboProp;
    }

    public List<AbstractValidator> getValidators() {
        List validators = super.getValidators();
        validators.add(new MinMaxCountValidator((DynamicProperty)this, this.getName(), this.getDisplayName().toString()));
        if (this.isMustInput()) {
            validators.removeIf(RequiredValidator.class::isInstance);
            NoCodeRequiredValidator requiredValidator = new NoCodeRequiredValidator(this.getCompareProp(), this.getName(), this.getDisplayName().toString(), this.getValueComparator());
            validators.add(requiredValidator);
        }
        return validators;
    }

    public boolean isEnableNull() {
        return true;
    }

    public boolean isSupportQingAnalysis() {
        return false;
    }

    @SimplePropertyAttribute(name="AttachmentFileType")
    public String getAttachmentFileType() {
        return this.attachmentFileType;
    }

    public void setAttachmentFileType(String attachmentFileType) {
        this.attachmentFileType = attachmentFileType;
    }

    public List<ValueMapItem> getAttachmentTypeComboItems() {
        boolean FIRST_INDEX = true;
        String attachmentFileType = this.getAttachmentFileType();
        if (StringUtils.isBlank((String)attachmentFileType)) {
            return new ArrayList<ValueMapItem>(0);
        }
        return Arrays.stream(attachmentFileType.split(",")).map(e -> e.trim().substring(1)).map(e -> new ValueMapItem(StringUtils.getEmpty(), e, new LocaleString(e))).collect(Collectors.toList());
    }

    public boolean isShowUsed() {
        return false;
    }
}

