/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.property;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.RequiredValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.ext.property.NoCodeProp;
import kd.bos.nocode.ext.property.annotations.PropInfo;
import kd.bos.nocode.ext.validate.NoCodeRequiredValidator;
import kd.bos.nocode.property.INoCodeComboProp;
import kd.bos.nocode.utils.URLCodecUtils;

@PropInfo(name="\u9009\u9879")
public class NoCodeComboProp
extends ComboProp
implements NoCodeProp,
INoCodeComboProp {
    private static final Log logger = LogFactory.getLog(NoCodeComboProp.class);
    private static final long serialVersionUID = 4301567940143060512L;
    private String noCodeDefValue;

    public List<ValueMapItem> getFormattedValueMapItemList(String name) {
        ValueMapItem mapItem = super.getValueMapItemByName(name);
        if (Objects.isNull(mapItem)) {
            name = URLCodecUtils.decode((String)name);
            mapItem = new ValueMapItem("", name, new LocaleString(name));
        }
        return Lists.newArrayList((Object[])new ValueMapItem[]{mapItem});
    }

    public boolean isEnableNull() {
        return true;
    }

    public List<AbstractValidator> getValidators() {
        List validators = super.getValidators();
        if (this.isMustInput()) {
            validators.removeIf(RequiredValidator.class::isInstance);
            NoCodeRequiredValidator requiredValidator = new NoCodeRequiredValidator(this.getCompareProp(), this.getName(), this.getDisplayName().toString(), this.getValueComparator());
            validators.add(requiredValidator);
        }
        return validators;
    }

    public void applyDefaultValue(IDataModel model, DynamicObject dataEntity, int rowIndex) {
        this.calcDefaultValue(model, dataEntity, rowIndex, (IFieldHandle)this);
    }

    @Override
    @SimplePropertyAttribute
    public String getNoCodeDefValue() {
        return this.noCodeDefValue;
    }

    public void setNoCodeDefValue(String noCodeDefValue) {
        this.noCodeDefValue = noCodeDefValue;
    }

    public String getItemByName(String name) {
        String itemName = super.getItemByName(name);
        if (StringUtils.isNotEmpty((CharSequence)itemName)) {
            return itemName;
        }
        return URLCodecUtils.decode((String)name);
    }

    public boolean isMultiSelect() {
        return false;
    }

    @Override
    public Object getDBValue(Object value, IDataEntityProperty sourceProp) {
        String val = value == null ? "" : (String)value;
        return this.getItemByName(val);
    }

    @Override
    public void setDBValue(IDataModel model, String fieldKey, Object value) {
        this.setDBValue(model, fieldKey, value, -1);
    }

    @Override
    public void setDBValue(IDataModel model, String fieldKey, Object value, int rowIndex) {
        if (!NoCodeProp.canSetDBValue(model, fieldKey)) {
            return;
        }
        if (StringUtils.isBlank((Object)value)) {
            model.setValue(fieldKey, null);
            return;
        }
        String val = value.toString();
        val = val.replaceAll("\\n", ",");
        value = URLCodecUtils.encode((String)val);
        model.setValue(fieldKey, value, rowIndex);
    }
}

