/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.property;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.RowOperateType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.nocode.ext.property.NoCodeProp;
import kd.bos.nocode.ext.property.annotations.PropInfo;
import kd.bos.nocode.metadata.IDateFormatSupport;
import kd.bos.nocode.utils.DateTimeUtils;

@PropInfo(name="\u521b\u5efa\u65e5\u671f")
public class NoCodeCreateDateProp
extends CreateDateProp
implements NoCodeProp,
IDateFormatSupport {
    private static final long serialVersionUID = 2518720540004401046L;

    public void applyDefaultValue(IDataModel model, DynamicObject dataEntity, int rowIndex) {
        model.setValue((IDataEntityProperty)this, dataEntity, (Object)DateTimeUtils.getNow());
    }

    public Object getSaveValue(Object dataEntity, OperateOption option, RowOperateType type) {
        if (type == RowOperateType.Insert) {
            return DateTimeUtils.getNow();
        }
        return super.getSaveValue(dataEntity, option, type);
    }

    public boolean isEnableNull() {
        return true;
    }

    public int getFeatures() {
        return super.getFeatures();
    }

    public String getFormatType() {
        return "0";
    }

    @Override
    public Object getDBValue(Object value, IDataEntityProperty sourceProp) {
        return this.convertDateValue(value);
    }

    private String convertDateValue(Object val) {
        SimpleDateFormat sdf = new SimpleDateFormat(DateTimeUtils.getFormatString((String)this.getFormatType()));
        if (val != null) {
            String str = sdf.format((Date)val);
            return str;
        }
        return "";
    }

    @Override
    public void setDBValue(IDataModel model, String fieldKey, Object value) {
        this.setDBValue(model, fieldKey, value, -1);
    }

    @Override
    public void setDBValue(IDataModel model, String fieldKey, Object value, int rowIndex) {
        if (!NoCodeProp.canSetDBValue(model, fieldKey)) {
            return;
        }
        if (StringUtils.isBlank((Object)value)) {
            model.setValue(fieldKey, null);
            return;
        }
        if (value instanceof String) {
            value = value.toString().replaceAll("\\n", ",");
            value = value.toString().replaceAll("/", "-").replaceAll(ResManager.loadKDString((String)"\u5e74", (String)"NoCodeCreateDateProp_1", (String)"bos-nocode-ext", (Object[])new Object[0]), "-").replaceAll(ResManager.loadKDString((String)"\u6708", (String)"NoCodeCreateDateProp_2", (String)"bos-nocode-ext", (Object[])new Object[0]), "-").replaceAll(ResManager.loadKDString((String)"\u65e5", (String)"NoCodeCreateDateProp_3", (String)"bos-nocode-ext", (Object[])new Object[0]), "-");
        }
        model.setValue(fieldKey, value, rowIndex);
    }
}

