/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.property;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.RequiredValidator;
import kd.bos.nocode.ext.property.NoCodeProp;
import kd.bos.nocode.ext.property.annotations.PropInfo;
import kd.bos.nocode.ext.validate.NoCodeRequiredValidator;
import kd.bos.nocode.metadata.IDateFormatSupport;
import kd.bos.nocode.utils.DateTimeUtils;

@PropInfo(name="\u65e5\u671f")
public class NoCodeDateTimeProp
extends DateTimeProp
implements NoCodeProp,
IDateFormatSupport {
    private static final long serialVersionUID = 2947249787910350864L;
    private String formatType = "1";
    private String noCodeDefValue;

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="1")
    public String getFormatType() {
        return this.formatType;
    }

    public void setFormatType(String formatType) {
        this.formatType = formatType;
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat(this.getFormatString());
    }

    public String getClientType() {
        String clientType;
        switch (this.formatType) {
            case "1": {
                clientType = "date";
                break;
            }
            case "2": {
                clientType = "month";
                break;
            }
            case "3": {
                clientType = "year";
                break;
            }
            default: {
                clientType = "datetime";
            }
        }
        return clientType;
    }

    public String getFilterControlType() {
        String filterControlType = super.getFilterControlType();
        switch (this.formatType) {
            case "1": {
                filterControlType = "date";
                break;
            }
            case "2": {
                filterControlType = "month";
                break;
            }
            case "3": {
                filterControlType = "year";
                break;
            }
            default: {
                filterControlType = "datetime";
            }
        }
        return filterControlType;
    }

    public String getFormatString() {
        return DateTimeUtils.getFormatString((String)this.getFormatType());
    }

    public void applyDefaultValue(IDataModel model, DynamicObject dataEntity, int rowIndex) {
        this.calcDefaultValue(model, dataEntity, rowIndex, (IFieldHandle)this);
    }

    @Override
    public Object formatDefValue(Object value) {
        if (value != null) {
            if (value instanceof Date) {
                return value;
            }
            try {
                return DateTimeUtils.parseDate((String)value.toString());
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public boolean isEnableNull() {
        return true;
    }

    public List<AbstractValidator> getValidators() {
        List validators = super.getValidators();
        if (this.isMustInput()) {
            validators.removeIf(RequiredValidator.class::isInstance);
            NoCodeRequiredValidator requiredValidator = new NoCodeRequiredValidator(this.getCompareProp(), this.getName(), this.getDisplayName().toString(), this.getValueComparator());
            validators.add(requiredValidator);
        }
        return validators;
    }

    @Override
    @SimplePropertyAttribute
    public String getNoCodeDefValue() {
        return this.noCodeDefValue;
    }

    public void setNoCodeDefValue(String noCodeDefValue) {
        this.noCodeDefValue = noCodeDefValue;
    }

    public void setValue(Object dataEntity, Object value) {
        super.setValue(dataEntity, this.tryConvertValue(value));
    }

    public void setFieldValue(IDataModel model, Object dataEntity, Object value) {
        super.setFieldValue(model, dataEntity, this.tryConvertValue(value));
    }

    @Override
    public Object getDBValue(Object value, IDataEntityProperty sourceProp) {
        if (sourceProp instanceof DateTimeProp) {
            return value;
        }
        return this.convertDateValue(value);
    }

    private String convertDateValue(Object val) {
        SimpleDateFormat sdf = new SimpleDateFormat(this.getFormatString());
        if (val != null) {
            String str = sdf.format((Date)val);
            return str;
        }
        return "";
    }

    @Override
    public void setDBValue(IDataModel model, String fieldKey, Object value) {
        this.setDBValue(model, fieldKey, value, -1);
    }

    @Override
    public void setDBValue(IDataModel model, String fieldKey, Object value, int rowIndex) {
        if (!NoCodeProp.canSetDBValue(model, fieldKey)) {
            return;
        }
        if (StringUtils.isBlank((Object)value)) {
            model.setValue(fieldKey, null);
            return;
        }
        if (value instanceof String) {
            value = value.toString().replaceAll("\\n", ",");
            value = value.toString().replaceAll("/", "-").replaceAll(ResManager.loadKDString((String)"\u5e74", (String)"NoCodeDateTimeProp_1", (String)"bos-nocode-ext", (Object[])new Object[0]), "-").replaceAll(ResManager.loadKDString((String)"\u6708", (String)"NoCodeDateTimeProp_2", (String)"bos-nocode-ext", (Object[])new Object[0]), "-").replaceAll(ResManager.loadKDString((String)"\u65e5", (String)"NoCodeDateTimeProp_3", (String)"bos-nocode-ext", (Object[])new Object[0]), "-");
        }
        model.setValue(fieldKey, value, rowIndex);
    }
}

