/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.property;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.List;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeDataRangeField;
import kd.bos.nocode.ext.operation.validate.MinMaxCountValidator;
import kd.bos.nocode.ext.property.NoCodeProp;
import kd.bos.nocode.ext.property.annotations.PropInfo;
import kd.bos.nocode.metadata.IDecimalFormatSupport;

@PropInfo(name="\u6570\u5b57")
public class NoCodeDecimalProp
extends DecimalProp
implements NoCodeProp,
IDecimalFormatSupport {
    private static final long serialVersionUID = -1691860683817723206L;
    private static final Log logger = LogFactory.getLog(NoCodeDecimalProp.class);
    private String decimalDataType = "digit";
    private int scale = 2;
    private boolean thousandsSeparator = false;
    private NoCodeDataRangeField dataRange;
    private String noCodeDefValue;

    @ComplexPropertyAttribute(name="dataRange")
    public NoCodeDataRangeField getDataRange() {
        return this.dataRange;
    }

    public void setDataRange(NoCodeDataRangeField dataRange) {
        this.dataRange = dataRange;
    }

    @SimplePropertyAttribute(name="ThousandsSeparator")
    public boolean getThousandsSeparator() {
        return this.thousandsSeparator;
    }

    public void setThousandsSeparator(boolean thousandsSeparator) {
        this.thousandsSeparator = thousandsSeparator;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="2")
    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    @SimplePropertyAttribute(name="DecimalDataType")
    @DefaultValueAttribute(value="digit")
    public String getDecimalDataType() {
        return this.decimalDataType;
    }

    public void setDecimalDataType(String decimalDataType) {
        this.decimalDataType = decimalDataType;
    }

    public boolean isDigit() {
        return "digit".equals(this.getDecimalDataType());
    }

    public void applyDefaultValue(IDataModel model, DynamicObject dataEntity, int rowIndex) {
        this.calcDefaultValue(model, dataEntity, rowIndex, (IFieldHandle)this);
    }

    @Override
    @SimplePropertyAttribute
    public String getNoCodeDefValue() {
        return this.noCodeDefValue;
    }

    public void setNoCodeDefValue(String noCodeDefValue) {
        this.noCodeDefValue = noCodeDefValue;
    }

    public List<AbstractValidator> getValidators() {
        List validators = super.getValidators();
        validators.add(new MinMaxCountValidator((DynamicProperty)this, this.getName(), this.getDisplayName().toString()));
        return validators;
    }

    public String getDataScopeMessage(Object fldValue) {
        if (fldValue instanceof BigDecimal) {
            fldValue = ((BigDecimal)fldValue).toPlainString();
        }
        return ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u7684\u503c%2$s\u8d85\u51fa\u9650\u5b9a\u8303\u56f4%3$s", (String)"NoCodeDecimalProp_1", (String)"BOS_NOCODE", (Object[])new Object[]{this.getDisplayName() == null ? this.getName() : this.getDisplayName().toString(), fldValue, this.getDataScope()});
    }

    public void setValue(Object dataEntity, Object value) {
        super.setValue(dataEntity, this.tryConvertValue(value));
    }

    @Override
    public Object tryConvertValue(Object value) {
        int valuePrecision;
        Object newValue = NoCodeProp.super.tryConvertValue(value);
        if (newValue == null || !(newValue instanceof BigDecimal)) {
            return null;
        }
        if (!this.checkScope(value)) {
            return null;
        }
        BigDecimal newVal = (BigDecimal)newValue;
        if (newVal.scale() > this.getScale()) {
            newVal = newVal.setScale(this.getScale(), 4);
        }
        if ((valuePrecision = newVal.precision()) > this.getPrecision()) {
            return null;
        }
        return newVal;
    }

    public void setFieldValue(IDataModel model, Object dataEntity, Object value) {
        super.setFieldValue(model, dataEntity, this.tryConvertValue(value));
    }

    @Override
    public void setDBValue(IDataModel model, String fieldKey, Object value) {
        this.setDBValue(model, fieldKey, value, -1);
    }

    @Override
    public void setDBValue(IDataModel model, String fieldKey, Object value, int rowIndex) {
        if (!NoCodeProp.canSetDBValue(model, fieldKey)) {
            return;
        }
        if (StringUtils.isBlank((Object)value)) {
            model.setValue(fieldKey, null);
            return;
        }
        value = value.toString().replaceAll("\\n", ",");
        model.setValue(fieldKey, value, rowIndex);
    }

    @Override
    public Object getDBValue(Object value, IDataEntityProperty sourceProp) {
        if (sourceProp instanceof DecimalProp || value == null) {
            return value;
        }
        return this.getFormattedValue(value);
    }

    public Object getFormattedValue(Object value) {
        if (this.getThousandsSeparator() && value != null) {
            StringBuilder pattern = new StringBuilder("##,##0");
            int tempScale = this.getScale();
            if (tempScale > 0) {
                pattern.append(".");
                while (tempScale-- > 0) {
                    pattern.append("0");
                }
            }
            DecimalFormat format = new DecimalFormat(pattern.toString());
            value = format.format(value);
        }
        return value;
    }

    public Object getOriginalValue(Object formattedValue) {
        return formattedValue == null ? null : formattedValue.toString().replace(",", "");
    }
}

