/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.property;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.DynamicObjectParamUtils;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.RowOperateType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.nocode.ext.property.NoCodeProp;
import kd.bos.nocode.ext.property.annotations.PropInfo;
import kd.bos.nocode.metadata.IDateFormatSupport;
import kd.bos.nocode.utils.DateTimeUtils;

@PropInfo(name="\u4fee\u6539\u65e5\u671f")
public class NoCodeModifyDateProp
extends ModifyDateProp
implements NoCodeProp,
IDateFormatSupport {
    private static final long serialVersionUID = -7151698841486836444L;

    public void applyDefaultValue(IDataModel model, DynamicObject dataEntity, int rowIndex) {
        if (DynamicObjectParamUtils.isEnableUpdateModify()) {
            Date now = DateTimeUtils.getNow();
            model.setValue((IDataEntityProperty)this, dataEntity, (Object)now);
        } else {
            super.applyDefaultValue(model, dataEntity, rowIndex);
        }
    }

    public Object getSaveValue(Object dataEntity, OperateOption option, RowOperateType type) {
        boolean updateModify = Boolean.parseBoolean(option.getVariableValue("updateModifyDate", "true"));
        if (updateModify && DynamicObjectParamUtils.isEnableUpdateModify()) {
            this.setValue(dataEntity, DateTimeUtils.getNow());
        }
        return this.getValueFast(dataEntity);
    }

    public boolean isEnableNull() {
        return true;
    }

    public int getFeatures() {
        return super.getFeatures();
    }

    public String getFormatType() {
        return "0";
    }

    @Override
    public Object getDBValue(Object value, IDataEntityProperty sourceProp) {
        return this.convertDateValue(value);
    }

    private String convertDateValue(Object val) {
        SimpleDateFormat sdf = new SimpleDateFormat(DateTimeUtils.getFormatString((String)this.getFormatType()));
        if (val != null) {
            String str = sdf.format((Date)val);
            return str;
        }
        return "";
    }

    @Override
    public void setDBValue(IDataModel model, String fieldKey, Object value) {
        this.setDBValue(model, fieldKey, value, -1);
    }

    @Override
    public void setDBValue(IDataModel model, String fieldKey, Object value, int rowIndex) {
        if (!NoCodeProp.canSetDBValue(model, fieldKey)) {
            return;
        }
        if (StringUtils.isBlank((Object)value)) {
            model.setValue(fieldKey, null);
            return;
        }
        if (value instanceof String) {
            value = value.toString().replaceAll("\\n", ",");
            value = value.toString().replaceAll("/", "-").replaceAll(ResManager.loadKDString((String)"\u5e74", (String)"NoCodeModifyDateProp_1", (String)"bos-nocode-ext", (Object[])new Object[0]), "-").replaceAll(ResManager.loadKDString((String)"\u6708", (String)"NoCodeModifyDateProp_2", (String)"bos-nocode-ext", (Object[])new Object[0]), "-").replaceAll(ResManager.loadKDString((String)"\u65e5", (String)"NoCodeModifyDateProp_3", (String)"bos-nocode-ext", (Object[])new Object[0]), "-");
        }
        model.setValue(fieldKey, value, rowIndex);
    }
}

