/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ComboPropShowStyle;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntityTreeNode;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.ext.operation.validate.MinMaxCountValidator;
import kd.bos.nocode.ext.property.NoCodeComboProp;
import kd.bos.nocode.ext.property.NoCodeProp;
import kd.bos.nocode.ext.property.annotations.PropInfo;
import kd.bos.nocode.property.INoCodeComboProp;
import kd.bos.nocode.utils.URLCodecUtils;
import kd.bos.script.annotations.KSMethod;
import org.apache.logging.log4j.util.Strings;

@PropInfo(name="\u9009\u9879")
public class NoCodeMulComboProp
extends NoCodeComboProp
implements NoCodeProp,
INoCodeComboProp {
    private static final Log logger = LogFactory.getLog(NoCodeMulComboProp.class);
    private static final long serialVersionUID = -6748248592782692273L;
    private int minCount = 0;
    private int maxCount = 1;
    private String noCodeDefValue;

    public void setFieldValueForWebApi(IDataModel model, Object dataEntity, Object value, boolean checkImportable) {
        super.setFieldValueForWebApi(model, dataEntity, this.fixValue(value), checkImportable);
    }

    private Object fixValue(Object value) {
        Object newValue = value;
        if (value != null) {
            List splitValues = Arrays.asList(value.toString().split("\\,")).stream().filter(t -> !Strings.isBlank((String)t)).collect(Collectors.toList());
            newValue = Strings.join(splitValues, (char)',');
        }
        return newValue;
    }

    public void setFieldValue(IDataModel model, Object dataEntity, Object value) {
        super.setFieldValue(model, dataEntity, this.fixValue(value));
    }

    @Override
    public String getItemByName(String name) {
        String[] items = name.split(",");
        ArrayList<String> itemNameList = new ArrayList<String>();
        for (int i = 0; i < items.length; ++i) {
            String itemName;
            if (StringUtils.isEmpty((CharSequence)items[i]) || !StringUtils.isNotEmpty((CharSequence)(itemName = super.getItemByName(items[i])))) continue;
            itemNameList.add(itemName);
        }
        return StringUtils.join((Object[])itemNameList.toArray(), (String)",");
    }

    @KSMethod
    public Object getItemByNameAndShowStyle(String name, int showStyleId) {
        String[] items = name.split(",");
        String[] itemName = new String[items.length];
        for (int i = 0; i < items.length; ++i) {
            ValueMapItem valueMapItem = this.getValueMapItemByName(items[i]);
            if (valueMapItem == null) continue;
            itemName[i] = showStyleId == ComboPropShowStyle.Img.getValue() ? valueMapItem.getImageKey() : valueMapItem.getName().toString();
        }
        return itemName;
    }

    public Map<String, Object> createEntityTreeNode(EntityTreeNode parentEntityTreeNode) {
        Map col = super.createEntityTreeNode(parentEntityTreeNode);
        col.put("Type", "MulComboListColumnAp");
        return col;
    }

    public String getClientType() {
        return "mulcombo";
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="0")
    public int getMinCount() {
        return this.minCount;
    }

    public void setMinCount(int minCount) {
        this.minCount = minCount;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="1")
    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    @Override
    public List<AbstractValidator> getValidators() {
        List<AbstractValidator> validators = super.getValidators();
        validators.add(new MinMaxCountValidator((DynamicProperty)this, this.getName(), this.getDisplayName().toString()));
        return validators;
    }

    @Override
    public List<ValueMapItem> getFormattedValueMapItemList(String name) {
        String[] items = name.split(",");
        ArrayList<ValueMapItem> itemList = new ArrayList<ValueMapItem>(items.length);
        for (String item : items) {
            List<ValueMapItem> formattedValueMapItemList = super.getFormattedValueMapItemList(item);
            itemList.addAll(formattedValueMapItemList);
        }
        return itemList;
    }

    @Override
    public boolean isEnableNull() {
        return true;
    }

    @Override
    public void applyDefaultValue(IDataModel model, DynamicObject dataEntity, int rowIndex) {
        this.calcDefaultValue(model, dataEntity, rowIndex, (IFieldHandle)this);
    }

    @Override
    @SimplePropertyAttribute
    public String getNoCodeDefValue() {
        return this.noCodeDefValue;
    }

    @Override
    public void setNoCodeDefValue(String noCodeDefValue) {
        this.noCodeDefValue = noCodeDefValue;
    }

    @Override
    public boolean isMultiSelect() {
        return true;
    }

    @Override
    public void setDBValue(IDataModel model, String fieldKey, Object value) {
        this.setDBValue(model, fieldKey, value, -1);
    }

    @Override
    public void setDBValue(IDataModel model, String fieldKey, Object value, int rowIndex) {
        if (!NoCodeProp.canSetDBValue(model, fieldKey)) {
            return;
        }
        if (StringUtils.isBlank((Object)value)) {
            model.setValue(fieldKey, null);
            return;
        }
        String encodedValue = Arrays.stream((value = value.toString().replaceAll("\\n", ",")).toString().split(",")).map(URLCodecUtils::encode).filter(Objects::nonNull).collect(Collectors.joining(","));
        if (!encodedValue.isEmpty()) {
            model.setValue(fieldKey, (Object)encodedValue, rowIndex);
        }
    }

    @Override
    public Object getDBValue(Object value, IDataEntityProperty sourceProp) {
        if (StringUtils.isBlank((Object)value)) {
            return value;
        }
        if (sourceProp instanceof NoCodeComboProp && !(sourceProp instanceof NoCodeMulComboProp)) {
            value = value.toString().split(",")[0];
        }
        return super.getDBValue(value, sourceProp);
    }
}

